/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLowerDeck is the corresponding interface of BACnetConstructedDataLowerDeck
type BACnetConstructedDataLowerDeck interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLowerDeck returns LowerDeck (property field)
	GetLowerDeck() BACnetApplicationTagObjectIdentifier
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagObjectIdentifier
	// IsBACnetConstructedDataLowerDeck is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLowerDeck()
	// CreateBuilder creates a BACnetConstructedDataLowerDeckBuilder
	CreateBACnetConstructedDataLowerDeckBuilder() BACnetConstructedDataLowerDeckBuilder
}

// _BACnetConstructedDataLowerDeck is the data-structure of this message
type _BACnetConstructedDataLowerDeck struct {
	BACnetConstructedDataContract
	LowerDeck BACnetApplicationTagObjectIdentifier
}

var _ BACnetConstructedDataLowerDeck = (*_BACnetConstructedDataLowerDeck)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLowerDeck)(nil)

// NewBACnetConstructedDataLowerDeck factory function for _BACnetConstructedDataLowerDeck
func NewBACnetConstructedDataLowerDeck(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, lowerDeck BACnetApplicationTagObjectIdentifier, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLowerDeck {
	if lowerDeck == nil {
		panic("lowerDeck of type BACnetApplicationTagObjectIdentifier for BACnetConstructedDataLowerDeck must not be nil")
	}
	_result := &_BACnetConstructedDataLowerDeck{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LowerDeck:                     lowerDeck,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLowerDeckBuilder is a builder for BACnetConstructedDataLowerDeck
type BACnetConstructedDataLowerDeckBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lowerDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataLowerDeckBuilder
	// WithLowerDeck adds LowerDeck (property field)
	WithLowerDeck(BACnetApplicationTagObjectIdentifier) BACnetConstructedDataLowerDeckBuilder
	// WithLowerDeckBuilder adds LowerDeck (property field) which is build by the builder
	WithLowerDeckBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetConstructedDataLowerDeckBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLowerDeck or returns an error if something is wrong
	Build() (BACnetConstructedDataLowerDeck, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLowerDeck
}

// NewBACnetConstructedDataLowerDeckBuilder() creates a BACnetConstructedDataLowerDeckBuilder
func NewBACnetConstructedDataLowerDeckBuilder() BACnetConstructedDataLowerDeckBuilder {
	return &_BACnetConstructedDataLowerDeckBuilder{_BACnetConstructedDataLowerDeck: new(_BACnetConstructedDataLowerDeck)}
}

type _BACnetConstructedDataLowerDeckBuilder struct {
	*_BACnetConstructedDataLowerDeck

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLowerDeckBuilder) = (*_BACnetConstructedDataLowerDeckBuilder)(nil)

func (b *_BACnetConstructedDataLowerDeckBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLowerDeck
}

func (b *_BACnetConstructedDataLowerDeckBuilder) WithMandatoryFields(lowerDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataLowerDeckBuilder {
	return b.WithLowerDeck(lowerDeck)
}

func (b *_BACnetConstructedDataLowerDeckBuilder) WithLowerDeck(lowerDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataLowerDeckBuilder {
	b.LowerDeck = lowerDeck
	return b
}

func (b *_BACnetConstructedDataLowerDeckBuilder) WithLowerDeckBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetConstructedDataLowerDeckBuilder {
	builder := builderSupplier(b.LowerDeck.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.LowerDeck, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLowerDeckBuilder) Build() (BACnetConstructedDataLowerDeck, error) {
	if b.LowerDeck == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'lowerDeck' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLowerDeck.deepCopy(), nil
}

func (b *_BACnetConstructedDataLowerDeckBuilder) MustBuild() BACnetConstructedDataLowerDeck {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLowerDeckBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLowerDeckBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLowerDeckBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLowerDeckBuilder().(*_BACnetConstructedDataLowerDeckBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLowerDeckBuilder creates a BACnetConstructedDataLowerDeckBuilder
func (b *_BACnetConstructedDataLowerDeck) CreateBACnetConstructedDataLowerDeckBuilder() BACnetConstructedDataLowerDeckBuilder {
	if b == nil {
		return NewBACnetConstructedDataLowerDeckBuilder()
	}
	return &_BACnetConstructedDataLowerDeckBuilder{_BACnetConstructedDataLowerDeck: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLowerDeck) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLowerDeck) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOWER_DECK
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLowerDeck) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLowerDeck) GetLowerDeck() BACnetApplicationTagObjectIdentifier {
	return m.LowerDeck
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLowerDeck) GetActualValue() BACnetApplicationTagObjectIdentifier {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagObjectIdentifier(m.GetLowerDeck())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLowerDeck(structType any) BACnetConstructedDataLowerDeck {
	if casted, ok := structType.(BACnetConstructedDataLowerDeck); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLowerDeck); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLowerDeck) GetTypeName() string {
	return "BACnetConstructedDataLowerDeck"
}

func (m *_BACnetConstructedDataLowerDeck) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (lowerDeck)
	lengthInBits += m.LowerDeck.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLowerDeck) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLowerDeck) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLowerDeck BACnetConstructedDataLowerDeck, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLowerDeck"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLowerDeck")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lowerDeck, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "lowerDeck", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lowerDeck' field"))
	}
	m.LowerDeck = lowerDeck

	actualValue, err := ReadVirtualField[BACnetApplicationTagObjectIdentifier](ctx, "actualValue", (*BACnetApplicationTagObjectIdentifier)(nil), lowerDeck)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLowerDeck"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLowerDeck")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLowerDeck) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLowerDeck) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLowerDeck"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLowerDeck")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "lowerDeck", m.GetLowerDeck(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lowerDeck' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLowerDeck"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLowerDeck")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLowerDeck) IsBACnetConstructedDataLowerDeck() {}

func (m *_BACnetConstructedDataLowerDeck) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLowerDeck) deepCopy() *_BACnetConstructedDataLowerDeck {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLowerDeckCopy := &_BACnetConstructedDataLowerDeck{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.LowerDeck),
	}
	_BACnetConstructedDataLowerDeckCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLowerDeckCopy
}

func (m *_BACnetConstructedDataLowerDeck) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
