/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.DistributedWorkQueueWorkAssignerHelper;
import org.apache.accumulo.server.replication.ReplicaSystem;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.ReplicaSystemHelper;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationProcessor
implements DistributedWorkQueue.Processor {
    private static final Logger log = LoggerFactory.getLogger(ReplicationProcessor.class);
    private final ClientContext context;
    private final AccumuloConfiguration conf;
    private final VolumeManager fs;
    private final ReplicaSystemHelper helper;
    private final ReplicaSystemFactory factory;

    public ReplicationProcessor(ClientContext context, AccumuloConfiguration conf, VolumeManager fs) {
        this.context = context;
        this.conf = conf;
        this.fs = fs;
        this.helper = new ReplicaSystemHelper(context);
        this.factory = new ReplicaSystemFactory();
    }

    public ReplicationProcessor newProcessor() {
        return new ReplicationProcessor(this.context, this.context.getConfiguration(), this.fs);
    }

    public void process(String workID, byte[] data) {
        Replication.Status status;
        ReplicaSystem replica;
        ReplicationTarget target = (ReplicationTarget)DistributedWorkQueueWorkAssignerHelper.fromQueueKey((String)workID).getValue();
        String file = new String(data, StandardCharsets.UTF_8);
        log.debug("Received replication work for {} to {}", (Object)file, (Object)target);
        try {
            replica = this.getReplicaSystem(target);
        }
        catch (Exception e) {
            log.error("Could not instantiate ReplicaSystem for {}, waiting before returning the work", (Object)target, (Object)e);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        try {
            status = this.getStatus(file, target);
        }
        catch (AccumuloException | AccumuloSecurityException | ReplicationTableOfflineException e) {
            log.error("Could not look for replication record", e);
            throw new IllegalStateException("Could not look for replication record", e);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Could not deserialize Status from Work section for {} and ", (Object)file, (Object)target);
            throw new RuntimeException("Could not parse Status for work record", e);
        }
        catch (NoSuchElementException e) {
            log.error("Assigned work for {} to {} but could not find work record", (Object)file, (Object)target);
            return;
        }
        log.debug("Current status for {} replicating to {}: {}", new Object[]{file, target, ProtobufUtil.toString((GeneratedMessage)status)});
        if (!StatusUtil.isWorkRequired((Replication.Status)status)) {
            log.info("Received work request for {} and {}, but it does not need replication. Ignoring...", (Object)file, (Object)target);
            return;
        }
        Path filePath = new Path(file);
        try {
            if (!this.doesFileExist(filePath, target)) {
                return;
            }
        }
        catch (IOException e) {
            log.error("Could not determine if file exists {}", (Object)filePath, (Object)e);
            throw new RuntimeException(e);
        }
        log.debug("Replicating {} to {} using {}", new Object[]{filePath, target, replica.getClass().getName()});
        Replication.Status newStatus = replica.replicate(filePath, status, target, this.getHelper());
        log.debug("Finished replicating {}. Original status: {}, New status: {}", new Object[]{filePath, status, newStatus});
    }

    protected ReplicaSystemHelper getHelper() {
        return this.helper;
    }

    protected ReplicaSystem getReplicaSystem(ReplicationTarget target) {
        String peerType = this.getPeerType(target.getPeerName());
        return this.factory.get(peerType);
    }

    protected String getPeerType(String peerName) {
        Map configuredPeers = this.conf.getAllPropertiesWithPrefix(Property.REPLICATION_PEERS);
        String peerType = (String)configuredPeers.get(Property.REPLICATION_PEERS.getKey() + peerName);
        if (null == peerType) {
            String msg = "Cannot process replication for unknown peer: " + peerName;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        return peerType;
    }

    protected boolean doesFileExist(Path filePath, ReplicationTarget target) throws IOException {
        if (!this.fs.exists(filePath)) {
            log.warn("Received work request for {} and {}, but the file doesn't exist", (Object)filePath, (Object)target);
            return false;
        }
        return true;
    }

    protected Replication.Status getStatus(String file, ReplicationTarget target) throws ReplicationTableOfflineException, AccumuloException, AccumuloSecurityException, InvalidProtocolBufferException {
        Scanner s = ReplicationTable.getScanner((Connector)this.context.getConnector());
        s.setRange(Range.exact((CharSequence)file));
        s.fetchColumn(ReplicationSchema.WorkSection.NAME, target.toText());
        return Replication.Status.parseFrom((byte[])((Value)((Map.Entry)Iterables.getOnlyElement((Iterable)s)).getValue()).get());
    }
}

