/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSorter {
    private static final Logger log = LoggerFactory.getLogger(LogSorter.class);
    VolumeManager fs;
    AccumuloConfiguration conf;
    private final Map<String, LogProcessor> currentWork = Collections.synchronizedMap(new HashMap());
    ThreadPoolExecutor threadPool;
    private final Instance instance;

    public LogSorter(Instance instance, VolumeManager fs, AccumuloConfiguration conf) {
        this.instance = instance;
        this.fs = fs;
        this.conf = conf;
        int threadPoolSize = conf.getCount(Property.TSERV_RECOVERY_MAX_CONCURRENT);
        this.threadPool = new SimpleThreadPool(threadPoolSize, this.getClass().getName());
    }

    public void startWatchingForRecoveryLogs(ThreadPoolExecutor distWorkQThreadPool) throws KeeperException, InterruptedException {
        this.threadPool = distWorkQThreadPool;
        new DistributedWorkQueue(ZooUtil.getRoot((Instance)this.instance) + "/recovery", this.conf).startProcessing((DistributedWorkQueue.Processor)new LogProcessor(), this.threadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryStatus> getLogSorts() {
        ArrayList<RecoveryStatus> result = new ArrayList<RecoveryStatus>();
        Map<String, LogProcessor> map = this.currentWork;
        synchronized (map) {
            for (Map.Entry<String, LogProcessor> entries : this.currentWork.entrySet()) {
                RecoveryStatus status = new RecoveryStatus();
                status.name = entries.getKey();
                try {
                    status.progress = (double)entries.getValue().getBytesCopied() / (0.0 + (double)this.conf.getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE));
                }
                catch (IOException ex) {
                    log.warn("Error getting bytes read");
                }
                status.runtime = (int)entries.getValue().getSortTime();
                result.add(status);
            }
            return result;
        }
    }

    class LogProcessor
    implements DistributedWorkQueue.Processor {
        private FSDataInputStream input;
        private DataInputStream decryptingInput;
        private long bytesCopied = -1L;
        private long sortStart = 0L;
        private long sortStop = -1L;

        LogProcessor() {
        }

        public DistributedWorkQueue.Processor newProcessor() {
            return new LogProcessor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String child, byte[] data) {
            String work = new String(data);
            String[] parts = work.split("\\|");
            String src = parts[0];
            String dest = parts[1];
            String sortId = new Path(src).getName();
            log.debug("Sorting " + src + " to " + dest + " using sortId " + sortId);
            Map map = LogSorter.this.currentWork;
            synchronized (map) {
                if (LogSorter.this.currentWork.containsKey(sortId)) {
                    return;
                }
                LogSorter.this.currentWork.put(sortId, this);
            }
            try {
                this.sort(sortId, new Path(src), dest);
            }
            finally {
                LogSorter.this.currentWork.remove(sortId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void sort(String name, Path srcPath, String destPath) {
            long bufferSize;
            FSDataInputStream fsinput;
            int part;
            String formerThreadName;
            block42: {
                LogProcessor logProcessor = this;
                // MONITORENTER : logProcessor
                this.sortStart = System.currentTimeMillis();
                // MONITOREXIT : logProcessor
                formerThreadName = Thread.currentThread().getName();
                part = 0;
                if (!LogSorter.this.fs.exists(SortedLogState.getFinishedMarkerPath((String)destPath))) break block42;
                log.debug("Sorting already finished at {}", (Object)destPath);
                Thread.currentThread().setName(formerThreadName);
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.error("Error during cleanup sort/copy " + name, (Throwable)e);
                }
                LogProcessor e = this;
                // MONITORENTER : e
                this.sortStop = System.currentTimeMillis();
                // MONITOREXIT : e
                return;
            }
            try {
                DfsLogger.DFSLoggerInputStreams inputStreams;
                log.info("Copying " + srcPath + " to " + destPath);
                LogSorter.this.fs.deleteRecursively(new Path(destPath));
                fsinput = LogSorter.this.fs.open(srcPath);
                try {
                    inputStreams = DfsLogger.readHeaderAndReturnStream(fsinput, LogSorter.this.conf);
                }
                catch (DfsLogger.LogHeaderIncompleteException e) {
                    log.warn("Could not read header from write-ahead log " + srcPath + ". Not sorting.");
                    LogSorter.this.fs.mkdirs(new Path(destPath));
                    this.writeBuffer(destPath, Collections.emptyList(), part++);
                    LogSorter.this.fs.create(SortedLogState.getFinishedMarkerPath((String)destPath)).close();
                    if (fsinput != null) {
                        fsinput.close();
                    }
                    Thread.currentThread().setName(formerThreadName);
                    try {
                        this.close();
                    }
                    catch (Exception e2) {
                        log.error("Error during cleanup sort/copy " + name, (Throwable)e2);
                    }
                    LogProcessor logProcessor = this;
                    // MONITORENTER : logProcessor
                    this.sortStop = System.currentTimeMillis();
                    // MONITOREXIT : logProcessor
                    return;
                }
                {
                    catch (Throwable inputStreams22) {
                        if (fsinput == null) throw inputStreams22;
                        try {
                            fsinput.close();
                            throw inputStreams22;
                        }
                        catch (Throwable throwable) {
                            inputStreams22.addSuppressed(throwable);
                        }
                        throw inputStreams22;
                    }
                }
                this.input = inputStreams.getOriginalInput();
                this.decryptingInput = inputStreams.getDecryptingInputStream();
                bufferSize = LogSorter.this.conf.getMemoryInBytes(Property.TSERV_SORT_BUFFER_SIZE);
                Thread.currentThread().setName("Sorting " + name + " for recovery");
            }
            catch (Throwable t) {
                try {
                    try {
                        LogSorter.this.fs.mkdirs(new Path(destPath));
                        LogSorter.this.fs.create(SortedLogState.getFailedMarkerPath((String)destPath)).close();
                    }
                    catch (IOException e) {
                        log.error("Error creating failed flag file " + name, (Throwable)e);
                    }
                    log.error("Caught throwable", t);
                    Thread.currentThread().setName(formerThreadName);
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setName(formerThreadName);
                    try {
                        this.close();
                    }
                    catch (Exception e) {
                        log.error("Error during cleanup sort/copy " + name, (Throwable)e);
                    }
                    LogProcessor logProcessor = this;
                    // MONITORENTER : logProcessor
                    this.sortStop = System.currentTimeMillis();
                    // MONITOREXIT : logProcessor
                    throw throwable;
                }
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.error("Error during cleanup sort/copy " + name, (Throwable)e);
                }
                LogProcessor logProcessor = this;
                // MONITORENTER : logProcessor
                this.sortStop = System.currentTimeMillis();
                // MONITOREXIT : logProcessor
                return;
            }
            while (true) {
                ArrayList<Pair<LogFileKey, LogFileValue>> buffer = new ArrayList<Pair<LogFileKey, LogFileValue>>();
                try {
                    long start = this.input.getPos();
                    while (this.input.getPos() - start < bufferSize) {
                        LogFileKey key = new LogFileKey();
                        LogFileValue value = new LogFileValue();
                        key.readFields(this.decryptingInput);
                        value.readFields(this.decryptingInput);
                        buffer.add((Pair<LogFileKey, LogFileValue>)new Pair((Object)key, (Object)value));
                    }
                    this.writeBuffer(destPath, buffer, part++);
                    buffer.clear();
                }
                catch (EOFException ex) {
                    this.writeBuffer(destPath, buffer, part++);
                    LogSorter.this.fs.create(new Path(destPath, "finished")).close();
                    log.info("Finished log sort " + name + " " + this.getBytesCopied() + " bytes " + part + " parts in " + this.getSortTime() + "ms");
                    if (fsinput == null) break;
                    fsinput.close();
                    break;
                }
            }
            Thread.currentThread().setName(formerThreadName);
            try {
                this.close();
            }
            catch (Exception e) {
                log.error("Error during cleanup sort/copy " + name, (Throwable)e);
            }
            LogProcessor e = this;
            // MONITORENTER : e
            this.sortStop = System.currentTimeMillis();
            // MONITOREXIT : e
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBuffer(String destPath, List<Pair<LogFileKey, LogFileValue>> buffer, int part) throws IOException {
            Path path = new Path(destPath, String.format("part-r-%05d", part));
            FileSystem ns = LogSorter.this.fs.getVolumeByPath(path).getFileSystem();
            try (MapFile.Writer output = new MapFile.Writer(ns.getConf(), ns.makeQualified(path), new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(LogFileKey.class), MapFile.Writer.valueClass(LogFileValue.class)});){
                Collections.sort(buffer, new Comparator<Pair<LogFileKey, LogFileValue>>(){

                    @Override
                    public int compare(Pair<LogFileKey, LogFileValue> o1, Pair<LogFileKey, LogFileValue> o2) {
                        return ((LogFileKey)o1.getFirst()).compareTo((LogFileKey)o2.getFirst());
                    }
                });
                for (Pair<LogFileKey, LogFileValue> entry : buffer) {
                    output.append((WritableComparable)entry.getFirst(), (Writable)entry.getSecond());
                }
            }
        }

        synchronized void close() throws IOException {
            if (null != this.input) {
                this.bytesCopied = this.input.getPos();
                this.input.close();
                this.decryptingInput.close();
                this.input = null;
            }
        }

        public synchronized long getSortTime() {
            if (this.sortStart > 0L) {
                if (this.sortStop > 0L) {
                    return this.sortStop - this.sortStart;
                }
                return System.currentTimeMillis() - this.sortStart;
            }
            return 0L;
        }

        synchronized long getBytesCopied() throws IOException {
            return this.input == null ? this.bytesCopied : this.input.getPos();
        }
    }
}

