/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.util.MetricsCache;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMetricsCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetricsCache.class);

    @Test
    public void testUpdate() {
        MetricsCache cache = new MetricsCache();
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 0), this.makeMetric("m1", 1)));
        MetricsCache.Record cr = cache.update(mr);
        ((MetricsRecord)Mockito.verify((Object)mr)).name();
        ((MetricsRecord)Mockito.verify((Object)mr)).tags();
        ((MetricsRecord)Mockito.verify((Object)mr)).metrics();
        Assert.assertEquals((String)"same record size", (long)cr.metrics().size(), (long)((Collection)mr.metrics()).size());
        Assert.assertEquals((String)"same metric value", (Object)0, (Object)cr.getMetric("m"));
        MetricsRecord mr2 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 2), this.makeMetric("m2", 42)));
        cr = cache.update(mr2);
        Assert.assertEquals((String)"contains 3 metric", (long)3L, (long)cr.metrics().size());
        this.checkMetricValue("updated metric value", cr, "m", 2);
        this.checkMetricValue("old metric value", cr, "m1", 1);
        this.checkMetricValue("new metric value", cr, "m2", 42);
        MetricsRecord mr3 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv3")), Arrays.asList(this.makeMetric("m3", 3)));
        cr = cache.update(mr3);
        Assert.assertEquals((String)"contains 1 metric", (long)1L, (long)cr.metrics().size());
        this.checkMetricValue("updated metric value", cr, "m3", 3);
        Assert.assertEquals((String)"no tags", (long)0L, (long)cr.tags().size());
        cr = cache.update(mr3, true);
        Assert.assertEquals((String)"Got 1 tag", (long)1L, (long)cr.tags().size());
        Assert.assertEquals((String)"Tag value", (Object)"tv3", (Object)cr.getTag("t"));
        this.checkMetricValue("Metric value", cr, "m3", 3);
    }

    @Test
    public void testGet() {
        MetricsCache cache = new MetricsCache();
        Assert.assertNull((String)"empty", (Object)cache.get("r", Arrays.asList(this.makeTag("t", "t"))));
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "t")), Arrays.asList(this.makeMetric("m", 1)));
        cache.update(mr);
        MetricsCache.Record cr = cache.get("r", mr.tags());
        LOG.debug("tags=" + mr.tags() + " cr=" + cr);
        Assert.assertNotNull((String)"Got record", (Object)cr);
        Assert.assertEquals((String)"contains 1 metric", (long)1L, (long)cr.metrics().size());
        this.checkMetricValue("new metric value", cr, "m", 1);
    }

    @Test
    public void testNullTag() {
        MetricsCache cache = new MetricsCache();
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", null)), Arrays.asList(this.makeMetric("m", 0), this.makeMetric("m1", 1)));
        MetricsCache.Record cr = cache.update(mr);
        Assert.assertTrue((String)"t value should be null", (null == cr.getTag("t") ? 1 : 0) != 0);
    }

    @Test
    public void testOverflow() {
        MetricsCache cache = new MetricsCache();
        List<MetricsTag> t0 = Arrays.asList(this.makeTag("t0", "0"));
        for (int i = 0; i < 1001; ++i) {
            MetricsCache.Record cr = cache.update(this.makeRecord("r", Arrays.asList(this.makeTag("t" + i, "" + i)), Arrays.asList(this.makeMetric("m", i))));
            this.checkMetricValue("new metric value", cr, "m", i);
            if (i >= 1000) continue;
            Assert.assertNotNull((String)"t0 is still there", (Object)cache.get("r", t0));
        }
        Assert.assertNull((String)"t0 is gone", (Object)cache.get("r", t0));
    }

    private void checkMetricValue(String description, MetricsCache.Record cr, String key, Number val) {
        Assert.assertEquals((String)description, (Object)val, (Object)cr.getMetric(key));
        Assert.assertNotNull((String)"metric not null", (Object)cr.getMetricInstance(key));
        Assert.assertEquals((String)description, (Object)val, (Object)cr.getMetricInstance(key).value());
    }

    private MetricsRecord makeRecord(String name, Collection<MetricsTag> tags, Collection<AbstractMetric> metrics) {
        MetricsRecord mr = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        Mockito.when((Object)mr.name()).thenReturn((Object)name);
        Mockito.when((Object)mr.tags()).thenReturn(tags);
        Mockito.when((Object)mr.metrics()).thenReturn(metrics);
        return mr;
    }

    private MetricsTag makeTag(String name, String value) {
        return new MetricsTag(Interns.info((String)name, (String)""), value);
    }

    private AbstractMetric makeMetric(String name, Number value) {
        AbstractMetric metric = (AbstractMetric)Mockito.mock(AbstractMetric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        return metric;
    }
}

