/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.net.NetUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGlobalFilter
extends HttpServerFunctionalTest {
    static final Logger LOG = LoggerFactory.getLogger(HttpServer2.class);
    static final Set<String> RECORDS = new TreeSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(String urlstring) throws IOException {
        LOG.warn("access " + urlstring);
        URL url = new URL(urlstring);
        URLConnection connection = url.openConnection();
        connection.connect();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            while (in.readLine() != null) {
            }
        }
        catch (IOException ioe) {
            LOG.warn("urlstring=" + urlstring, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletFilter() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", RecordingFilter.Initializer.class.getName());
        HttpServer2 http = TestGlobalFilter.createTestServer(conf);
        http.start();
        String fsckURL = "/fsck";
        String stacksURL = "/stacks";
        String ajspURL = "/a.jsp";
        String listPathsURL = "/listPaths";
        String dataURL = "/data";
        String streamFile = "/streamFile";
        String rootURL = "/";
        String allURL = "/*";
        String outURL = "/static/a.out";
        String logURL = "/logs/a.log";
        String[] urls = new String[]{"/fsck", "/stacks", "/a.jsp", "/listPaths", "/data", "/streamFile", "/", "/*", "/static/a.out", "/logs/a.log"};
        String prefix = "http://" + NetUtils.getHostPortString((InetSocketAddress)http.getConnectorAddress(0));
        try {
            for (i = 0; i < urls.length; ++i) {
                TestGlobalFilter.access(prefix + urls[i]);
            }
        }
        finally {
            http.stop();
        }
        LOG.info("RECORDS = " + RECORDS);
        for (i = 0; i < urls.length; ++i) {
            TestGlobalFilter.assertTrue((boolean)RECORDS.remove(urls[i]));
        }
        TestGlobalFilter.assertTrue((RECORDS.size() == 1 ? 1 : 0) != 0);
        TestGlobalFilter.assertTrue((boolean)RECORDS.contains("/index.html"));
    }

    public static class RecordingFilter
    implements Filter {
        private FilterConfig filterConfig = null;

        public void init(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public void destroy() {
            this.filterConfig = null;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.filterConfig == null) {
                return;
            }
            String uri = ((HttpServletRequest)request).getRequestURI();
            LOG.info("filtering " + uri);
            RECORDS.add(uri);
            chain.doFilter(request, response);
        }

        public static class Initializer
        extends FilterInitializer {
            public void initFilter(FilterContainer container, Configuration conf) {
                container.addGlobalFilter("recording", RecordingFilter.class.getName(), null);
            }
        }
    }
}

