/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.IOException;
import java.io.PushbackReader;
import sdsu.util.LabeledData;

public class CommentParser {
    private static final int EOF = -1;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final char RETURN = '\n';
    private static final char NEWLINE = '\r';
    private String whiteSpace = "\t\r\n ";
    private char commentChar;
    private char specialCommentChar;
    private PushbackReader input;

    public CommentParser(PushbackReader pushbackReader, char c, char c2) {
        this(pushbackReader, c, c2, "\t\n\r ");
    }

    public CommentParser(PushbackReader pushbackReader, char c, char c2, String string) {
        this.input = pushbackReader;
        this.commentChar = c;
        this.specialCommentChar = c2;
        this.whiteSpace = string;
    }

    public String readAll() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.removeWhiteSpace();
        int n = this.input.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = this.input.read();
        }
        return stringBuffer.toString();
    }

    public String readComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (!bl) {
            this.removeWhiteSpace();
            int n = this.input.read();
            int n2 = this.input.read();
            this.input.unread(n2);
            if (this.commentChar == (char)n && this.specialCommentChar != (char)n2) {
                stringBuffer.append(this.readLine());
                stringBuffer.append(lineSeparator);
                continue;
            }
            this.input.unread(n);
            bl = true;
        }
        return stringBuffer.toString();
    }

    public LabeledData readDataComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (!bl) {
            this.removeWhiteSpace();
            int n = this.input.read();
            int n2 = this.input.read();
            if (this.commentChar == (char)n && this.specialCommentChar == (char)n2) {
                stringBuffer.append(this.readLine());
                continue;
            }
            this.input.unread(n2);
            this.input.unread(n);
            bl = true;
        }
        LabeledData labeledData = new LabeledData();
        if (stringBuffer.length() > 0) {
            labeledData.fromString(stringBuffer.toString());
        }
        return labeledData;
    }

    private String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.input.read();
        while ((char)n != '\n' && (char)n != '\r') {
            stringBuffer.append((char)n);
            n = this.input.read();
        }
        return stringBuffer.toString();
    }

    public void removeWhiteSpace() throws IOException {
        int n = this.input.read();
        while (this.whiteSpace.indexOf((char)n) > -1) {
            n = this.input.read();
        }
        this.input.unread(n);
    }
}

