/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.util.ConfigurationValidator;

public class PropertiesUtil {
    private static final String DEFAULT_PROPERTIES_FILE = "/pig-default.properties";
    private static final String PROPERTIES_FILE = "/pig.properties";
    private static final Log log = LogFactory.getLog(PropertiesUtil.class);

    public static void loadDefaultProperties(Properties properties) {
        PropertiesUtil.loadPropertiesFromFile(properties, System.getProperty("user.home") + "/.pigrc");
        PropertiesUtil.loadPropertiesFromClasspath(properties, DEFAULT_PROPERTIES_FILE);
        PropertiesUtil.loadPropertiesFromClasspath(properties, PROPERTIES_FILE);
        PropertiesUtil.setDefaultsIfUnset(properties);
        if (log.isDebugEnabled()) {
            for (Object object : properties.keySet()) {
                String propertyName = (String)object;
                StringBuilder sb = new StringBuilder();
                sb.append("Found property ");
                sb.append(propertyName);
                sb.append("=");
                sb.append(properties.get(propertyName).toString());
                log.debug((Object)sb.toString());
            }
        }
        for (Map.Entry entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("sun.") || key.startsWith("java.")) continue;
            properties.put(key, entry.getValue());
        }
        ConfigurationValidator.validatePigProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPropertiesFromFile(Properties properties, String fileName) {
        BufferedInputStream bis = null;
        Properties pigrcProps = new Properties();
        try {
            File pigrcFile = new File(fileName);
            if (pigrcFile.exists()) {
                if (fileName.endsWith("/.pigrc")) {
                    log.warn((Object)(pigrcFile.getAbsolutePath() + " exists but will be deprecated soon. Use conf/pig.properties instead!"));
                }
                bis = new BufferedInputStream(new FileInputStream(pigrcFile));
                pigrcProps.load(bis);
            }
        }
        catch (Exception e) {
            log.error((Object)"unable to parse .pigrc :", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
        properties.putAll((Map<?, ?>)pigrcProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesFromClasspath(Properties properties, String fileName) {
        InputStream inputStream = null;
        Class<PropertiesUtil> clazz = PropertiesUtil.class;
        try {
            inputStream = clazz.getResourceAsStream(fileName);
            if (inputStream == null) {
                String msg = "no " + fileName + " configuration file available in the classpath";
                log.debug((Object)msg);
            } else {
                properties.load(inputStream);
            }
        }
        catch (Exception e) {
            log.error((Object)("unable to parse " + fileName + " :"), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void setDefaultsIfUnset(Properties properties) {
        if (properties.getProperty("aggregate.warning") == null) {
            properties.setProperty("aggregate.warning", "true");
        }
        if (properties.getProperty("opt.multiquery") == null) {
            properties.setProperty("opt.multiquery", "true");
        }
        if (properties.getProperty("stop.on.failure") == null) {
            properties.setProperty("stop.on.failure", "false");
        }
        if (properties.getProperty("opt.fetch") == null) {
            properties.setProperty("opt.fetch", "true");
        }
    }

    public static Properties loadDefaultProperties() {
        Properties properties = new Properties();
        PropertiesUtil.loadDefaultProperties(properties);
        return properties;
    }
}

