/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.impl.bloom.HashFunction;
import org.apache.pig.org.roaringbitmap.RoaringBitmap;

public class BloomFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog(BloomFilter.class);
    private static final int VERSION = 1;
    private HashFunction hash;
    private RoaringBitmap bitmap;
    private int hashAlgorithm;

    public BloomFilter() {
    }

    public BloomFilter(int vectorSize, int nbHash, int hashAlgorithm) {
        this.vectorSize = vectorSize;
        this.nbHash = nbHash;
        this.hashAlgorithm = hashAlgorithm;
        this.hash = new HashFunction(vectorSize, nbHash, hashAlgorithm);
        this.bitmap = new RoaringBitmap();
    }

    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        Arrays.sort(h);
        this.bitmap.or(RoaringBitmap.bitmapOf((int[])h));
    }

    public boolean membershipTest(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            if (this.bitmap.contains(h[i])) continue;
            return false;
        }
        return true;
    }

    public void and(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || ((BloomFilter)filter).vectorSize != this.vectorSize || ((BloomFilter)filter).nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        this.bitmap.and(((BloomFilter)filter).bitmap);
    }

    public void or(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || ((BloomFilter)filter).vectorSize != this.vectorSize || ((BloomFilter)filter).nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        this.bitmap.or(((BloomFilter)filter).bitmap);
    }

    public void xor(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || ((BloomFilter)filter).vectorSize != this.vectorSize || ((BloomFilter)filter).nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        this.bitmap.xor(((BloomFilter)filter).bitmap);
    }

    public void not() {
        this.bitmap.flip(0, this.vectorSize);
    }

    public String toString() {
        return this.bitmap.toString();
    }

    public int getVectorSize() {
        return this.vectorSize;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.nbHash);
        out.writeByte(this.hashAlgorithm);
        out.writeInt(this.vectorSize);
        this.bitmap.runOptimize();
        ByteArrayOutputStream bos = this.compressBitmap();
        LOG.info((Object)("Compressed bitmap from " + String.format("%,8d bytes", this.bitmap.getSizeInBytes()) + " to " + String.format("%,8d bytes", bos.size())));
        out.writeInt(bos.size());
        out.write(bos.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        int ver = in.readInt();
        if (ver != 1) {
            throw new IOException("Unsupported version: " + ver);
        }
        this.nbHash = in.readInt();
        this.hashAlgorithm = in.readByte();
        this.vectorSize = in.readInt();
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashAlgorithm);
        this.bitmap = new RoaringBitmap();
        int compressedSize = in.readInt();
        byte[] buf = new byte[compressedSize];
        in.readFully(buf);
        this.bitmap.deserialize(this.decompressBitmap(buf));
    }

    public static BloomFilter bloomIn(DataByteArray b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b.get()));
        BloomFilter f = new BloomFilter();
        f.readFields(dis);
        return f;
    }

    private ByteArrayOutputStream compressBitmap() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BZip2Codec bzip = new BZip2Codec();
        bzip.setConf(new Configuration(false));
        CompressionOutputStream compressionOut = bzip.createOutputStream((OutputStream)bos);
        DataOutputStream dos = new DataOutputStream((OutputStream)compressionOut);
        this.bitmap.serialize((DataOutput)dos);
        compressionOut.finish();
        dos.flush();
        return bos;
    }

    private DataInput decompressBitmap(byte[] buffer) throws IOException {
        ByteArrayInputStream deCompressedDataBuffer = new ByteArrayInputStream(buffer, 0, buffer.length);
        BZip2Codec bzip = new BZip2Codec();
        bzip.setConf(new Configuration(false));
        CompressionInputStream compressionIn = bzip.createInputStream((InputStream)deCompressedDataBuffer);
        DataInputStream inflateIn = new DataInputStream((InputStream)compressionIn);
        return inflateIn;
    }
}

