/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSortedDistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.impl.PigContext;

public class AccumulatorOptimizerUtil {
    private static final Log LOG = LogFactory.getLog(AccumulatorOptimizerUtil.class);

    public static int getAccumulativeBatchSize() {
        String size;
        int batchSize = 20000;
        if (PigMapReduce.sJobConfInternal.get() != null && (size = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.accumulative.batchsize")) != null) {
            batchSize = Integer.parseInt(size);
        }
        return batchSize;
    }

    public static void addAccumulator(PhysicalPlan plan, List<PhysicalOperator> pos) {
        boolean[] isInner;
        if (pos == null || pos.size() == 0) {
            return;
        }
        PhysicalOperator po_package = pos.get(0);
        if (!po_package.getClass().equals(POPackage.class)) {
            return;
        }
        Packager pkgr = ((POPackage)po_package).getPkgr();
        if (!pkgr.getClass().equals(Packager.class)) {
            return;
        }
        if (pkgr.isDistinct()) {
            return;
        }
        for (boolean b : isInner = pkgr.getInner()) {
            if (!b) continue;
            return;
        }
        List<PhysicalOperator> l = plan.getSuccessors(po_package);
        if (l == null || l.size() == 0 || l.size() > 1) {
            return;
        }
        PhysicalOperator po_foreach = l.get(0);
        if (!(po_foreach instanceof POForEach)) {
            return;
        }
        boolean foundUDF = false;
        List<PhysicalPlan> list = ((POForEach)po_foreach).getInputPlans();
        for (PhysicalPlan p : list) {
            PhysicalOperator po = (PhysicalOperator)p.getLeaves().get(0);
            if (!(po instanceof ExpressionOperator)) {
                return;
            }
            if (((ExpressionOperator)po).containUDF()) {
                foundUDF = true;
            }
            if (AccumulatorOptimizerUtil.check(po)) continue;
            return;
        }
        if (foundUDF) {
            LOG.info((Object)"Reducer is to run in accumulative mode.");
            po_package.setAccumulative();
            po_foreach.setAccumulative();
        }
    }

    private static boolean check(PhysicalOperator po) {
        if (po instanceof ConstantExpression) {
            return true;
        }
        if (po instanceof POCast) {
            return AccumulatorOptimizerUtil.check(po.getInputs().get(0));
        }
        if (po instanceof POMapLookUp) {
            return AccumulatorOptimizerUtil.check(po.getInputs().get(0));
        }
        if (po instanceof POProject) {
            if (((POProject)po).getResultType() == 120) {
                return false;
            }
            return ((POProject)po).getResultType() != 110 || !((POProject)po).isOverloaded();
        }
        if (po instanceof UnaryExpressionOperator) {
            return AccumulatorOptimizerUtil.check(((UnaryExpressionOperator)po).getExpr());
        }
        if (po instanceof BinaryExpressionOperator) {
            return AccumulatorOptimizerUtil.check(((BinaryExpressionOperator)po).getLhs()) && AccumulatorOptimizerUtil.check(((BinaryExpressionOperator)po).getRhs());
        }
        if (po instanceof POBinCond) {
            return AccumulatorOptimizerUtil.check(((POBinCond)po).getLhs()) && AccumulatorOptimizerUtil.check(((POBinCond)po).getRhs()) && AccumulatorOptimizerUtil.check(((POBinCond)po).getCond());
        }
        if (po instanceof POUserFunc) {
            String className = ((POUserFunc)po).getFuncSpec().getClassName();
            Class c = null;
            try {
                c = PigContext.resolveClassName(className);
            }
            catch (Exception e) {
                return false;
            }
            if (!Accumulator.class.isAssignableFrom(c)) {
                return false;
            }
            List<PhysicalOperator> inputs = po.getInputs();
            for (PhysicalOperator p : inputs) {
                if (AccumulatorOptimizerUtil.checkUDFInput(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean checkUDFInput(PhysicalOperator po) {
        if (po instanceof PORelationToExprProject) {
            return AccumulatorOptimizerUtil.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof POProject) {
            if (po.getInputs() == null) {
                return true;
            }
            return AccumulatorOptimizerUtil.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof ConstantExpression) {
            return true;
        }
        if (po instanceof UnaryExpressionOperator) {
            return AccumulatorOptimizerUtil.checkUDFInput(((UnaryExpressionOperator)po).getExpr());
        }
        if (po instanceof BinaryExpressionOperator) {
            return AccumulatorOptimizerUtil.checkUDFInput(((BinaryExpressionOperator)po).getLhs()) || AccumulatorOptimizerUtil.checkUDFInput(((BinaryExpressionOperator)po).getRhs());
        }
        if (po instanceof POCast) {
            return AccumulatorOptimizerUtil.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof POBinCond) {
            return AccumulatorOptimizerUtil.checkUDFInput(((POBinCond)po).getLhs()) && AccumulatorOptimizerUtil.checkUDFInput(((POBinCond)po).getRhs()) && AccumulatorOptimizerUtil.checkUDFInput(((POBinCond)po).getCond());
        }
        if (po instanceof POSortedDistinct) {
            return true;
        }
        if (po instanceof POForEach) {
            List<PhysicalPlan> list = ((POForEach)po).getInputPlans();
            if (list.size() != 1) {
                return false;
            }
            PhysicalOperator p = (PhysicalOperator)list.get(0).getLeaves().get(0);
            if (AccumulatorOptimizerUtil.checkUDFInput(p)) {
                return AccumulatorOptimizerUtil.checkUDFInput(po.getInputs().get(0));
            }
        }
        return false;
    }
}

