/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.optimizer.SecondaryKeyOptimizer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.optimizer.SparkSecondaryKeyOptimizerUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.backend.hadoop.executionengine.util.SecondaryKeyOptimizerUtil;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class SecondaryKeyOptimizerSpark
extends SparkOpPlanVisitor
implements SecondaryKeyOptimizer {
    private static final Log LOG = LogFactory.getLog(SecondaryKeyOptimizerSpark.class);
    private int numSortRemoved = 0;
    private int numDistinctChanged = 0;
    private int numUseSecondaryKey = 0;

    public SecondaryKeyOptimizerSpark(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOperator) throws VisitorException {
        LinkedList<POLocalRearrange> rearranges = PlanHelper.getPhysicalOperators(sparkOperator.physicalPlan, POLocalRearrange.class);
        if (rearranges.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No POLocalRearranges found in the spark operator" + sparkOperator.getOperatorKey() + ". Skipping secondary key optimization."));
            }
            return;
        }
        for (POLocalRearrange currentLR : rearranges) {
            SparkSecondaryKeyOptimizerUtil sparkSecondaryKeyOptUtil;
            SecondaryKeyOptimizerUtil.SecondaryKeyOptimizerInfo info;
            PhysicalOperator glr;
            List<PhysicalOperator> predecessors;
            PhysicalPlan mapPlan = null;
            PhysicalPlan reducePlan = null;
            try {
                mapPlan = this.getMapPlan(sparkOperator.physicalPlan, currentLR);
            }
            catch (PlanException e) {
                throw new VisitorException(e);
            }
            try {
                reducePlan = this.getReducePlan(sparkOperator.physicalPlan, currentLR);
            }
            catch (PlanException e) {
                throw new VisitorException(e);
            }
            List rootsOfReducePlan = reducePlan.getRoots();
            if (rootsOfReducePlan.get(0) instanceof POGlobalRearrangeSpark && (predecessors = sparkOperator.physicalPlan.getPredecessors(glr = (PhysicalOperator)rootsOfReducePlan.get(0))) != null && predecessors.size() >= 2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Current code does not enable secondarykey optimization when  join case is encounted");
                }
                return;
            }
            if (mapPlan.getOperator(currentLR.getOperatorKey()) == null) {
                mapPlan = PlanHelper.getLocalRearrangePlanFromSplit(mapPlan, currentLR.getOperatorKey());
            }
            if ((info = (sparkSecondaryKeyOptUtil = new SparkSecondaryKeyOptimizerUtil()).applySecondaryKeySort(mapPlan, reducePlan)) == null) continue;
            this.numSortRemoved += info.getNumSortRemoved();
            this.numDistinctChanged += info.getNumDistinctChanged();
            this.numUseSecondaryKey += info.getNumUseSecondaryKey();
        }
    }

    private PhysicalPlan getMapPlan(PhysicalPlan physicalPlan, POLocalRearrange currentLR) throws VisitorException, PlanException {
        PhysicalPlan mapPlan = new PhysicalPlan();
        mapPlan.addAsRoot(currentLR);
        List<PhysicalOperator> preList = physicalPlan.getPredecessors(currentLR);
        while (true) {
            if (preList == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"there is nothing to backward search");
                break;
            }
            if (preList.size() != 1) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("the size of predecessor of currentLR should be 1 but now it is not 1,physicalPlan:" + physicalPlan));
                break;
            }
            PhysicalOperator pre = preList.get(0);
            if (pre instanceof POLocalRearrange) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"Finishing to find the mapPlan between preLR and currentLR.");
                break;
            }
            mapPlan.addAsRoot(pre);
            preList = physicalPlan.getPredecessors(pre);
        }
        return mapPlan;
    }

    private PhysicalPlan getReducePlan(PhysicalPlan physicalPlan, POLocalRearrange currentLR) throws PlanException {
        PhysicalPlan reducePlan = new PhysicalPlan();
        List<PhysicalOperator> succList = physicalPlan.getSuccessors(currentLR);
        while (true) {
            if (succList == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"there is nothing to forward search");
                break;
            }
            if (succList.size() != 1) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("the size of successors of currentLR should be 1 but now it is not 1,physicalPlan:" + physicalPlan));
                break;
            }
            PhysicalOperator succ = succList.get(0);
            if (succ instanceof POLocalRearrange) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"Finishing to find the ReducePlan between currentLR and netxtLR.");
                break;
            }
            reducePlan.addAsLeaf(succ);
            succList = physicalPlan.getSuccessors(succ);
        }
        return reducePlan;
    }

    @Override
    public int getNumSortRemoved() {
        return this.numSortRemoved;
    }

    @Override
    public int getNumDistinctChanged() {
        return this.numDistinctChanged;
    }

    @Override
    public int getNumUseSecondaryKey() {
        return this.numUseSecondaryKey;
    }
}

