/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PatternNode;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.newplan.BaseOperatorPlan;

public class PatternPlan
extends BaseOperatorPlan {
    ArrayList<PatternNode> ptNodesVisited = new ArrayList();
    OperatorPlan currentPlan = null;

    public boolean match(OperatorPlan<? extends Operator<?>> inpPlan) {
        this.reset();
        PatternPlan pattern = this;
        this.currentPlan = inpPlan;
        if (pattern.size() == 0) {
            return true;
        }
        PatternNode ptNode = (PatternNode)pattern.getSinks().get(0);
        for (Operator plOp : this.currentPlan) {
            if (!this.match(ptNode, plOp)) continue;
            if (this.size() != this.ptNodesVisited.size()) {
                throw new RuntimeException("invalid size of pattern nodes visited");
            }
            return true;
        }
        return false;
    }

    void reset() {
        Iterator<org.apache.pig.newplan.Operator> iter = this.getOperators();
        while (iter.hasNext()) {
            PatternNode ptNode = (PatternNode)iter.next();
            ptNode.setMatch(null);
        }
        this.ptNodesVisited.clear();
    }

    private boolean match(PatternNode ptNode, Operator plOp) {
        List<Operator<?>> plSuccs;
        Class<?> plClass;
        if (ptNode.getMatch() != null && ptNode.getMatch() == plOp) {
            return true;
        }
        Class<?> ptClass = ptNode.getClassName();
        if (ptClass != (plClass = plOp.getClass())) {
            return false;
        }
        if (ptNode.isLeafNode() && this.currentPlan.getSuccessors(plOp) != null && this.currentPlan.getSuccessors(plOp).size() > 0) {
            return false;
        }
        if (ptNode.isSourceNode() && this.currentPlan.getPredecessors(plOp) != null && this.currentPlan.getPredecessors(plOp).size() > 0) {
            return false;
        }
        ptNode.setMatch(plOp);
        int ptNodesVisitedIdx = this.ptNodesVisited.size();
        this.ptNodesVisited.add(ptNode);
        List<org.apache.pig.newplan.Operator> ptPreds = this.getPredecessors(ptNode);
        List<Operator<?>> plPreds = this.currentPlan.getPredecessors(plOp);
        if (!this.match(ptPreds, plPreds)) {
            this.resetNewlyMatchedPtNodes(ptNodesVisitedIdx);
            return false;
        }
        List<org.apache.pig.newplan.Operator> ptSuccs = this.getSuccessors(ptNode);
        if (!this.match(ptSuccs, plSuccs = this.currentPlan.getSuccessors(plOp))) {
            this.resetNewlyMatchedPtNodes(ptNodesVisitedIdx);
            return false;
        }
        return true;
    }

    private void resetNewlyMatchedPtNodes(int ptNodesVisitedIdx) {
        for (int i = this.ptNodesVisited.size() - 1; i >= ptNodesVisitedIdx; --i) {
            this.ptNodesVisited.get(i).setMatch(null);
            this.ptNodesVisited.remove(i);
        }
    }

    private boolean match(List<org.apache.pig.newplan.Operator> ptList, List<Operator<?>> plList) {
        if (ptList == null || ptList.size() == 0) {
            return true;
        }
        if (plList == null) {
            return false;
        }
        if (ptList.size() > plList.size()) {
            return false;
        }
        int plStart = 0;
        int ptIdx = 0;
        block0: while (plList.size() - plStart >= ptList.size()) {
            for (int i = plStart; i < plList.size(); ++i) {
                Operator<?> plNode = plList.get(i);
                PatternNode ptNode = (PatternNode)ptList.get(ptIdx);
                if (ptNode.getMatch() != null) {
                    if (plNode != ptNode.getMatch()) {
                        ptIdx = 0;
                        ++plStart;
                        continue block0;
                    }
                    if (++ptIdx != ptList.size()) continue;
                    return true;
                }
                if (!this.match(ptNode, plNode)) {
                    ptIdx = 0;
                    ++plStart;
                    continue block0;
                }
                if (++ptIdx != ptList.size()) continue;
                return true;
            }
        }
        return false;
    }

    public static PatternPlan create(Class<?>[] classList) {
        PatternPlan ptPlan = new PatternPlan();
        PatternNode prevNode = null;
        for (Class<?> ptClass : classList) {
            PatternNode ptNode = new PatternNode(ptPlan);
            ptNode.setClassName(ptClass);
            ptPlan.add(ptNode);
            if (prevNode != null) {
                ptPlan.connect(prevNode, ptNode);
            }
            prevNode = ptNode;
        }
        return ptPlan;
    }
}

