/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

public class SampleOptimizer
extends MROpPlanVisitor {
    private static final Log log = LogFactory.getLog(SampleOptimizer.class);
    private PigContext pigContext;
    private List<MapReduceOper> opsToRemove = new ArrayList<MapReduceOper>();

    public SampleOptimizer(MROperPlan plan, PigContext pigContext) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
        this.pigContext = pigContext;
    }

    @Override
    public void visit() throws VisitorException {
        super.visit();
        for (MapReduceOper op : this.opsToRemove) {
            ((MROperPlan)this.mPlan).remove(op);
        }
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        List pos = mr.mapPlan.getRoots();
        if (pos == null || pos.size() == 0) {
            log.debug((Object)"Map of operator empty");
            return;
        }
        PhysicalOperator po = (PhysicalOperator)pos.get(0);
        if (!(po instanceof POLoad)) {
            log.debug((Object)"Root operator of map is not load.");
            return;
        }
        POLoad load = (POLoad)po;
        String loadFunc = load.getLFile().getFuncName();
        String loadFile = load.getLFile().getFileName();
        if (!"org.apache.pig.impl.builtin.RandomSampleLoader".equals(loadFunc) && !"org.apache.pig.impl.builtin.PoissonSampleLoader".equals(loadFunc)) {
            log.debug((Object)"Not a sampling job.");
            return;
        }
        if (loadFile == null) {
            log.debug((Object)"No load file");
            return;
        }
        List<MapReduceOper> preds = ((MROperPlan)this.mPlan).getPredecessors(mr);
        if (preds.size() != 1) {
            log.debug((Object)"Too many predecessors to sampling job.");
            return;
        }
        MapReduceOper pred = preds.get(0);
        List<MapReduceOper> predPreds = ((MROperPlan)this.mPlan).getPredecessors(pred);
        if (predPreds != null && predPreds.size() > 0) {
            log.debug((Object)"Predecessor should be a root of the plan");
            return;
        }
        if (!pred.reducePlan.isEmpty() || !pred.combinePlan.isEmpty()) {
            log.debug((Object)"Predecessor has a combine or reduce plan");
            return;
        }
        List<MapReduceOper> succs = ((MROperPlan)this.mPlan).getSuccessors(mr);
        if (succs.size() != 1) {
            log.debug((Object)"Job has more than one successor.");
            return;
        }
        MapReduceOper succ = succs.get(0);
        if (pred.mapPlan == null || pred.mapPlan.size() != 2) {
            log.debug((Object)"Predecessor has more than just load+store in the map");
            return;
        }
        List loads = pred.mapPlan.getRoots();
        if (loads.size() != 1) {
            log.debug((Object)"Predecessor plan has more than one root.");
            return;
        }
        PhysicalOperator r = (PhysicalOperator)loads.get(0);
        if (!(r instanceof POLoad)) {
            log.debug((Object)"Predecessor's map plan root is not a load.");
            return;
        }
        POLoad predLoad = (POLoad)r;
        if (succ.mapPlan == null) {
            log.debug((Object)"Successor has no map plan.");
            return;
        }
        loads = succ.mapPlan.getRoots();
        POLoad succLoad = null;
        for (PhysicalOperator root : loads) {
            if (!(root instanceof POLoad)) {
                log.debug((Object)"Successor's roots are not loads");
                return;
            }
            POLoad sl = (POLoad)root;
            if (!loadFile.equals(sl.getLFile().getFileName()) || !Utils.getTmpFileCompressorName(this.pigContext).equals(sl.getLFile().getFuncName())) continue;
            succLoad = sl;
            break;
        }
        if (succLoad == null) {
            log.debug((Object)"Could not find load that matched file we are sampling.");
            return;
        }
        String[] rslargs = new String[2];
        FileSpec predFs = predLoad.getLFile();
        rslargs[0] = predFs.getFuncSpec().toString();
        mr.UDFs.add(rslargs[0]);
        rslargs[1] = load.getLFile().getFuncSpec().getCtorArgs()[1];
        FileSpec fs = new FileSpec(predFs.getFileName(), new FuncSpec(loadFunc, rslargs));
        POLoad newLoad = new POLoad(load.getOperatorKey(), load.getRequestedParallelism(), fs);
        newLoad.setSignature(predLoad.getSignature());
        newLoad.setLimit(predLoad.getLimit());
        try {
            mr.mapPlan.replace(load, newLoad);
            List ls = mr.reducePlan.getLeaves();
            for (PhysicalOperator op : ls) {
                this.scan(mr, op, fs.getFileName());
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
        fs = new FileSpec(predFs.getFileName(), predFs.getFuncSpec());
        newLoad = new POLoad(succLoad.getOperatorKey(), succLoad.getRequestedParallelism(), fs);
        newLoad.setSignature(predLoad.getSignature());
        try {
            succ.mapPlan.replace(succLoad, newLoad);
            succ.UDFs.add(newLoad.getLFile().getFuncSpec().toString());
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
        this.opsToRemove.add(pred);
    }

    private void scan(MapReduceOper mr, PhysicalOperator op, String fileName) {
        if (op instanceof POUserFunc) {
            if (((POUserFunc)op).getFuncSpec().getClassName().equals("org.apache.pig.impl.builtin.PartitionSkewedKeys")) {
                String[] ctorArgs = ((POUserFunc)op).getFuncSpec().getCtorArgs();
                ctorArgs[2] = fileName;
                return;
            }
        } else if (op instanceof POForEach) {
            List<PhysicalPlan> pl = ((POForEach)op).getInputPlans();
            for (PhysicalPlan plan : pl) {
                List list = plan.getLeaves();
                for (PhysicalOperator pp : list) {
                    this.scan(mr, pp, fileName);
                }
            }
        } else {
            List<PhysicalOperator> preds = mr.reducePlan.getPredecessors(op);
            if (preds == null) {
                return;
            }
            for (PhysicalOperator p : preds) {
                this.scan(mr, p, fileName);
            }
        }
    }
}

