/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.nativeio.SharedFileDescriptorFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShortCircuitShm {
    public static final Logger LOG = LoggerFactory.getLogger(TestShortCircuitShm.class);
    private static final File TEST_BASE = GenericTestUtils.getTestDir();

    @Before
    public void before() {
        Assume.assumeTrue((null == SharedFileDescriptorFactory.getLoadingFailureReason() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testStartupShutdown() throws Exception {
        File path = new File(TEST_BASE, "testStartupShutdown");
        path.mkdirs();
        SharedFileDescriptorFactory factory = SharedFileDescriptorFactory.create((String)"shm_", (String[])new String[]{path.getAbsolutePath()});
        FileInputStream stream = factory.createDescriptor("testStartupShutdown", 4096);
        ShortCircuitShm shm = new ShortCircuitShm(ShortCircuitShm.ShmId.createRandom(), stream);
        shm.free();
        stream.close();
        FileUtil.fullyDelete((File)path);
    }

    @Test(timeout=60000L)
    public void testAllocateSlots() throws Exception {
        File path = new File(TEST_BASE, "testAllocateSlots");
        path.mkdirs();
        SharedFileDescriptorFactory factory = SharedFileDescriptorFactory.create((String)"shm_", (String[])new String[]{path.getAbsolutePath()});
        FileInputStream stream = factory.createDescriptor("testAllocateSlots", 4096);
        ShortCircuitShm shm = new ShortCircuitShm(ShortCircuitShm.ShmId.createRandom(), stream);
        int numSlots = 0;
        ArrayList<ShortCircuitShm.Slot> slots = new ArrayList<ShortCircuitShm.Slot>();
        while (!shm.isFull()) {
            ShortCircuitShm.Slot slot = shm.allocAndRegisterSlot(new ExtendedBlockId(123L, "test_bp1"));
            slots.add(slot);
            ++numSlots;
        }
        LOG.info("allocated " + numSlots + " slots before running out.");
        int slotIdx = 0;
        ShortCircuitShm.SlotIterator iter = shm.slotIterator();
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)slots.contains(iter.next()));
        }
        for (ShortCircuitShm.Slot slot : slots) {
            Assert.assertFalse((boolean)slot.addAnchor());
            Assert.assertEquals((long)slotIdx++, (long)slot.getSlotIdx());
        }
        for (ShortCircuitShm.Slot slot : slots) {
            slot.makeAnchorable();
        }
        for (ShortCircuitShm.Slot slot : slots) {
            Assert.assertTrue((boolean)slot.addAnchor());
        }
        for (ShortCircuitShm.Slot slot : slots) {
            slot.removeAnchor();
        }
        for (ShortCircuitShm.Slot slot : slots) {
            shm.unregisterSlot(slot.getSlotIdx());
            slot.makeInvalid();
        }
        shm.free();
        stream.close();
        FileUtil.fullyDelete((File)path);
    }
}

