/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.BytesValue;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcedureTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureTestingUtility.class);

    private ProcedureTestingUtility() {
    }

    public static ProcedureStore createStore(Configuration conf, Path dir) throws IOException {
        return ProcedureTestingUtility.createWalStore(conf, dir);
    }

    public static WALProcedureStore createWalStore(Configuration conf, Path dir) throws IOException {
        return new WALProcedureStore(conf, dir, null, new LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, boolean abort, boolean startWorkers) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, false, true, null, null, null, abort, startWorkers);
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, boolean abort) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, false, true, null, null, null, abort, true);
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, false, true, null, null, null, false, true);
    }

    public static void initAndStartWorkers(ProcedureExecutor<?> procExecutor, int numThreads, boolean abortOnCorruption) throws IOException {
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, numThreads, abortOnCorruption, true);
    }

    public static void initAndStartWorkers(ProcedureExecutor<?> procExecutor, int numThreads, boolean abortOnCorruption, boolean startWorkers) throws IOException {
        procExecutor.init(numThreads, abortOnCorruption);
        if (startWorkers) {
            procExecutor.startWorkers();
        }
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, boolean avoidTestKillDuringRestart, boolean failOnCorrupted, Callable<Void> stopAction, Callable<Void> actionBeforeStartWorker, Callable<Void> startAction) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, avoidTestKillDuringRestart, failOnCorrupted, stopAction, actionBeforeStartWorker, startAction, false, true);
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, boolean avoidTestKillDuringRestart, boolean failOnCorrupted, Callable<Void> stopAction, Callable<Void> actionBeforeStartWorker, Callable<Void> startAction, boolean abort, boolean startWorkers) throws Exception {
        ProcedureStore procStore = procExecutor.getStore();
        int storeThreads = procExecutor.getCorePoolSize();
        int execThreads = procExecutor.getCorePoolSize();
        ProcedureExecutor.Testing testing = procExecutor.testing;
        if (avoidTestKillDuringRestart) {
            procExecutor.testing = null;
        }
        LOG.info("RESTART - Stop");
        procExecutor.stop();
        procStore.stop(abort);
        if (stopAction != null) {
            stopAction.call();
        }
        procExecutor.join();
        procExecutor.getScheduler().clear();
        LOG.info("RESTART - Start");
        procStore.start(storeThreads);
        procExecutor.init(execThreads, failOnCorrupted);
        if (actionBeforeStartWorker != null) {
            actionBeforeStartWorker.call();
        }
        if (avoidTestKillDuringRestart) {
            procExecutor.testing = testing;
        }
        if (startWorkers) {
            procExecutor.startWorkers();
        }
        if (startAction != null) {
            startAction.call();
        }
    }

    public static void storeRestart(ProcedureStore procStore, ProcedureStore.ProcedureLoader loader) throws Exception {
        ProcedureTestingUtility.storeRestart(procStore, false, loader);
    }

    public static void storeRestart(ProcedureStore procStore, boolean abort, ProcedureStore.ProcedureLoader loader) throws Exception {
        procStore.stop(abort);
        procStore.start(procStore.getNumThreads());
        procStore.recoverLease();
        procStore.load(loader);
    }

    public static LoadCounter storeRestartAndAssert(ProcedureStore procStore, long maxProcId, long runnableCount, int completedCount, int corruptedCount) throws Exception {
        LoadCounter loader = new LoadCounter();
        ProcedureTestingUtility.storeRestart(procStore, loader);
        Assert.assertEquals((long)maxProcId, (long)loader.getMaxProcId());
        Assert.assertEquals((long)runnableCount, (long)loader.getRunnableCount());
        Assert.assertEquals((long)completedCount, (long)loader.getCompletedCount());
        Assert.assertEquals((long)corruptedCount, (long)loader.getCorruptedCount());
        return loader;
    }

    private static <TEnv> void createExecutorTesting(ProcedureExecutor<TEnv> procExecutor) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
    }

    public static <TEnv> void setKillIfHasParent(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.killIfHasParent = value;
    }

    public static <TEnv> void setKillIfSuspended(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.killIfSuspended = value;
    }

    public static <TEnv> void setKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.killBeforeStoreUpdate = value;
        LOG.warn("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate);
        ProcedureTestingUtility.assertSingleExecutorForKillTests(procExecutor);
    }

    public static <TEnv> void setToggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.toggleKillBeforeStoreUpdate = value;
        ProcedureTestingUtility.assertSingleExecutorForKillTests(procExecutor);
    }

    public static <TEnv> void toggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.killBeforeStoreUpdate = !procExecutor.testing.killBeforeStoreUpdate;
        LOG.warn("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate);
        ProcedureTestingUtility.assertSingleExecutorForKillTests(procExecutor);
    }

    public static <TEnv> void toggleKillAfterStoreUpdate(ProcedureExecutor<TEnv> procExecutor) {
        ProcedureTestingUtility.createExecutorTesting(procExecutor);
        procExecutor.testing.killAfterStoreUpdate = !procExecutor.testing.killAfterStoreUpdate;
        LOG.warn("Set Kill after store update to: " + procExecutor.testing.killAfterStoreUpdate);
        ProcedureTestingUtility.assertSingleExecutorForKillTests(procExecutor);
    }

    public static <TEnv> void setKillAndToggleBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExecutor, value);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExecutor, value);
        ProcedureTestingUtility.assertSingleExecutorForKillTests(procExecutor);
    }

    private static <TEnv> void assertSingleExecutorForKillTests(ProcedureExecutor<TEnv> procExecutor) {
        if (procExecutor.testing == null) {
            return;
        }
        if (procExecutor.testing.killBeforeStoreUpdate || procExecutor.testing.toggleKillBeforeStoreUpdate) {
            Assert.assertEquals((String)"expected only one executor running during test with kill/restart", (long)1L, (long)procExecutor.getCorePoolSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEnv> long submitAndWait(Configuration conf, TEnv env, Procedure<TEnv> proc) throws IOException {
        NoopProcedureStore procStore = new NoopProcedureStore();
        ProcedureExecutor procExecutor = new ProcedureExecutor(conf, env, (ProcedureStore)procStore);
        procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 1, false, true);
        try {
            long l = ProcedureTestingUtility.submitAndWait(procExecutor, proc, 0L, 0L);
            return l;
        }
        finally {
            procStore.stop(false);
            procExecutor.stop();
        }
    }

    public static <TEnv> long submitAndWait(ProcedureExecutor<TEnv> procExecutor, Procedure proc) {
        return ProcedureTestingUtility.submitAndWait(procExecutor, proc, 0L, 0L);
    }

    public static <TEnv> long submitAndWait(ProcedureExecutor<TEnv> procExecutor, Procedure proc, long nonceGroup, long nonce) {
        long procId = ProcedureTestingUtility.submitProcedure(procExecutor, proc, nonceGroup, nonce);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        return procId;
    }

    public static <TEnv> long submitProcedure(ProcedureExecutor<TEnv> procExecutor, Procedure proc, long nonceGroup, long nonce) {
        NonceKey nonceKey = procExecutor.createNonceKey(nonceGroup, nonce);
        long procId = procExecutor.registerNonce(nonceKey);
        Assert.assertFalse((procId >= 0L ? 1 : 0) != 0);
        return procExecutor.submitProcedure(proc, nonceKey);
    }

    public static <TEnv> void waitProcedure(ProcedureExecutor<TEnv> procExecutor, Procedure proc) {
        while (proc.getState() == ProcedureProtos.ProcedureState.INITIALIZING) {
            Threads.sleepWithoutInterrupt((long)250L);
        }
        ProcedureTestingUtility.waitProcedure(procExecutor, proc.getProcId());
    }

    public static <TEnv> void waitProcedure(ProcedureExecutor<TEnv> procExecutor, long procId) {
        while (!procExecutor.isFinished(procId) && procExecutor.isRunning()) {
            Threads.sleepWithoutInterrupt((long)250L);
        }
    }

    public static <TEnv> void waitProcedures(ProcedureExecutor<TEnv> procExecutor, long ... procIds) {
        for (int i = 0; i < procIds.length; ++i) {
            ProcedureTestingUtility.waitProcedure(procExecutor, procIds[i]);
        }
    }

    public static <TEnv> void waitAllProcedures(ProcedureExecutor<TEnv> procExecutor) {
        Iterator iterator = procExecutor.getActiveProcIds().iterator();
        while (iterator.hasNext()) {
            long procId = (Long)iterator.next();
            ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        }
    }

    public static <TEnv> void waitNoProcedureRunning(ProcedureExecutor<TEnv> procExecutor) {
        int stableRuns = 0;
        while (stableRuns < 10) {
            if (procExecutor.getActiveExecutorCount() > 0 || procExecutor.getScheduler().size() > 0) {
                stableRuns = 0;
                Threads.sleepWithoutInterrupt((long)100L);
                continue;
            }
            ++stableRuns;
            Threads.sleepWithoutInterrupt((long)25L);
        }
    }

    public static <TEnv> void assertProcNotYetCompleted(ProcedureExecutor<TEnv> procExecutor, long procId) {
        Assert.assertFalse((String)"expected a running proc", (boolean)procExecutor.isFinished(procId));
        Assert.assertEquals(null, (Object)procExecutor.getResult(procId));
    }

    public static <TEnv> void assertProcNotFailed(ProcedureExecutor<TEnv> procExecutor, long procId) {
        Procedure result = procExecutor.getResult(procId);
        Assert.assertTrue((String)"expected procedure result", (result != null ? 1 : 0) != 0);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    public static void assertProcNotFailed(Procedure<?> result) {
        Assert.assertFalse((String)("found exception: " + result.getException()), (boolean)result.isFailed());
    }

    public static <TEnv> Throwable assertProcFailed(ProcedureExecutor<TEnv> procExecutor, long procId) {
        Procedure result = procExecutor.getResult(procId);
        Assert.assertTrue((String)"expected procedure result", (result != null ? 1 : 0) != 0);
        return ProcedureTestingUtility.assertProcFailed(result);
    }

    public static Throwable assertProcFailed(Procedure<?> result) {
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info("procId=" + result.getProcId() + " exception: " + result.getException().getMessage());
        return ProcedureTestingUtility.getExceptionCause(result);
    }

    public static void assertIsAbortException(Procedure<?> result) {
        Throwable cause = ProcedureTestingUtility.assertProcFailed(result);
        Assert.assertTrue((String)("expected abort exception, got " + cause), (boolean)(cause instanceof ProcedureAbortedException));
    }

    public static void assertIsTimeoutException(Procedure<?> result) {
        Throwable cause = ProcedureTestingUtility.assertProcFailed(result);
        Assert.assertTrue((String)("expected TimeoutIOException, got " + cause), (boolean)(cause instanceof TimeoutIOException));
    }

    public static void assertIsIllegalArgumentException(Procedure<?> result) {
        Throwable cause = ProcedureTestingUtility.assertProcFailed(result);
        Assert.assertTrue((String)("expected IllegalArgumentIOException, got " + cause), (boolean)(cause instanceof IllegalArgumentIOException));
    }

    public static Throwable getExceptionCause(Procedure<?> procInfo) {
        assert (procInfo.isFailed());
        Throwable cause = procInfo.getException().getCause();
        return cause == null ? procInfo.getException() : cause;
    }

    public static <TEnv> void testRecoveryAndDoubleExecution(ProcedureExecutor<TEnv> procExec, long procId) throws Exception {
        ProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, false);
    }

    public static <TEnv> void testRecoveryAndDoubleExecution(ProcedureExecutor<TEnv> procExec, long procId, boolean expectFailure) throws Exception {
        ProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, expectFailure, null);
    }

    public static <TEnv> void testRecoveryAndDoubleExecution(ProcedureExecutor<TEnv> procExec, long procId, boolean expectFailure, Runnable customRestart) throws Exception {
        Procedure proc = procExec.getProcedure(procId);
        ProcedureTestingUtility.waitProcedure(procExec, procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        int i = 0;
        while (!procExec.isFinished(procId)) {
            proc = procExec.getProcedure(procId);
            LOG.info("Restart " + i + " exec state: " + proc);
            if (customRestart != null) {
                customRestart.run();
            } else {
                ProcedureTestingUtility.restart(procExec);
            }
            ProcedureTestingUtility.waitProcedure(procExec, procId);
            ++i;
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        if (expectFailure) {
            ProcedureTestingUtility.assertProcFailed(procExec, procId);
        } else {
            ProcedureTestingUtility.assertProcNotFailed(procExec, procId);
        }
    }

    public static class LoadCounter
    implements ProcedureStore.ProcedureLoader {
        private final ArrayList<Procedure> corrupted = new ArrayList();
        private final ArrayList<Procedure> completed = new ArrayList();
        private final ArrayList<Procedure> runnable = new ArrayList();
        private Set<Long> procIds;
        private long maxProcId = 0L;

        public LoadCounter() {
            this(null);
        }

        public LoadCounter(Set<Long> procIds) {
            this.procIds = procIds;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(Set<Long> procIds) {
            this.corrupted.clear();
            this.completed.clear();
            this.runnable.clear();
            this.procIds = procIds;
            this.maxProcId = 0L;
        }

        public long getMaxProcId() {
            return this.maxProcId;
        }

        public ArrayList<Procedure> getRunnables() {
            return this.runnable;
        }

        public int getRunnableCount() {
            return this.runnable.size();
        }

        public ArrayList<Procedure> getCompleted() {
            return this.completed;
        }

        public int getCompletedCount() {
            return this.completed.size();
        }

        public int getLoadedCount() {
            return this.runnable.size() + this.completed.size();
        }

        public ArrayList<Procedure> getCorrupted() {
            return this.corrupted;
        }

        public int getCorruptedCount() {
            return this.corrupted.size();
        }

        public boolean isRunnable(long procId) {
            for (Procedure proc : this.runnable) {
                if (proc.getProcId() != procId) continue;
                return true;
            }
            return false;
        }

        public void setMaxProcId(long maxProcId) {
            this.maxProcId = maxProcId;
        }

        public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                long procId;
                Procedure proc;
                if (procIter.isNextFinished()) {
                    proc = procIter.next();
                    procId = proc.getProcId();
                    LOG.debug("loading completed procId=" + procId + ": " + proc);
                    this.completed.add(proc);
                } else {
                    proc = procIter.next();
                    procId = proc.getProcId();
                    LOG.debug("loading runnable procId=" + procId + ": " + proc);
                    this.runnable.add(proc);
                }
                if (this.procIds == null) continue;
                Assert.assertTrue((String)("procId=" + procId + " unexpected"), (boolean)this.procIds.contains(procId));
            }
        }

        public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                Procedure proc = procIter.next();
                LOG.debug("corrupted procId=" + proc.getProcId() + ": " + proc);
                this.corrupted.add(proc);
            }
        }
    }

    public static class TestProcedure
    extends NoopProcedure<Void> {
        private byte[] data = null;

        public TestProcedure() {
        }

        public TestProcedure(long procId) {
            this(procId, 0L);
        }

        public TestProcedure(long procId, long parentId) {
            this(procId, parentId, null);
        }

        public TestProcedure(long procId, long parentId, byte[] data) {
            this(procId, parentId, parentId, data);
        }

        public TestProcedure(long procId, long parentId, long rootId, byte[] data) {
            this.setData(data);
            this.setProcId(procId);
            if (parentId > 0L) {
                this.setParentProcId(parentId);
            }
            if (rootId > 0L || parentId > 0L) {
                this.setRootProcId(rootId);
            }
        }

        public void addStackId(int index) {
            this.addStackIndex(index);
        }

        public void setSuccessState() {
            this.setState(ProcedureProtos.ProcedureState.SUCCESS);
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        @Override
        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            ByteString dataString = ByteString.copyFrom((byte[])(this.data == null ? new byte[]{} : this.data));
            BytesValue.Builder builder = BytesValue.newBuilder().setValue(dataString);
            serializer.serialize((Message)builder.build());
        }

        @Override
        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            BytesValue bytesValue = (BytesValue)serializer.deserialize(BytesValue.class);
            ByteString dataString = bytesValue.getValue();
            this.data = (byte[])(dataString.isEmpty() ? null : dataString.toByteArray());
        }

        public Procedure.LockState acquireLock(Void env) {
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        public void releaseLock(Void env) {
        }
    }

    public static class NoopStateMachineProcedure<TEnv, TState>
    extends StateMachineProcedure<TEnv, TState> {
        private TState initialState;
        private TEnv env;

        public NoopStateMachineProcedure() {
        }

        public NoopStateMachineProcedure(TEnv env, TState initialState) {
            this.env = env;
            this.initialState = initialState;
        }

        protected StateMachineProcedure.Flow executeFromState(TEnv env, TState tState) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            return null;
        }

        protected void rollbackState(TEnv env, TState tState) throws IOException, InterruptedException {
        }

        protected TState getState(int stateId) {
            return null;
        }

        protected int getStateId(TState tState) {
            return 0;
        }

        protected TState getInitialState() {
            return this.initialState;
        }
    }

    public static class NoopProcedure<TEnv>
    extends Procedure<TEnv> {
        protected Procedure<TEnv>[] execute(TEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            return null;
        }

        protected void rollback(TEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(TEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }
}

