/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClientTokenUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientTokenUtil.class);
    private URLClassLoader cl;

    @Before
    public void setUp() {
        URL urlPU = ProtobufUtil.class.getProtectionDomain().getCodeSource().getLocation();
        URL urlCTU = ClientTokenUtil.class.getProtectionDomain().getCodeSource().getLocation();
        this.cl = new URLClassLoader(new URL[]{urlPU, urlCTU}, this.getClass().getClassLoader());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.cl, (boolean)true);
    }

    @Test
    public void testObtainToken() throws Exception {
        block3: {
            ServiceException injected = new ServiceException("injected");
            Class<?> clientTokenUtil = this.cl.loadClass(ClientTokenUtil.class.getCanonicalName());
            Field shouldInjectFault = clientTokenUtil.getDeclaredField("injectedException");
            shouldInjectFault.setAccessible(true);
            shouldInjectFault.set(null, injected);
            try {
                ClientTokenUtil.obtainToken((Connection)null);
                Assert.fail((String)"Should have injected exception.");
            }
            catch (IOException e) {
                Throwable t = e;
                boolean serviceExceptionFound = false;
                while ((t = t.getCause()) != null) {
                    if (t != injected) continue;
                    serviceExceptionFound = true;
                    break;
                }
                if (serviceExceptionFound) break block3;
                throw e;
            }
        }
        Boolean loaded = (Boolean)this.cl.loadClass(ProtobufUtil.class.getCanonicalName()).getDeclaredMethod("isClassLoaderLoaded", new Class[0]).invoke(null, new Object[0]);
        Assert.assertFalse((String)"Should not have loaded DynamicClassLoader", (boolean)loaded);
    }
}

