/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

@Description(name="sum", value="_FUNC_(expr) - Returns the sum value of expr (vectorized, type: decimal64 -> decimal64)")
public class VectorUDAFSumDecimal64
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private DecimalTypeInfo outputDecimalTypeInfo;
    private long outputDecimal64AbsMax;

    public VectorUDAFSumDecimal64() {
    }

    public VectorUDAFSumDecimal64(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.init();
    }

    private void init() {
        this.outputDecimalTypeInfo = (DecimalTypeInfo)this.outputTypeInfo;
        this.outputDecimal64AbsMax = HiveDecimalWritable.getDecimal64AbsMax((int)this.outputDecimalTypeInfo.getPrecision());
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        long[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[selection[i]]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, int[] selection, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        long[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum = 0L;
                }
                myagg.sumValueNoNullCheck(vector[0] * (long)batchSize);
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0L;
            }
            myagg.sumValueNoNullCheck(value);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.sum = 0L;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[selected[i]];
            myagg.sumValueNoNullCheck(value);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.sum = 0L;
                myagg.isNull = false;
            }
            myagg.sumValueNoNullCheck(value);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.sum = 0L;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[i];
            myagg.sumValueNoNullCheck(value);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation(this.outputDecimal64AbsMax);
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)model.object(), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("sum") && inputColVectorType == ColumnVector.Type.DECIMAL_64 && outputColVectorType == ColumnVector.Type.DECIMAL_64;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Decimal64ColumnVector outputColVector = (Decimal64ColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull || myagg.isOverflowed) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        outputColVector.vector[batchIndex] = myagg.sum;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient long sum;
        private transient boolean isNull = true;
        private transient long outputDecimal64AbsMax;
        private transient boolean isOverflowed = false;

        public Aggregation(long outputDecimal64AbsMax) {
            this.outputDecimal64AbsMax = outputDecimal64AbsMax;
        }

        public void sumValue(long value) {
            if (this.isOverflowed) {
                return;
            }
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum += value;
                if (Math.abs(this.sum) > this.outputDecimal64AbsMax) {
                    this.isOverflowed = true;
                }
            }
        }

        public void sumValueNoNullCheck(long value) {
            this.sum += value;
            if (Math.abs(this.sum) > this.outputDecimal64AbsMax) {
                this.isOverflowed = true;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.isOverflowed = false;
            this.sum = 0L;
        }
    }
}

