/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.common.util.Murmur3;

public class VectorHashKeyWrapper
extends KeyWrapper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[][] EMPTY_BYTES_ARRAY = new byte[0][];
    private static final HiveDecimalWritable[] EMPTY_DECIMAL_ARRAY = new HiveDecimalWritable[0];
    private static final Timestamp[] EMPTY_TIMESTAMP_ARRAY = new Timestamp[0];
    private static final HiveIntervalDayTime[] EMPTY_INTERVAL_DAY_TIME_ARRAY = new HiveIntervalDayTime[0];
    public static final VectorHashKeyWrapper EMPTY_KEY_WRAPPER = new EmptyVectorHashKeyWrapper();
    private long[] longValues;
    private double[] doubleValues;
    private byte[][] byteValues;
    private int[] byteStarts;
    private int[] byteLengths;
    private HiveDecimalWritable[] decimalValues;
    private Timestamp[] timestampValues;
    private static Timestamp ZERO_TIMESTAMP = new Timestamp(0L);
    private HiveIntervalDayTime[] intervalDayTimeValues;
    private static HiveIntervalDayTime ZERO_INTERVALDAYTIME = new HiveIntervalDayTime(0L, 0);
    private boolean[] isNull;
    private int hashcode;
    private HashContext hashCtx;

    private VectorHashKeyWrapper(HashContext ctx, int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        int i;
        this.hashCtx = ctx;
        this.longValues = longValuesCount > 0 ? new long[longValuesCount] : EMPTY_LONG_ARRAY;
        this.doubleValues = doubleValuesCount > 0 ? new double[doubleValuesCount] : EMPTY_DOUBLE_ARRAY;
        this.decimalValues = decimalValuesCount > 0 ? new HiveDecimalWritable[decimalValuesCount] : EMPTY_DECIMAL_ARRAY;
        this.timestampValues = timestampValuesCount > 0 ? new Timestamp[timestampValuesCount] : EMPTY_TIMESTAMP_ARRAY;
        this.intervalDayTimeValues = intervalDayTimeValuesCount > 0 ? new HiveIntervalDayTime[intervalDayTimeValuesCount] : EMPTY_INTERVAL_DAY_TIME_ARRAY;
        for (i = 0; i < decimalValuesCount; ++i) {
            this.decimalValues[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
        if (byteValuesCount > 0) {
            this.byteValues = new byte[byteValuesCount][];
            this.byteStarts = new int[byteValuesCount];
            this.byteLengths = new int[byteValuesCount];
        } else {
            this.byteValues = EMPTY_BYTES_ARRAY;
            this.byteStarts = EMPTY_INT_ARRAY;
            this.byteLengths = EMPTY_INT_ARRAY;
        }
        for (i = 0; i < timestampValuesCount; ++i) {
            this.timestampValues[i] = new Timestamp(0L);
        }
        for (i = 0; i < intervalDayTimeValuesCount; ++i) {
            this.intervalDayTimeValues[i] = new HiveIntervalDayTime();
        }
        this.isNull = new boolean[keyCount];
        this.hashcode = 0;
    }

    private VectorHashKeyWrapper() {
    }

    public static VectorHashKeyWrapper allocate(HashContext ctx, int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        if (longValuesCount + doubleValuesCount + byteValuesCount + decimalValuesCount + timestampValuesCount + intervalDayTimeValuesCount == 0) {
            return EMPTY_KEY_WRAPPER;
        }
        return new VectorHashKeyWrapper(ctx, longValuesCount, doubleValuesCount, byteValuesCount, decimalValuesCount, timestampValuesCount, intervalDayTimeValuesCount, keyCount);
    }

    @Override
    public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
        throw new HiveException("Should not be called");
    }

    @Override
    public void setHashKey() {
        int i;
        int hash = Arrays.hashCode(this.longValues) ^ Arrays.hashCode(this.doubleValues) ^ Arrays.hashCode(this.isNull);
        for (i = 0; i < this.decimalValues.length; ++i) {
            hash ^= this.decimalValues[i].newFasterHashCode();
        }
        for (i = 0; i < this.timestampValues.length; ++i) {
            hash ^= this.timestampValues[i].hashCode();
        }
        for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
            hash ^= this.intervalDayTimeValues[i].hashCode();
        }
        Murmur3.IncrementalHash32 bytesHash = null;
        for (int i2 = 0; i2 < this.byteValues.length; ++i2) {
            if (this.byteLengths[i2] == -1) continue;
            if (bytesHash == null) {
                bytesHash = HashContext.getBytesHash(this.hashCtx);
                bytesHash.start(hash);
            }
            bytesHash.add(this.byteValues[i2], this.byteStarts[i2], this.byteLengths[i2]);
        }
        if (bytesHash != null) {
            hash = bytesHash.end();
        }
        this.hashcode = hash;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object that) {
        if (that instanceof VectorHashKeyWrapper) {
            VectorHashKeyWrapper keyThat = (VectorHashKeyWrapper)that;
            return this.hashcode == keyThat.hashcode && Arrays.equals(this.longValues, keyThat.longValues) && Arrays.equals(this.doubleValues, keyThat.doubleValues) && Arrays.equals(this.decimalValues, keyThat.decimalValues) && Arrays.equals(this.timestampValues, keyThat.timestampValues) && Arrays.equals(this.intervalDayTimeValues, keyThat.intervalDayTimeValues) && Arrays.equals(this.isNull, keyThat.isNull) && this.byteValues.length == keyThat.byteValues.length && (0 == this.byteValues.length || this.bytesEquals(keyThat));
        }
        return false;
    }

    private boolean bytesEquals(VectorHashKeyWrapper keyThat) {
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.byteLengths[i] == -1 || StringExpr.equal((byte[])this.byteValues[i], (int)this.byteStarts[i], (int)this.byteLengths[i], (byte[])keyThat.byteValues[i], (int)keyThat.byteStarts[i], (int)keyThat.byteLengths[i])) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        VectorHashKeyWrapper clone = new VectorHashKeyWrapper();
        this.duplicateTo(clone);
        return clone;
    }

    public void duplicateTo(VectorHashKeyWrapper clone) {
        int i;
        clone.hashCtx = this.hashCtx;
        clone.longValues = this.longValues.length > 0 ? (long[])this.longValues.clone() : EMPTY_LONG_ARRAY;
        clone.doubleValues = this.doubleValues.length > 0 ? (double[])this.doubleValues.clone() : EMPTY_DOUBLE_ARRAY;
        clone.isNull = (boolean[])this.isNull.clone();
        if (this.decimalValues.length > 0) {
            clone.decimalValues = new HiveDecimalWritable[this.decimalValues.length];
            for (i = 0; i < this.decimalValues.length; ++i) {
                clone.decimalValues[i] = new HiveDecimalWritable(this.decimalValues[i]);
            }
        } else {
            clone.decimalValues = EMPTY_DECIMAL_ARRAY;
        }
        if (this.byteLengths.length > 0) {
            clone.byteValues = new byte[this.byteValues.length][];
            clone.byteStarts = new int[this.byteValues.length];
            clone.byteLengths = (int[])this.byteLengths.clone();
            for (i = 0; i < this.byteValues.length; ++i) {
                if (this.byteLengths[i] == -1) continue;
                clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
            }
        } else {
            clone.byteValues = EMPTY_BYTES_ARRAY;
            clone.byteStarts = EMPTY_INT_ARRAY;
            clone.byteLengths = EMPTY_INT_ARRAY;
        }
        if (this.timestampValues.length > 0) {
            clone.timestampValues = new Timestamp[this.timestampValues.length];
            for (i = 0; i < this.timestampValues.length; ++i) {
                clone.timestampValues[i] = (Timestamp)this.timestampValues[i].clone();
            }
        } else {
            clone.timestampValues = EMPTY_TIMESTAMP_ARRAY;
        }
        if (this.intervalDayTimeValues.length > 0) {
            clone.intervalDayTimeValues = new HiveIntervalDayTime[this.intervalDayTimeValues.length];
            for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
                clone.intervalDayTimeValues[i] = (HiveIntervalDayTime)this.intervalDayTimeValues[i].clone();
            }
        } else {
            clone.intervalDayTimeValues = EMPTY_INTERVAL_DAY_TIME_ARRAY;
        }
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
    }

    @Override
    public KeyWrapper copyKey() {
        return (KeyWrapper)this.clone();
    }

    @Override
    public void copyKey(KeyWrapper oldWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getKeyArray() {
        throw new UnsupportedOperationException();
    }

    public void assignLong(int keyIndex, int index, long v) {
        this.isNull[keyIndex] = false;
        this.longValues[index] = v;
    }

    @Deprecated
    public void assignLong(int index, long v) {
        this.longValues[index] = v;
    }

    public void assignNullLong(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.longValues[index] = 0L;
    }

    public void assignDouble(int index, double d) {
        this.doubleValues[index] = d;
    }

    public void assignNullDouble(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.doubleValues[index] = 0.0;
    }

    public void assignString(int index, byte[] bytes, int start, int length) {
        Preconditions.checkState((bytes != null ? 1 : 0) != 0);
        this.byteValues[index] = bytes;
        this.byteStarts[index] = start;
        this.byteLengths[index] = length;
    }

    public void assignNullString(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.byteValues[index] = null;
        this.byteStarts[index] = 0;
        this.byteLengths[index] = -1;
    }

    public void assignDecimal(int index, HiveDecimalWritable value) {
        this.decimalValues[index].set(value);
    }

    public void assignNullDecimal(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.decimalValues[index].set(HiveDecimal.ZERO);
    }

    public void assignTimestamp(int index, Timestamp value) {
        this.timestampValues[index].setTime(value.getTime());
        this.timestampValues[index].setNanos(value.getNanos());
    }

    public void assignTimestamp(int index, TimestampColumnVector colVector, int elementNum) {
        colVector.timestampUpdate(this.timestampValues[index], elementNum);
    }

    public void assignNullTimestamp(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.timestampValues[index].setTime(ZERO_TIMESTAMP.getTime());
        this.timestampValues[index].setNanos(ZERO_TIMESTAMP.getNanos());
    }

    public void assignIntervalDayTime(int index, HiveIntervalDayTime value) {
        this.intervalDayTimeValues[index].set(value);
    }

    public void assignIntervalDayTime(int index, IntervalDayTimeColumnVector colVector, int elementNum) {
        this.intervalDayTimeValues[index].set(colVector.asScratchIntervalDayTime(elementNum));
    }

    public void assignNullIntervalDayTime(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.intervalDayTimeValues[index].set(ZERO_INTERVALDAYTIME);
    }

    public String stringifyKeys(VectorColumnSetInfo columnSetInfo) {
        int keyIndex;
        int i;
        boolean isFirstValue;
        StringBuilder sb = new StringBuilder();
        boolean isFirstKey = true;
        if (this.longValues.length > 0) {
            isFirstKey = false;
            sb.append("longs ");
            isFirstValue = true;
            block3: for (i = 0; i < columnSetInfo.longIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.longIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.longValues[i]);
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)columnSetInfo.typeInfos[keyIndex];
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case DATE: {
                        Date dt = new Date(0L);
                        dt.setTime(DateWritableV2.daysToMillis((int)((int)this.longValues[i])));
                        sb.append(" date ");
                        sb.append(dt.toString());
                        continue block3;
                    }
                }
            }
        }
        if (this.doubleValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("doubles ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.doubleIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.doubleIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.doubleValues[i]);
            }
        }
        if (this.byteValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("byte lengths ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.stringIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.stringIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.byteLengths[i]);
            }
        }
        if (this.decimalValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = true;
            } else {
                sb.append(", ");
            }
            sb.append("decimals ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.decimalIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.decimalIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.decimalValues[i]);
            }
        }
        if (this.timestampValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("timestamps ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.timestampIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.timestampIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.timestampValues[i]);
            }
        }
        if (this.intervalDayTimeValues.length > 0) {
            if (isFirstKey) {
                isFirstKey = false;
            } else {
                sb.append(", ");
            }
            sb.append("interval day times ");
            isFirstValue = true;
            for (i = 0; i < columnSetInfo.intervalDayTimeIndices.length; ++i) {
                if (isFirstValue) {
                    isFirstValue = false;
                } else {
                    sb.append(", ");
                }
                keyIndex = columnSetInfo.intervalDayTimeIndices[i];
                if (this.isNull[keyIndex]) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.intervalDayTimeValues[i]);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (this.longValues.length > 0) {
            isFirst = false;
            sb.append("longs ");
            sb.append(Arrays.toString(this.longValues));
        }
        if (this.doubleValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("doubles ");
            sb.append(Arrays.toString(this.doubleValues));
        }
        if (this.byteValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("byte lengths ");
            sb.append(Arrays.toString(this.byteLengths));
        }
        if (this.decimalValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("decimals ");
            sb.append(Arrays.toString(this.decimalValues));
        }
        if (this.timestampValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("timestamps ");
            sb.append(Arrays.toString(this.timestampValues));
        }
        if (this.intervalDayTimeValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("interval day times ");
            sb.append(Arrays.toString(this.intervalDayTimeValues));
        }
        if (isFirst) {
            isFirst = false;
        } else {
            sb.append(", ");
        }
        sb.append("nulls ");
        sb.append(Arrays.toString(this.isNull));
        return sb.toString();
    }

    public long getLongValue(int i) {
        return this.longValues[i];
    }

    public double getDoubleValue(int i) {
        return this.doubleValues[i];
    }

    public byte[] getBytes(int i) {
        return this.byteValues[i];
    }

    public int getByteStart(int i) {
        return this.byteStarts[i];
    }

    public int getByteLength(int i) {
        return this.byteLengths[i];
    }

    public int getVariableSize() {
        int variableSize = 0;
        for (int i = 0; i < this.byteLengths.length; ++i) {
            JavaDataModel model = JavaDataModel.get();
            variableSize = (int)((long)variableSize + model.lengthForByteArrayOfSize((long)this.byteLengths[i]));
        }
        return variableSize;
    }

    public HiveDecimalWritable getDecimal(int i) {
        return this.decimalValues[i];
    }

    public Timestamp getTimestamp(int i) {
        return this.timestampValues[i];
    }

    public HiveIntervalDayTime getIntervalDayTime(int i) {
        return this.intervalDayTimeValues[i];
    }

    public void clearIsNull() {
        Arrays.fill(this.isNull, false);
    }

    public void setNull() {
        Arrays.fill(this.isNull, true);
    }

    public boolean isNull(int keyIndex) {
        return this.isNull[keyIndex];
    }

    public static final class EmptyVectorHashKeyWrapper
    extends VectorHashKeyWrapper {
        private EmptyVectorHashKeyWrapper() {
            super(null, 0, 0, 0, 0, 0, 0, 0);
        }

        @Override
        protected Object clone() {
            return this;
        }

        @Override
        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            return super.equals(that);
        }
    }

    public static final class HashContext {
        private final Murmur3.IncrementalHash32 bytesHash = new Murmur3.IncrementalHash32();

        public static Murmur3.IncrementalHash32 getBytesHash(HashContext ctx) {
            if (ctx == null) {
                return new Murmur3.IncrementalHash32();
            }
            return ctx.bytesHash;
        }
    }
}

