/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.llap.LlapOutputFormatService;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.io.StreamingOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class LlapOutputFormat<K extends Writable, V extends Writable>
implements OutputFormat<K, V>,
StreamingOutputFormat {
    public static final String LLAP_OF_ID_KEY = "llap.of.id";

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        if (!LlapProxy.isDaemon()) {
            throw new IOException("LlapOutputFormat can only be used inside Llap");
        }
        try {
            return LlapOutputFormatService.get().getWriter(job.get(LLAP_OF_ID_KEY));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

