/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.monitoring.StateDumpServlet;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.LogMonitoring;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RSDumpServlet
extends StateDumpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "===========================================================";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HRegionServer hrs = (HRegionServer)this.getServletContext().getAttribute("regionserver");
        assert (hrs != null) : "No RS in context!";
        response.setContentType("text/plain");
        if (!hrs.isOnline()) {
            response.getWriter().write("The RegionServer is initializing!");
            response.getWriter().close();
            return;
        }
        ServletOutputStream os = response.getOutputStream();
        try (PrintWriter out = new PrintWriter((OutputStream)os);){
            out.println("RegionServer status for " + hrs.getServerName() + " as of " + new Date());
            out.println("\n\nVersion Info:");
            out.println(LINE);
            this.dumpVersionInfo(out);
            out.println("\n\nTasks:");
            out.println(LINE);
            TaskMonitor.get().dumpAsText(out);
            out.println("\n\nRowLocks:");
            out.println(LINE);
            RSDumpServlet.dumpRowLock(hrs, out);
            out.println("\n\nExecutors:");
            out.println(LINE);
            this.dumpExecutors(hrs.getExecutorService(), out);
            out.println("\n\nStacks:");
            out.println(LINE);
            PrintStream ps = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");
            Threads.printThreadInfo((PrintStream)ps, (String)"");
            ps.flush();
            out.println("\n\nRS Configuration:");
            out.println(LINE);
            Configuration conf = hrs.getConfiguration();
            out.flush();
            conf.writeXml((OutputStream)os);
            os.flush();
            out.println("\n\nLogs");
            out.println(LINE);
            long tailKb = this.getTailKbParam(request);
            LogMonitoring.dumpTailOfLogs((PrintWriter)out, (long)tailKb);
            out.println("\n\nRS Queue:");
            out.println(LINE);
            if (this.isShowQueueDump(conf)) {
                RSDumpServlet.dumpQueue(hrs, out);
            }
            out.println("\n\nCall Queue Summary:");
            out.println(LINE);
            RSDumpServlet.dumpCallQueues(hrs, out);
            out.flush();
        }
    }

    public static void dumpRowLock(HRegionServer hrs, PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        for (Region region : hrs.getRegions()) {
            HRegion hRegion = (HRegion)region;
            if (hRegion.getLockedRows().size() <= 0) continue;
            for (HRegion.RowLockContext rowLockContext : hRegion.getLockedRows().values()) {
                sb.setLength(0);
                sb.append(hRegion.getTableDescriptor().getTableName()).append(",").append(hRegion.getRegionInfo().getEncodedName()).append(",");
                sb.append(rowLockContext.toString());
                out.println(sb.toString());
            }
        }
    }

    public static void dumpQueue(HRegionServer hrs, PrintWriter out) throws IOException {
        if (hrs.compactSplitThread != null) {
            out.println("Compaction/Split Queue summary: " + hrs.compactSplitThread.toString());
            out.println(hrs.compactSplitThread.dumpQueue());
        }
        if (hrs.getMemStoreFlusher() != null) {
            out.println("\nFlush Queue summary: " + hrs.getMemStoreFlusher().toString());
            out.println(hrs.getMemStoreFlusher().dumpQueue());
        }
    }

    public static void dumpCallQueues(HRegionServer hrs, PrintWriter out) {
        CallQueueInfo callQueueInfo = hrs.rpcServices.rpcServer.getScheduler().getCallQueueInfo();
        for (String queueName : callQueueInfo.getCallQueueNames()) {
            out.println("\nQueue Name: " + queueName);
            long totalCallCount = 0L;
            long totalCallSize = 0L;
            for (String methodName : callQueueInfo.getCalledMethodNames(queueName)) {
                long thisMethodCount = callQueueInfo.getCallMethodCount(queueName, methodName);
                long thisMethodSize = callQueueInfo.getCallMethodSize(queueName, methodName);
                out.println("Method in call: " + methodName);
                out.println("Total call count for method: " + thisMethodCount);
                out.println("Total call size for method (bytes): " + thisMethodSize);
                totalCallCount += thisMethodCount;
                totalCallSize += thisMethodSize;
            }
            out.println("Total call count for queue: " + totalCallCount);
            out.println("Total call size for queue (bytes): " + totalCallSize);
        }
    }
}

