/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.HealthTracker;
import org.apache.spark.scheduler.HealthTracker$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

public final class TaskSchedulerImpl$ {
    public static TaskSchedulerImpl$ MODULE$;
    private final String SCHEDULER_MODE_PROPERTY;

    static {
        new TaskSchedulerImpl$();
    }

    public boolean $lessinit$greater$default$3() {
        return false;
    }

    public Clock $lessinit$greater$default$4() {
        return new SystemClock();
    }

    public String SCHEDULER_MODE_PROPERTY() {
        return this.SCHEDULER_MODE_PROPERTY;
    }

    public int calculateAvailableSlots(TaskSchedulerImpl scheduler, SparkConf conf, int rpId, int[] availableRPIds, int[] availableCpus, Map<String, Object>[] availableResources) {
        Tuple2 tuple2;
        String limiting;
        ResourceProfile resourceProfile = scheduler.sc().resourceProfileManager().resourceProfileFromId(rpId);
        boolean coresKnown = resourceProfile.isCoresLimitKnown();
        String string = limiting = resourceProfile.limitingResource(conf);
        String string2 = ResourceProfile$.MODULE$.CPUS();
        Tuple2 tuple22 = !(string == null ? string2 != null : !string.equals(string2)) || limiting.isEmpty() ? new Tuple2((Object)ResourceProfile$.MODULE$.CPUS(), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : (tuple2 = new Tuple2((Object)limiting, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String limitingResource = (String)tuple2._1();
        boolean limitedByCpu = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)limitingResource, (Object)BoxesRunTime.boxToBoolean((boolean)limitedByCpu));
        String limitingResource2 = (String)tuple23._1();
        boolean limitedByCpu2 = tuple23._2$mcZ$sp();
        int cpusPerTask = ResourceProfile$.MODULE$.getTaskCpusOrDefaultForProfile(resourceProfile, conf);
        double taskLimit = BoxesRunTime.unboxToDouble((Object)resourceProfile.taskResources().get((Object)limitingResource2).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToDouble((double)x$28.amount())).get());
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(availableCpus)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])availableResources), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zip((GenIterable)Predef$.MODULE$.wrapIntArray(availableRPIds), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TaskSchedulerImpl$.$anonfun$calculateAvailableSlots$2(scheduler, rpId, x0$1))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)TaskSchedulerImpl$.$anonfun$calculateAvailableSlots$3(cpusPerTask, limitedByCpu2, limitingResource2, taskLimit, coresKnown, x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public <K, T> List<T> prioritizeContainers(HashMap<K, ArrayBuffer<T>> map) {
        ArrayBuffer _keyList = new ArrayBuffer(map.size());
        _keyList.$plus$plus$eq((TraversableOnce)map.keys());
        ArrayBuffer keyList = (ArrayBuffer)_keyList.sortWith((Function2 & Serializable & scala.Serializable)(left, right) -> BoxesRunTime.boxToBoolean((boolean)TaskSchedulerImpl$.$anonfun$prioritizeContainers$1(map, left, right)));
        ArrayBuffer retval = new ArrayBuffer(keyList.size() * 2);
        IntRef index = IntRef.create((int)0);
        BooleanRef found = BooleanRef.create((boolean)true);
        while (found.elem) {
            found.elem = false;
            keyList.foreach((Function1 & Serializable & scala.Serializable)key -> {
                TaskSchedulerImpl$.$anonfun$prioritizeContainers$2(map, index, retval, found, key);
                return BoxedUnit.UNIT;
            });
            ++index.elem;
        }
        return retval.toList();
    }

    public Option<HealthTracker> org$apache$spark$scheduler$TaskSchedulerImpl$$maybeCreateHealthTracker(SparkContext sc) {
        if (HealthTracker$.MODULE$.isExcludeOnFailureEnabled(sc.conf())) {
            None$ none$;
            SchedulerBackend schedulerBackend = sc.schedulerBackend();
            if (schedulerBackend instanceof ExecutorAllocationClient) {
                SchedulerBackend schedulerBackend2 = schedulerBackend;
                none$ = new Some((Object)schedulerBackend2);
            } else {
                none$ = None$.MODULE$;
            }
            None$ executorAllocClient = none$;
            return new Some((Object)new HealthTracker(sc, (Option<ExecutorAllocationClient>)executorAllocClient));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$calculateAvailableSlots$2(TaskSchedulerImpl scheduler$1, int rpId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int id = tuple2._2$mcI$sp();
            return scheduler$1.sc().resourceProfileManager().canBeScheduled(rpId$1, id);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$calculateAvailableSlots$3(int cpusPerTask$1, boolean limitedByCpu$1, String limitingResource$1, double taskLimit$1, boolean coresKnown$1, Tuple2 x0$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$2;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            int cpu = tuple2._1$mcI$sp();
            Map resources = (Map)tuple2._2();
            int numTasksPerExecCores = cpu / cpusPerTask$1;
            if (limitedByCpu$1) {
                return numTasksPerExecCores;
            }
            int availAddrs = BoxesRunTime.unboxToInt((Object)resources.getOrElse((Object)limitingResource$1, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int resourceLimit = (int)((double)availAddrs / taskLimit$1);
            if (!coresKnown$1 && numTasksPerExecCores <= resourceLimit) {
                return numTasksPerExecCores;
            }
            return resourceLimit;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$prioritizeContainers$1(HashMap map$1, Object left, Object right) {
        return ((SeqLike)map$1.apply(left)).size() > ((SeqLike)map$1.apply(right)).size();
    }

    public static final /* synthetic */ void $anonfun$prioritizeContainers$2(HashMap map$1, IntRef index$2, ArrayBuffer retval$1, BooleanRef found$1, Object key) {
        ArrayBuffer containerList = (ArrayBuffer)map$1.getOrElse(key, (Function0 & Serializable & scala.Serializable)() -> null);
        Predef$.MODULE$.assert(containerList != null);
        if (index$2.elem < containerList.size()) {
            retval$1.$plus$eq(containerList.apply(index$2.elem));
            found$1.elem = true;
            return;
        }
    }

    private TaskSchedulerImpl$() {
        MODULE$ = this;
        this.SCHEDULER_MODE_PROPERTY = package$.MODULE$.SCHEDULER_MODE().key();
    }
}

