/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExcludedExecutor;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorDecommissionInfo$;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.HealthTracker$;
import org.apache.spark.scheduler.HealthTracker$ExecutorFailureList$TaskId$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorExcluded;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorUnexcluded;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeExcluded;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.scheduler.SparkListenerNodeUnexcluded;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd!B.]\u0001q#\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011B:\t\u0011a\u0004!\u0011!Q\u0001\nQD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0004\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005\u001d\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\ty\u0004\u0001Q\u0001\n\u0005e\u0002\"CA!\u0001\t\u0007I\u0011BA\u001c\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005e\u0002\"CA#\u0001\t\u0007I\u0011AA$\u0011!\ty\u0005\u0001Q\u0001\n\u0005%\u0003\"CA)\u0001\t\u0007I\u0011BA*\u0011!\tY\u0006\u0001Q\u0001\n\u0005U\u0003\"CA/\u0001\t\u0007I\u0011BA*\u0011!\ty\u0006\u0001Q\u0001\n\u0005U\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\u0011Y\n\u0001Q\u0001\n\u0005\u0015\u0004\"\u0003BO\u0001\t\u0007I\u0011\u0001BP\u0011!\u0011I\u000b\u0001Q\u0001\n\t\u0005\u0006\"\u0003BV\u0001\t\u0007I\u0011\u0001BW\u0011!\u0011\t\f\u0001Q\u0001\n\t=\u0006\"\u0003BZ\u0001\t\u0007I\u0011\u0002B[\u0011!\u0011y\r\u0001Q\u0001\n\t]\u0006\"\u0003Bi\u0001\u0001\u0007I\u0011AA$\u0011%\u0011\u0019\u000e\u0001a\u0001\n\u0003\u0011)\u000e\u0003\u0005\u0003Z\u0002\u0001\u000b\u0015BA%\u0011%\u0011Y\u000e\u0001b\u0001\n\u0003\u0011i\u000e\u0003\u0005\u0003h\u0002\u0001\u000b\u0011\u0002Bp\u0011\u001d\u0011I\u000f\u0001C\u0001\u0005WDqA!<\u0001\t\u0013\u0011Y\u000fC\u0004\u0003p\u0002!IA!=\t\u000f\tm\b\u0001\"\u0003\u0003~\"A1\u0011\u0001\u0001\u0005\u0002q\u001b\u0019\u0001C\u0004\u0004\b\u0001!Ia!\u0003\t\u000f\r=\u0001\u0001\"\u0001\u0004\u0012!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0016\u0001\u0011\u00051Q\u0006\u0005\b\u0007g\u0001A\u0011AB\u001b\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sAqa!\u0010\u0001\t\u0003\u0019yDB\u0004\u0002\u0010\u0002\u0011A,!%\t\u000f\u0005e1\u0006\"\u0001\u0002\u0014\u001a1\u0011QS\u0016E\u0003/C!\"!*.\u0005+\u0007I\u0011AA\u001c\u0011)\t9+\fB\tB\u0003%\u0011\u0011\b\u0005\u000b\u0003Sk#Q3A\u0005\u0002\u0005]\u0002BCAV[\tE\t\u0015!\u0003\u0002:!Q\u0011QV\u0017\u0003\u0016\u0004%\t!a\u000e\t\u0015\u0005=VF!E!\u0002\u0013\tI\u0004C\u0004\u0002\u001a5\"\t!!-\t\u0013\u0005uV&!A\u0005\u0002\u0005}\u0006\"CAd[E\u0005I\u0011AAe\u0011%\ty.LI\u0001\n\u0003\tI\rC\u0005\u0002b6\n\n\u0011\"\u0001\u0002J\"I\u00111]\u0017\u0002\u0002\u0013\u0005\u0013Q\u001d\u0005\n\u0003kl\u0013\u0011!C\u0001\u0003oA\u0011\"a>.\u0003\u0003%\t!!?\t\u0013\t\u0015Q&!A\u0005B\t\u001d\u0001\"\u0003B\t[\u0005\u0005I\u0011\u0001B\n\u0011%\u00119\"LA\u0001\n\u0003\u0012I\u0002C\u0005\u0003\u001c5\n\t\u0011\"\u0011\u0003\u001e!I!qD\u0017\u0002\u0002\u0013\u0005#\u0011E\u0004\n\u0005KY\u0013\u0011!E\u0005\u0005O1\u0011\"!&,\u0003\u0003EIA!\u000b\t\u000f\u0005e!\t\"\u0001\u00038!I!1\u0004\"\u0002\u0002\u0013\u0015#Q\u0004\u0005\n\u0005s\u0011\u0015\u0011!CA\u0005wA\u0011Ba\u0011C\u0003\u0003%\tI!\u0012\t\u0013\tM3\u00061A\u0005\n\tU\u0003\"\u0003B2W\u0001\u0007I\u0011\u0002B3\u0011!\u0011yg\u000bQ!\n\t]\u0003\"\u0003B9W\u0001\u0007I\u0011BA$\u0011%\u0011\u0019h\u000ba\u0001\n\u0013\u0011)\b\u0003\u0005\u0003z-\u0002\u000b\u0015BA%\u0011\u001d\u0011Yh\u000bC\u0001\u0005{BqA!$,\t\u0003\t9\u0004C\u0004\u0003\u0010.\"\t!a\u0015\t\u000f\tE5\u0006\"\u0001\u0003\u0014\"9!1D\u0016\u0005B\teu\u0001CB\"9\"\u0005al!\u0012\u0007\u000fmc\u0006\u0012\u00010\u0004H!9\u0011\u0011D*\u0005\u0002\r%\u0003\"CB&'\n\u0007I\u0011BAs\u0011!\u0019ie\u0015Q\u0001\n\u0005\u001d\bbBB('\u0012\u00051\u0011\u000b\u0005\b\u0007+\u001aF\u0011AB,\u0011\u001d\u0019Yf\u0015C\u0001\u0007;B\u0011b!\u0019T#\u0003%\taa\u0019\u0003\u001b!+\u0017\r\u001c;i)J\f7m[3s\u0015\tif,A\u0005tG\",G-\u001e7fe*\u0011q\fY\u0001\u0006gB\f'o\u001b\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014xmE\u0002\u0001K.\u0004\"AZ5\u000e\u0003\u001dT\u0011\u0001[\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001e\u0014a!\u00118z%\u00164\u0007C\u00017p\u001b\u0005i'B\u00018_\u0003!Ig\u000e^3s]\u0006d\u0017B\u00019n\u0005\u001daunZ4j]\u001e\f1\u0002\\5ti\u0016tWM\u001d\"vg\u000e\u0001Q#\u0001;\u0011\u0005U4X\"\u0001/\n\u0005]d&a\u0004'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\u0002\t\r|gN\u001a\t\u0003wrl\u0011AX\u0005\u0003{z\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002!\u0005dGn\\2bi&|gn\u00117jK:$\b#\u00024\u0002\u0002\u0005\u0015\u0011bAA\u0002O\n1q\n\u001d;j_:\u00042a_A\u0004\u0013\r\tIA\u0018\u0002\u0019\u000bb,7-\u001e;pe\u0006cGn\\2bi&|gn\u00117jK:$\u0018!B2m_\u000e\\\u0007\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005Ma,\u0001\u0003vi&d\u0017\u0002BA\f\u0003#\u0011Qa\u00117pG.\fa\u0001P5oSRtDCCA\u000f\u0003?\t\t#a\t\u0002&A\u0011Q\u000f\u0001\u0005\u0006c\u001a\u0001\r\u0001\u001e\u0005\u0006s\u001a\u0001\rA\u001f\u0005\u0006}\u001a\u0001\ra \u0005\n\u0003\u00171\u0001\u0013!a\u0001\u0003\u001b!b!!\b\u0002*\u0005M\u0002bBA\u0016\u000f\u0001\u0007\u0011QF\u0001\u0003g\u000e\u00042a_A\u0018\u0013\r\t\tD\u0018\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006}\u001e\u0001\ra`\u0001\u0016\u001b\u0006CvLR!J\u0019V\u0013ViU0Q\u000bJ{V\tW#D+\t\tI\u0004E\u0002g\u0003wI1!!\u0010h\u0005\rIe\u000e^\u0001\u0017\u001b\u0006CvLR!J\u0019V\u0013ViU0Q\u000bJ{V\tW#DA\u0005AR*\u0011-`\r\u0006KE*\u0012#`\u000bb+5i\u0018)F%~su\nR#\u000235\u000b\u0005l\u0018$B\u00132+EiX#Y\u000b\u000e{\u0006+\u0012*`\u001d>#U\tI\u0001\"\u000bb\u001bE*\u0016#F?>suLR!J\u0019V\u0013Vi\u0018+J\u001b\u0016{U\u000bV0N\u00132c\u0015jU\u000b\u0003\u0003\u0013\u00022AZA&\u0013\r\tie\u001a\u0002\u0005\u0019>tw-\u0001\u0012F1\u000ecU\u000bR#`\u001f:{f)Q%M+J+u\fV%N\u000b>+FkX'J\u00192K5\u000bI\u0001\u001e\u000bb\u001bE*\u0016#F?\u001a+Ek\u0011%`\r\u0006KE*\u0016*F?\u0016s\u0015I\u0011'F\tV\u0011\u0011Q\u000b\t\u0004M\u0006]\u0013bAA-O\n9!i\\8mK\u0006t\u0017AH#Y\u00072+F)R0G\u000bR\u001b\u0005j\u0018$B\u00132+&+R0F\u001d\u0006\u0013E*\u0012#!\u0003\u001d*\u0005l\u0011'V\t\u0016{vJT0G\u0003&cUKU#`\t\u0016\u001bu*T'J'NKuJT0F\u001d\u0006\u0013E*\u0012#\u0002Q\u0015C6\tT+E\u000b~{ej\u0018$B\u00132+&+R0E\u000b\u000e{U*T%T'&{ejX#O\u0003\ncU\t\u0012\u0011\u0002/\u0015DXmY;u_JLE\rV8GC&dWO]3MSN$XCAA3!!\t9'!\u001d\u0002v\u0005-UBAA5\u0015\u0011\tY'!\u001c\u0002\u000f5,H/\u00192mK*\u0019\u0011qN4\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u0005%$a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003o\n)I\u0004\u0003\u0002z\u0005\u0005\u0005cAA>O6\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\u0012\u0018A\u0002\u001fs_>$h(C\u0002\u0002\u0004\u001e\fa\u0001\u0015:fI\u00164\u0017\u0002BAD\u0003\u0013\u0013aa\u0015;sS:<'bAABOB\u0019\u0011QR\u0016\u000e\u0003\u0001\u00111#\u0012=fGV$xN\u001d$bS2,(/\u001a'jgR\u001c2aK3l)\t\tYI\u0001\u0004UCN\\\u0017\nZ\n\u0007[\u0015\fI*a(\u0011\u0007\u0019\fY*C\u0002\u0002\u001e\u001e\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002g\u0003CK1!a)h\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019H/Y4f\u0003\u0019\u0019H/Y4fA\u0005a1\u000f^1hK\u0006#H/Z7qi\u0006i1\u000f^1hK\u0006#H/Z7qi\u0002\n\u0011\u0002^1tW&sG-\u001a=\u0002\u0015Q\f7o[%oI\u0016D\b\u0005\u0006\u0005\u00024\u0006]\u0016\u0011XA^!\r\t),L\u0007\u0002W!9\u0011Q\u0015\u001bA\u0002\u0005e\u0002bBAUi\u0001\u0007\u0011\u0011\b\u0005\b\u0003[#\u0004\u0019AA\u001d\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005M\u0016\u0011YAb\u0003\u000bD\u0011\"!*6!\u0003\u0005\r!!\u000f\t\u0013\u0005%V\u0007%AA\u0002\u0005e\u0002\"CAWkA\u0005\t\u0019AA\u001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a3+\t\u0005e\u0012QZ\u0016\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\\4\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006M'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\b\u0003BAu\u0003gl!!a;\u000b\t\u00055\u0018q^\u0001\u0005Y\u0006twM\u0003\u0002\u0002r\u0006!!.\u0019<b\u0013\u0011\t9)a;\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111 B\u0001!\r1\u0017Q`\u0005\u0004\u0003\u007f<'aA!os\"I!1A\u001e\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t%\u0001C\u0002B\u0006\u0005\u001b\tY0\u0004\u0002\u0002n%!!qBA7\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U#Q\u0003\u0005\n\u0005\u0007i\u0014\u0011!a\u0001\u0003w\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003s\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003O\fa!Z9vC2\u001cH\u0003BA+\u0005GA\u0011Ba\u0001A\u0003\u0003\u0005\r!a?\u0002\rQ\u000b7o[%e!\r\t)LQ\n\u0006\u0005\n-\u0012q\u0014\t\r\u0005[\u0011\u0019$!\u000f\u0002:\u0005e\u00121W\u0007\u0003\u0005_Q1A!\rh\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u000e\u00030\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t\u001d\u0012!B1qa2LH\u0003CAZ\u0005{\u0011yD!\u0011\t\u000f\u0005\u0015V\t1\u0001\u0002:!9\u0011\u0011V#A\u0002\u0005e\u0002bBAW\u000b\u0002\u0007\u0011\u0011H\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ea\u0014\u0011\u000b\u0019\f\tA!\u0013\u0011\u0013\u0019\u0014Y%!\u000f\u0002:\u0005e\u0012b\u0001B'O\n1A+\u001e9mKNB\u0011B!\u0015G\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0003'\u0001\fgC&dWO]3t\u0003:$W\t\u001f9jef$\u0016.\\3t+\t\u00119\u0006\u0005\u0004\u0002h\te#QL\u0005\u0005\u00057\nIGA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u00024\u0003`\u0005M\u0016\u0011J\u0005\u0004\u0005C:'A\u0002+va2,''\u0001\u000egC&dWO]3t\u0003:$W\t\u001f9jef$\u0016.\\3t?\u0012*\u0017\u000f\u0006\u0003\u0003h\t5\u0004c\u00014\u0003j%\u0019!1N4\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u0007A\u0015\u0011!a\u0001\u0005/\nqCZ1jYV\u0014Xm]!oI\u0016C\b/\u001b:z)&lWm\u001d\u0011\u0002\u001b5Lg.\u0012=qSJLH+[7f\u0003Ei\u0017N\\#ya&\u0014\u0018\u0010V5nK~#S-\u001d\u000b\u0005\u0005O\u00129\bC\u0005\u0003\u0004-\u000b\t\u00111\u0001\u0002J\u0005qQ.\u001b8FqBL'/\u001f+j[\u0016\u0004\u0013aC1eI\u001a\u000b\u0017\u000e\\;sKN$\u0002Ba\u001a\u0003\u0000\t\u0005%1\u0011\u0005\b\u0003Kk\u0005\u0019AA\u001d\u0011\u001d\tI+\u0014a\u0001\u0003sAqA!\"N\u0001\u0004\u00119)A\tgC&dWO]3t\u0013:$\u0016m]6TKR\u00042!\u001eBE\u0013\r\u0011Y\t\u0018\u0002\u001a\u000bb,7-\u001e;pe\u001a\u000b\u0017\u000e\\;sKNLe\u000eV1tWN+G/A\u000bok6,f.[9vKR\u000b7o\u001b$bS2,(/Z:\u0002\u000f%\u001cX)\u001c9us\u0006iBM]8q\r\u0006LG.\u001e:fg^KG\u000f\u001b+j[\u0016|W\u000f\u001e\"fM>\u0014X\r\u0006\u0003\u0003h\tU\u0005b\u0002BL!\u0002\u0007\u0011\u0011J\u0001\u000bIJ|\u0007OQ3g_J,GCAA;\u0003a)\u00070Z2vi>\u0014\u0018\n\u001a+p\r\u0006LG.\u001e:f\u0019&\u001cH\u000fI\u0001\u001bKb,7-\u001e;pe&#Gk\\#yG2,H-\u001a3Ti\u0006$Xo]\u000b\u0003\u0005C\u0003\u0002\"a\u001a\u0002r\u0005U$1\u0015\t\u0004k\n\u0015\u0016b\u0001BT9\n\u0001R\t_2mk\u0012,G-\u0012=fGV$xN]\u0001\u001cKb,7-\u001e;pe&#Gk\\#yG2,H-\u001a3Ti\u0006$Xo\u001d\u0011\u000259|G-Z%e)>,\u0005p\u00197vI\u0016$W\t\u001f9jef$\u0016.\\3\u0016\u0005\t=\u0006\u0003CA4\u0003c\n)(!\u0013\u000279|G-Z%e)>,\u0005p\u00197vI\u0016$W\t\u001f9jef$\u0016.\\3!\u0003EyV\r_2mk\u0012,GMT8eK2K7\u000f^\u000b\u0003\u0005o\u0003bA!/\u0003F\n%WB\u0001B^\u0015\u0011\u0011iLa0\u0002\r\u0005$x.\\5d\u0015\u0011\u0011\tMa1\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0014\u0005=\u0018\u0002\u0002Bd\u0005w\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0007\u0003o\u0012Y-!\u001e\n\t\t5\u0017\u0011\u0012\u0002\u0004'\u0016$\u0018AE0fq\u000edW\u000fZ3e\u001d>$W\rT5ti\u0002\naB\\3yi\u0016C\b/\u001b:z)&lW-\u0001\noKb$X\t\u001f9jef$\u0016.\\3`I\u0015\fH\u0003\u0002B4\u0005/D\u0011Ba\u0001\u001c\u0003\u0003\u0005\r!!\u0013\u0002\u001f9,\u0007\u0010^#ya&\u0014\u0018\u0010V5nK\u0002\n1C\\8eKR{W\t_2mk\u0012,G-\u0012=fGN,\"Aa8\u0011\u0011\u0005\u001d\u0014\u0011OA;\u0005C\u0004b!a\u001a\u0003d\u0006U\u0014\u0002\u0002Bs\u0003S\u0012q\u0001S1tQN+G/\u0001\u000bo_\u0012,Gk\\#yG2,H-\u001a3Fq\u0016\u001c7\u000fI\u0001\u001dCB\u0004H._#yG2,H-Z(o\r\u0006LG.\u001e:f)&lWm\\;u)\t\u00119'\u0001\u000bva\u0012\fG/\u001a(fqR,\u0005\u0010]5ssRKW.Z\u0001\rW&dG.\u0012=fGV$xN\u001d\u000b\u0007\u0005O\u0012\u0019Pa>\t\u000f\tU\u0018\u00051\u0001\u0002v\u0005!Q\r_3d\u0011\u001d\u0011I0\ta\u0001\u0003k\n1!\\:h\u0003QY\u0017\u000e\u001c7Fq\u000edW\u000fZ3e\u000bb,7-\u001e;peR!!q\rB\u0000\u0011\u001d\u0011)P\ta\u0001\u0003k\n\u0001d[5mY\u0016C8\r\\;eK\u0012LE\r\\3Fq\u0016\u001cW\u000f^8s)\u0011\u00119g!\u0002\t\u000f\tU8\u00051\u0001\u0002v\u0005Y2.\u001b7m\u000bb,7-\u001e;peN|e.\u0012=dYV$W\r\u001a(pI\u0016$BAa\u001a\u0004\f!91Q\u0002\u0013A\u0002\u0005U\u0014\u0001\u00028pI\u0016\fQ$\u001e9eCR,W\t_2mk\u0012,GMR8s\r\u0016$8\r\u001b$bS2,(/\u001a\u000b\u0007\u0005O\u001a\u0019ba\u0006\t\u000f\rUQ\u00051\u0001\u0002v\u0005!\u0001n\\:u\u0011\u001d\u0011)0\na\u0001\u0003k\n!%\u001e9eCR,W\t_2mk\u0012,GMR8s'V\u001c7-Z:tMVdG+Y:l'\u0016$H\u0003\u0003B4\u0007;\u0019\tc!\n\t\u000f\r}a\u00051\u0001\u0002:\u000591\u000f^1hK&#\u0007bBB\u0012M\u0001\u0007\u0011\u0011H\u0001\u000fgR\fw-Z!ui\u0016l\u0007\u000f^%e\u0011\u001d\u00199C\na\u0001\u0007S\taBZ1jYV\u0014Xm\u001d\"z\u000bb,7\r\u0005\u0005\u0002h\u0005E\u0014Q\u000fBD\u0003II7/\u0012=fGV$xN]#yG2,H-\u001a3\u0015\t\u0005U3q\u0006\u0005\b\u0007c9\u0003\u0019AA;\u0003))\u00070Z2vi>\u0014\u0018\nZ\u0001\u0011Kb\u001cG.\u001e3fI:{G-\u001a'jgR$\"A!3\u0002\u001d%\u001chj\u001c3f\u000bb\u001cG.\u001e3fIR!\u0011QKB\u001e\u0011\u001d\u0019i!\u000ba\u0001\u0003k\nQ\u0003[1oI2,'+Z7pm\u0016$W\t_3dkR|'\u000f\u0006\u0003\u0003h\r\u0005\u0003bBB\u0019U\u0001\u0007\u0011QO\u0001\u000e\u0011\u0016\fG\u000e\u001e5Ue\u0006\u001c7.\u001a:\u0011\u0005U\u001c6cA*fWR\u00111QI\u0001\u0010\t\u00163\u0015)\u0016'U?RKU*R(V)\u0006\u0001B)\u0012$B+2#v\fV%N\u000b>+F\u000bI\u0001\u001aSN,\u0005p\u00197vI\u0016|eNR1jYV\u0014X-\u00128bE2,G\r\u0006\u0003\u0002V\rM\u0003\"B=X\u0001\u0004Q\u0018!G4fi\u0016CH.\u001e3f\u001f:4\u0015-\u001b7ve\u0016$\u0016.\\3pkR$B!!\u0013\u0004Z!)\u0011\u0010\u0017a\u0001u\u0006ib/\u00197jI\u0006$X-\u0012=dYV$Wm\u00148GC&dWO]3D_:47\u000f\u0006\u0003\u0003h\r}\u0003\"B=Z\u0001\u0004Q\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004f)\"\u0011QBAg\u0001")
public class HealthTracker
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final Option<ExecutorAllocationClient> allocationClient;
    private final Clock clock;
    private final int MAX_FAILURES_PER_EXEC;
    private final int MAX_FAILED_EXEC_PER_NODE;
    private final long EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS;
    private final boolean EXCLUDE_FETCH_FAILURE_ENABLED;
    private final boolean EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED;
    private final HashMap<String, ExecutorFailureList> executorIdToFailureList;
    private final HashMap<String, ExcludedExecutor> executorIdToExcludedStatus;
    private final HashMap<String, Object> nodeIdToExcludedExpiryTime;
    private final AtomicReference<Set<String>> _excludedNodeList;
    private long nextExpiryTime;
    private final HashMap<String, HashSet<String>> nodeToExcludedExecs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$4() {
        return HealthTracker$.MODULE$.$lessinit$greater$default$4();
    }

    public static void validateExcludeOnFailureConfs(SparkConf sparkConf) {
        HealthTracker$.MODULE$.validateExcludeOnFailureConfs(sparkConf);
    }

    public static long getExludeOnFailureTimeout(SparkConf sparkConf) {
        return HealthTracker$.MODULE$.getExludeOnFailureTimeout(sparkConf);
    }

    public static boolean isExcludeOnFailureEnabled(SparkConf sparkConf) {
        return HealthTracker$.MODULE$.isExcludeOnFailureEnabled(sparkConf);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private int MAX_FAILURES_PER_EXEC() {
        return this.MAX_FAILURES_PER_EXEC;
    }

    private int MAX_FAILED_EXEC_PER_NODE() {
        return this.MAX_FAILED_EXEC_PER_NODE;
    }

    public long EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS() {
        return this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS;
    }

    private boolean EXCLUDE_FETCH_FAILURE_ENABLED() {
        return this.EXCLUDE_FETCH_FAILURE_ENABLED;
    }

    private boolean EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED() {
        return this.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED;
    }

    private HashMap<String, ExecutorFailureList> executorIdToFailureList() {
        return this.executorIdToFailureList;
    }

    public HashMap<String, ExcludedExecutor> executorIdToExcludedStatus() {
        return this.executorIdToExcludedStatus;
    }

    public HashMap<String, Object> nodeIdToExcludedExpiryTime() {
        return this.nodeIdToExcludedExpiryTime;
    }

    private AtomicReference<Set<String>> _excludedNodeList() {
        return this._excludedNodeList;
    }

    public long nextExpiryTime() {
        return this.nextExpiryTime;
    }

    public void nextExpiryTime_$eq(long x$1) {
        this.nextExpiryTime = x$1;
    }

    public HashMap<String, HashSet<String>> nodeToExcludedExecs() {
        return this.nodeToExcludedExecs;
    }

    public void applyExcludeOnFailureTimeout() {
        long now = this.clock.getTimeMillis();
        if (now > this.nextExpiryTime()) {
            Iterable nodesToInclude;
            Iterable execsToInclude = ((MapLike)this.executorIdToExcludedStatus().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HealthTracker.$anonfun$applyExcludeOnFailureTimeout$1(now, x$1)))).keys();
            if (execsToInclude.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Removing executors ").append(execsToInclude).append(" from exclude list because the ").append("the executors have reached the timed out").toString());
                execsToInclude.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    ExcludedExecutor status = (ExcludedExecutor)this.executorIdToExcludedStatus().remove(exec).get();
                    HashSet failedExecsOnNode = (HashSet)this.nodeToExcludedExecs().apply((Object)status.node());
                    this.listenerBus().post(new SparkListenerExecutorUnblacklisted(now, (String)exec));
                    this.listenerBus().post(new SparkListenerExecutorUnexcluded(now, (String)exec));
                    failedExecsOnNode.remove(exec);
                    if (failedExecsOnNode.isEmpty()) {
                        return this.nodeToExcludedExecs().remove((Object)status.node());
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if ((nodesToInclude = ((MapLike)this.nodeIdToExcludedExpiryTime().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HealthTracker.$anonfun$applyExcludeOnFailureTimeout$4(now, x$2)))).keys()).nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Removing nodes ").append(nodesToInclude).append(" from exclude list because the ").append("nodes have reached has timed out").toString());
                nodesToInclude.foreach((Function1 & Serializable & scala.Serializable)node -> {
                    HealthTracker.$anonfun$applyExcludeOnFailureTimeout$6(this, now, node);
                    return BoxedUnit.UNIT;
                });
                this._excludedNodeList().set((Set<String>)this.nodeIdToExcludedExpiryTime().keySet().toSet());
            }
            this.updateNextExpiryTime();
            return;
        }
    }

    private void updateNextExpiryTime() {
        long execMinExpiry = this.executorIdToExcludedStatus().nonEmpty() ? BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.executorIdToExcludedStatus().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)HealthTracker.$anonfun$updateNextExpiryTime$1(x$3)), Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long nodeMinExpiry = this.nodeIdToExcludedExpiryTime().nonEmpty() ? BoxesRunTime.unboxToLong((Object)this.nodeIdToExcludedExpiryTime().values().min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        this.nextExpiryTime_$eq(package$.MODULE$.min(execMinExpiry, nodeMinExpiry));
    }

    private void killExecutor(String exec, String msg) {
        String fullMsg = this.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED() ? new StringBuilder(27).append(msg).append(" (actually decommissioning)").toString() : msg;
        Option<ExecutorAllocationClient> option = this.allocationClient;
        if (option instanceof Some) {
            Some some = (Some)option;
            ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> fullMsg);
            if (this.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED()) {
                a.decommissionExecutor(exec, new ExecutorDecommissionInfo(fullMsg, ExecutorDecommissionInfo$.MODULE$.apply$default$2()), false, a.decommissionExecutor$default$4());
                return;
            }
            a.killExecutors((Seq<String>)((Seq)new .colon.colon((Object)exec, (List)Nil$.MODULE$)), false, false, true);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Not attempting to kill excluded executor id ").append(exec).append(" ").append("since allocation client is not defined.").toString());
            return;
        }
        throw new MatchError(option);
    }

    private void killExcludedExecutor(String exec) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED()))) {
            this.killExecutor(exec, new StringBuilder(44).append("Killing excluded executor id ").append(exec).append(" since ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED().key()).append(" is set.").toString());
            return;
        }
    }

    public void killExcludedIdleExecutor(String exec) {
        this.killExecutor(exec, new StringBuilder(105).append("Killing excluded idle executor id ").append(exec).append(" because of task unschedulability and trying ").append("to acquire a new executor.").toString());
    }

    private void killExecutorsOnExcludedNode(String node) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED()))) {
            Option<ExecutorAllocationClient> option = this.allocationClient;
            if (option instanceof Some) {
                Some some = (Some)option;
                ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
                if (this.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Decommissioning all executors on excluded host ").append(node).append(" ").append("since ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED().key()).append(" is set.").toString());
                    if (!a.decommissionExecutorsOnHost(node)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Decommissioning executors on ").append(node).append(" failed.").toString());
                        return;
                    }
                    return;
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Killing all executors on excluded host ").append(node).append(" ").append("since ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_KILL_ENABLED().key()).append(" is set.").toString());
                if (!a.killExecutorsOnHost(node)) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Killing executors on node ").append(node).append(" failed.").toString());
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Not attempting to kill executors on excluded host ").append(node).append(" ").append("since allocation client is not defined.").toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public void updateExcludedForFetchFailure(String host, String exec) {
        if (this.EXCLUDE_FETCH_FAILURE_ENABLED()) {
            long now = this.clock.getTimeMillis();
            long expiryTimeForNewExcludes = now + this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
            if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
                if (!this.nodeIdToExcludedExpiryTime().contains((Object)host)) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("excluding node ").append(host).append(" due to fetch failure of external shuffle service").toString());
                    this.nodeIdToExcludedExpiryTime().put((Object)host, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewExcludes));
                    this.listenerBus().post(new SparkListenerNodeBlacklisted(now, host, 1));
                    this.listenerBus().post(new SparkListenerNodeExcluded(now, host, 1));
                    this._excludedNodeList().set((Set<String>)this.nodeIdToExcludedExpiryTime().keySet().toSet());
                    this.killExecutorsOnExcludedNode(host);
                    this.updateNextExpiryTime();
                    return;
                }
                return;
            }
            if (!this.executorIdToExcludedStatus().contains((Object)exec)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Excluding executor ").append(exec).append(" due to fetch failure").toString());
                this.executorIdToExcludedStatus().put((Object)exec, (Object)new ExcludedExecutor(host, expiryTimeForNewExcludes));
                this.listenerBus().post(new SparkListenerExecutorBlacklisted(now, exec, 1));
                this.listenerBus().post(new SparkListenerExecutorExcluded(now, exec, 1));
                this.updateNextExpiryTime();
                this.killExcludedExecutor(exec);
                HashSet excludedExecsOnNode = (HashSet)this.nodeToExcludedExecs().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                excludedExecsOnNode.$plus$eq((Object)exec);
                return;
            }
            return;
        }
    }

    public void updateExcludedForSuccessfulTaskSet(int stageId, int stageAttemptId, HashMap<String, ExecutorFailuresInTaskSet> failuresByExec) {
        long now = this.clock.getTimeMillis();
        failuresByExec.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HealthTracker.$anonfun$updateExcludedForSuccessfulTaskSet$1(this, stageId, stageAttemptId, now, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isExecutorExcluded(String executorId) {
        return this.executorIdToExcludedStatus().contains((Object)executorId);
    }

    public Set<String> excludedNodeList() {
        return this._excludedNodeList().get();
    }

    public boolean isNodeExcluded(String node) {
        return this.nodeIdToExcludedExpiryTime().contains((Object)node);
    }

    public void handleRemovedExecutor(String executorId) {
        this.executorIdToFailureList().$minus$eq((Object)executorId);
    }

    public static final /* synthetic */ boolean $anonfun$applyExcludeOnFailureTimeout$1(long now$1, Tuple2 x$1) {
        return ((ExcludedExecutor)x$1._2()).expiryTime() < now$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyExcludeOnFailureTimeout$4(long now$1, Tuple2 x$2) {
        return x$2._2$mcJ$sp() < now$1;
    }

    public static final /* synthetic */ void $anonfun$applyExcludeOnFailureTimeout$6(HealthTracker $this, long now$1, String node) {
        $this.nodeIdToExcludedExpiryTime().remove((Object)node);
        $this.listenerBus().post(new SparkListenerNodeUnblacklisted(now$1, node));
        $this.listenerBus().post(new SparkListenerNodeUnexcluded(now$1, node));
    }

    public static final /* synthetic */ long $anonfun$updateNextExpiryTime$1(Tuple2 x$3) {
        return ((ExcludedExecutor)x$3._2()).expiryTime();
    }

    public static final /* synthetic */ void $anonfun$updateExcludedForSuccessfulTaskSet$1(HealthTracker $this, int stageId$1, int stageAttemptId$1, long now$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String exec = (String)tuple2._1();
            ExecutorFailuresInTaskSet failuresInTaskSet = (ExecutorFailuresInTaskSet)tuple2._2();
            ExecutorFailureList appFailuresOnExecutor = (ExecutorFailureList)$this.executorIdToFailureList().getOrElseUpdate((Object)exec, (Function0 & Serializable & scala.Serializable)() -> $this.new ExecutorFailureList());
            appFailuresOnExecutor.addFailures(stageId$1, stageAttemptId$1, failuresInTaskSet);
            appFailuresOnExecutor.dropFailuresWithTimeoutBefore(now$2);
            int newTotal = appFailuresOnExecutor.numUniqueTaskFailures();
            long expiryTimeForNewExcludes = now$2 + $this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
            if (newTotal >= $this.MAX_FAILURES_PER_EXEC() && !$this.executorIdToExcludedStatus().contains((Object)exec)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Excluding executor id: ").append(exec).append(" because it has ").append(newTotal).append(" task failures in successful task sets").toString());
                String node = failuresInTaskSet.node();
                $this.executorIdToExcludedStatus().put((Object)exec, (Object)new ExcludedExecutor(node, expiryTimeForNewExcludes));
                $this.listenerBus().post(new SparkListenerExecutorBlacklisted(now$2, exec, newTotal));
                $this.listenerBus().post(new SparkListenerExecutorExcluded(now$2, exec, newTotal));
                $this.executorIdToFailureList().remove((Object)exec);
                $this.updateNextExpiryTime();
                $this.killExcludedExecutor(exec);
                HashSet excludedExecsOnNode = (HashSet)$this.nodeToExcludedExecs().getOrElseUpdate((Object)node, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                excludedExecsOnNode.$plus$eq((Object)exec);
                if (excludedExecsOnNode.size() >= $this.MAX_FAILED_EXEC_PER_NODE() && !$this.nodeIdToExcludedExpiryTime().contains((Object)node)) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Excluding node ").append(node).append(" because it has ").append(excludedExecsOnNode.size()).append(" ").append("executors excluded: ").append(excludedExecsOnNode).toString());
                    $this.nodeIdToExcludedExpiryTime().put((Object)node, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewExcludes));
                    $this.listenerBus().post(new SparkListenerNodeBlacklisted(now$2, node, excludedExecsOnNode.size()));
                    $this.listenerBus().post(new SparkListenerNodeExcluded(now$2, node, excludedExecsOnNode.size()));
                    $this._excludedNodeList().set((Set<String>)$this.nodeIdToExcludedExpiryTime().keySet().toSet());
                    $this.killExecutorsOnExcludedNode(node);
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public HealthTracker(LiveListenerBus listenerBus, SparkConf conf, Option<ExecutorAllocationClient> allocationClient, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.allocationClient = allocationClient;
        this.clock = clock;
        Logging.$init$(this);
        HealthTracker$.MODULE$.validateExcludeOnFailureConfs(conf);
        this.MAX_FAILURES_PER_EXEC = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC()));
        this.MAX_FAILED_EXEC_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS = HealthTracker$.MODULE$.getExludeOnFailureTimeout(conf);
        this.EXCLUDE_FETCH_FAILURE_ENABLED = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_FETCH_FAILURE_ENABLED()));
        this.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_DECOMMISSION_ENABLED()));
        this.executorIdToFailureList = new HashMap();
        this.executorIdToExcludedStatus = new HashMap();
        this.nodeIdToExcludedExpiryTime = new HashMap();
        this._excludedNodeList = new AtomicReference<GenTraversable>(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        this.nextExpiryTime = Long.MAX_VALUE;
        this.nodeToExcludedExecs = new HashMap();
    }

    public HealthTracker(SparkContext sc, Option<ExecutorAllocationClient> allocationClient) {
        this(sc.listenerBus(), sc.conf(), allocationClient, HealthTracker$.MODULE$.$lessinit$greater$default$4());
    }

    public final class ExecutorFailureList
    implements Logging {
        private volatile HealthTracker$ExecutorFailureList$TaskId$ TaskId$module;
        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes;
        private long minExpiryTime;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public String logName() {
            return Logging.logName$(this);
        }

        @Override
        public Logger log() {
            return Logging.log$(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging.logInfo$(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging.logDebug$(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging.logTrace$(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging.logWarning$(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging.logError$(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$(this, isInterpreter);
        }

        @Override
        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
        }

        @Override
        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$(this);
        }

        @Override
        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$(this, isInterpreter, silent);
        }

        private HealthTracker$ExecutorFailureList$TaskId$ TaskId() {
            if (this.TaskId$module == null) {
                this.TaskId$lzycompute$1();
            }
            return this.TaskId$module;
        }

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes() {
            return this.failuresAndExpiryTimes;
        }

        private void failuresAndExpiryTimes_$eq(ArrayBuffer<Tuple2<TaskId, Object>> x$1) {
            this.failuresAndExpiryTimes = x$1;
        }

        private long minExpiryTime() {
            return this.minExpiryTime;
        }

        private void minExpiryTime_$eq(long x$1) {
            this.minExpiryTime = x$1;
        }

        public void addFailures(int stage, int stageAttempt, ExecutorFailuresInTaskSet failuresInTaskSet) {
            failuresInTaskSet.taskToFailureCountAndFailureTime().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorFailureList.$anonfun$addFailures$1(this, stage, stageAttempt, x0$1);
                return BoxedUnit.UNIT;
            });
        }

        public int numUniqueTaskFailures() {
            return this.failuresAndExpiryTimes().size();
        }

        public boolean isEmpty() {
            return this.failuresAndExpiryTimes().isEmpty();
        }

        public void dropFailuresWithTimeoutBefore(long dropBefore) {
            if (this.minExpiryTime() < dropBefore) {
                LongRef newMinExpiry = LongRef.create((long)Long.MAX_VALUE);
                ArrayBuffer newFailures = new ArrayBuffer();
                this.failuresAndExpiryTimes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ExecutorFailureList.$anonfun$dropFailuresWithTimeoutBefore$1(dropBefore, newFailures, newMinExpiry, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.failuresAndExpiryTimes_$eq((ArrayBuffer<Tuple2<TaskId, Object>>)newFailures);
                this.minExpiryTime_$eq(newMinExpiry.elem);
                return;
            }
        }

        public String toString() {
            return new StringBuilder(11).append("failures = ").append(this.failuresAndExpiryTimes()).toString();
        }

        private final void TaskId$lzycompute$1() {
            ExecutorFailureList executorFailureList = this;
            synchronized (executorFailureList) {
                if (this.TaskId$module == null) {
                    this.TaskId$module = new HealthTracker$ExecutorFailureList$TaskId$(this);
                }
            }
        }

        public static final /* synthetic */ void $anonfun$addFailures$1(ExecutorFailureList $this, int stage$1, int stageAttempt$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int taskIdx = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long failureTime = tuple22._2$mcJ$sp();
                    long expiryTime = failureTime + $this.HealthTracker.this.EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS();
                    $this.failuresAndExpiryTimes().$plus$eq((Object)new Tuple2((Object)new TaskId($this, stage$1, stageAttempt$1, taskIdx), (Object)BoxesRunTime.boxToLong((long)expiryTime)));
                    if (expiryTime < $this.minExpiryTime()) {
                        $this.minExpiryTime_$eq(expiryTime);
                        return;
                    }
                    return;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public static final /* synthetic */ void $anonfun$dropFailuresWithTimeoutBefore$1(long dropBefore$1, ArrayBuffer newFailures$1, LongRef newMinExpiry$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TaskId task = (TaskId)tuple2._1();
                long expiryTime = tuple2._2$mcJ$sp();
                if (expiryTime >= dropBefore$1) {
                    newFailures$1.$plus$eq((Object)new Tuple2((Object)task, (Object)BoxesRunTime.boxToLong((long)expiryTime)));
                    if (expiryTime < newMinExpiry$1.elem) {
                        newMinExpiry$1.elem = expiryTime;
                        return;
                    }
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public ExecutorFailureList() {
            if (HealthTracker.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.failuresAndExpiryTimes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.minExpiryTime = Long.MAX_VALUE;
        }

        private class TaskId
        implements Product,
        scala.Serializable {
            private final int stage;
            private final int stageAttempt;
            private final int taskIndex;
            public final /* synthetic */ ExecutorFailureList $outer;

            public int stage() {
                return this.stage;
            }

            public int stageAttempt() {
                return this.stageAttempt;
            }

            public int taskIndex() {
                return this.taskIndex;
            }

            public TaskId copy(int stage, int stageAttempt, int taskIndex) {
                return new TaskId(this.org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer(), stage, stageAttempt, taskIndex);
            }

            public int copy$default$1() {
                return this.stage();
            }

            public int copy$default$2() {
                return this.stageAttempt();
            }

            public int copy$default$3() {
                return this.taskIndex();
            }

            public String productPrefix() {
                return "TaskId";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.stage());
                    }
                    case 1: {
                        return BoxesRunTime.boxToInteger((int)this.stageAttempt());
                    }
                    case 2: {
                        return BoxesRunTime.boxToInteger((int)this.taskIndex());
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof TaskId;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.stage());
                n = Statics.mix((int)n, (int)this.stageAttempt());
                n = Statics.mix((int)n, (int)this.taskIndex());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof TaskId)) return false;
                if (((TaskId)object).org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer() != this.org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                TaskId taskId = (TaskId)x$1;
                if (this.stage() != taskId.stage()) return false;
                if (this.stageAttempt() != taskId.stageAttempt()) return false;
                if (this.taskIndex() != taskId.taskIndex()) return false;
                if (!taskId.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ExecutorFailureList org$apache$spark$scheduler$HealthTracker$ExecutorFailureList$TaskId$$$outer() {
                return this.$outer;
            }

            public TaskId(ExecutorFailureList $outer, int stage, int stageAttempt, int taskIndex) {
                this.stage = stage;
                this.stageAttempt = stageAttempt;
                this.taskIndex = taskIndex;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

