/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import java.io.File;
import org.apache.accumulo.core.util.Daemon;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MetricsConfiguration.class);
    private static final String metricsFileName = "accumulo-metrics.xml";
    private static boolean alreadyWarned = false;
    private boolean notFound = false;
    private int notFoundCount = 0;
    private static SystemConfiguration sysConfig = null;
    private static MapConfiguration envConfig = null;
    private XMLConfiguration xConfig = null;
    private Configuration config = null;
    private final Object lock = new Object();
    private volatile boolean needsReloading = false;
    private long lastCheckTime = 0L;
    private static long CONFIG_FILE_CHECK_INTERVAL = 600000L;
    private static int CONFIG_FILE_CHECK_COUNTER = 100;
    public static final long CONFIG_FILE_RELOAD_DELAY = 60000L;
    private MetricsConfigWatcher watcher = null;
    private boolean enabled = false;
    private String enabledName = null;

    public MetricsConfiguration(String name) {
        this.enabledName = name + ".enabled";
        this.getMetricsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getEnvironmentConfiguration() {
        Class<MetricsConfiguration> clazz = MetricsConfiguration.class;
        synchronized (MetricsConfiguration.class) {
            if (null == envConfig) {
                envConfig = new MapConfiguration(System.getenv());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return envConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getSystemConfiguration() {
        Class<MetricsConfiguration> clazz = MetricsConfiguration.class;
        synchronized (MetricsConfiguration.class) {
            if (null == sysConfig) {
                sysConfig = new SystemConfiguration();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sysConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getMetricsConfiguration() {
        if (this.notFound) {
            if (this.notFoundCount <= CONFIG_FILE_CHECK_COUNTER) {
                return null;
            }
            if (this.notFoundCount > CONFIG_FILE_CHECK_COUNTER && System.currentTimeMillis() - this.lastCheckTime > CONFIG_FILE_CHECK_INTERVAL) {
                this.notFoundCount = 0;
                this.lastCheckTime = System.currentTimeMillis();
                this.notFound = false;
            } else {
                ++this.notFoundCount;
            }
        }
        if (null == this.config || this.needsReloading) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needsReloading) {
                    this.loadConfiguration();
                } else if (null == this.config) {
                    this.loadConfiguration();
                }
                this.needsReloading = false;
            }
        }
        return this.config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfiguration() {
        String ACUHOME = this.getEnvironmentConfiguration().getString("ACCUMULO_CONF_DIR");
        if (null != ACUHOME) {
            File mFile = new File(ACUHOME, metricsFileName);
            if (mFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("Loading config file: " + mFile.getAbsolutePath());
                }
                try {
                    this.xConfig = new XMLConfiguration(mFile);
                    this.xConfig.append(this.getEnvironmentConfiguration());
                    this.xConfig.addConfigurationListener((ConfigurationListener)new MetricsConfigListener());
                    this.xConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
                    if (null == this.watcher || !this.watcher.isAlive()) {
                        this.watcher = new MetricsConfigWatcher();
                        this.watcher.start();
                    }
                    this.notFound = false;
                    alreadyWarned = false;
                }
                catch (ConfigurationException ce) {
                    log.error("Error reading accumulo-metrics.xml file.");
                    this.notFound = true;
                    return;
                }
            } else {
                if (!alreadyWarned) {
                    log.warn("Unable to find metrics file: " + mFile.getAbsolutePath());
                }
                alreadyWarned = true;
                this.notFound = true;
                return;
            }
        }
        if (!alreadyWarned) {
            log.warn("ACCUMULO_CONF_DIR variable not found in environment. Metrics collection will be disabled.");
        }
        alreadyWarned = true;
        this.notFound = true;
        return;
        if (this.xConfig != null) {
            this.config = this.xConfig.interpolatedConfiguration();
            this.enabled = this.config.getBoolean(this.enabledName);
            if (!log.isDebugEnabled()) return;
            log.debug("Metrics collection enabled=" + this.enabled);
            return;
        }
        this.enabled = false;
    }

    public boolean isEnabled() {
        if (null == this.getMetricsConfiguration()) {
            return false;
        }
        return this.enabled;
    }

    public static void main(String[] args) throws Exception {
        MetricsConfiguration mc = new MetricsConfiguration("master");
        while (true) {
            System.out.println("-----------------------------------------------------------------------");
            long t1 = System.currentTimeMillis();
            System.out.println(mc.isEnabled() + " took: " + (System.currentTimeMillis() - t1));
            Thread.sleep(1000L);
        }
    }

    private class MetricsConfigListener
    implements ConfigurationListener {
        private MetricsConfigListener() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            if (event.getType() == 20) {
                MetricsConfiguration.this.needsReloading = true;
            }
        }
    }

    private class MetricsConfigWatcher
    extends Daemon {
        public void run() {
            while (this.isAlive()) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MetricsConfiguration.this.xConfig.getBoolean("master.enabled");
            }
        }
    }
}

