/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;

class CustomFSHLog
extends FSHLog {
    private Boolean syncFlag;
    private Boolean writerSyncFlag;

    public CustomFSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        super(fs, root, logDir, conf);
    }

    protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
        final WALProvider.Writer writer = super.createWriterInstance(path);
        return new WALProvider.Writer(){

            public void close() throws IOException {
                writer.close();
            }

            public long getLength() {
                return writer.getLength();
            }

            public long getSyncedLength() {
                return writer.getSyncedLength();
            }

            public void sync(boolean forceSync) throws IOException {
                CustomFSHLog.this.writerSyncFlag = forceSync;
                writer.sync(forceSync);
            }

            public void append(WAL.Entry entry) throws IOException {
                writer.append(entry);
            }
        };
    }

    public void sync(boolean forceSync) throws IOException {
        this.syncFlag = forceSync;
        super.sync(forceSync);
    }

    public void sync(long txid, boolean forceSync) throws IOException {
        this.syncFlag = forceSync;
        super.sync(txid, forceSync);
    }

    void resetSyncFlag() {
        this.syncFlag = null;
        this.writerSyncFlag = null;
    }

    Boolean getSyncFlag() {
        return this.syncFlag;
    }

    Boolean getWriterSyncFlag() {
        return this.writerSyncFlag;
    }
}

