/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RowTooBigException;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRowTooBig {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowTooBig.class);
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private static Path rootRegionDir;
    private static final HTableDescriptor TEST_HTD;

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster();
        HTU.getConfiguration().setLong("hbase.table.max.rowsize", 0xA00000L);
        rootRegionDir = HTU.getDataTestDirOnTestFS("TestRowTooBig");
    }

    @AfterClass
    public static void after() throws Exception {
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RowTooBigException.class)
    public void testScannersSeekOnFewLargeCells() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        HTableDescriptor htd = TEST_HTD;
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1);
        if (htd.hasFamily(hcd.getName())) {
            htd.modifyFamily(hcd);
        } else {
            htd.addFamily(hcd);
        }
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, rootRegionDir, HTU.getConfiguration(), (TableDescriptor)htd);
        try {
            for (int i = 0; i < 5; ++i) {
                Put put = new Put(row1);
                byte[] value = new byte[0x500000];
                put.addColumn(fam1, Bytes.toBytes((String)("col_" + i)), value);
                region.put(put);
                region.flush(true);
            }
            Get get = new Get(row1);
            region.get(get);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RowTooBigException.class)
    public void testScanAcrossManySmallColumns() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"row1");
        HTableDescriptor htd = TEST_HTD;
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        HColumnDescriptor hcd = new HColumnDescriptor(fam1);
        if (htd.hasFamily(hcd.getName())) {
            htd.modifyFamily(hcd);
        } else {
            htd.addFamily(hcd);
        }
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, rootRegionDir, HTU.getConfiguration(), (TableDescriptor)htd);
        try {
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(row1);
                for (int j = 0; j < 100000; ++j) {
                    byte[] value = new byte[10];
                    put.addColumn(fam1, Bytes.toBytes((String)("col_" + i + "_" + j)), value);
                }
                region.put(put);
                region.flush(true);
            }
            region.compact(true);
            Get get = new Get(row1);
            region.get(get);
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    static {
        TEST_HTD = new HTableDescriptor(TableName.valueOf((String)TestRowTooBig.class.getSimpleName()));
    }
}

