/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRegionServerReportForDuty {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerReportForDuty.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerReportForDuty.class);
    private static final long SLEEP_INTERVAL = 500L;
    private HBaseTestingUtility testUtil;
    private LocalHBaseCluster cluster;
    private JVMClusterUtil.RegionServerThread rs;
    private JVMClusterUtil.RegionServerThread rs2;
    private JVMClusterUtil.MasterThread master;
    private JVMClusterUtil.MasterThread backupMaster;

    @Before
    public void setUp() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.testUtil.startMiniDFSCluster(1);
        this.testUtil.startMiniZKCluster(1, new int[0]);
        this.testUtil.createRootDir();
        this.cluster = new LocalHBaseCluster(this.testUtil.getConfiguration(), 0, 0);
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
        this.cluster.join();
        this.testUtil.shutdownMiniZKCluster();
        this.testUtil.shutdownMiniDFSCluster();
    }

    @Test
    public void testReportForDutyBackoff() throws IOException, InterruptedException {
        this.cluster.getConfiguration().set("hbase.master.impl", NeverInitializedMaster.class.getName());
        this.master = this.cluster.addMaster();
        this.master.start();
        LogCapturer capturer = new LogCapturer(org.apache.log4j.Logger.getLogger(HRegionServer.class));
        int msginterval = 100;
        this.cluster.getConfiguration().setInt("hbase.regionserver.msginterval", msginterval);
        this.rs = this.cluster.addRegionServer();
        this.rs.start();
        int interval = 10000;
        Thread.sleep(interval);
        capturer.stopCapturing();
        String output = capturer.getOutput();
        LOG.info("{}", (Object)output);
        String failMsg = "reportForDuty failed;";
        int count = StringUtils.countMatches((CharSequence)output, (CharSequence)failMsg);
        int expectedRetry = (int)Math.ceil(Math.log(interval - msginterval));
        Assert.assertTrue((String)String.format("reportForDuty retries %d times, less than expected min %d", count, expectedRetry / 2), (count > expectedRetry / 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)String.format("reportForDuty retries %d times, more than expected max %d", count, expectedRetry * 2), (count < expectedRetry * 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReportForDutyWithMasterChange() throws Exception {
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)this.testUtil.getConfiguration());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", tablesOnMaster ? 2 : 1);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", tablesOnMaster ? 2 : 1);
        this.master = this.cluster.addMaster();
        this.rs = this.cluster.addRegionServer();
        LOG.debug("Starting master: " + this.master.getMaster().getServerName());
        this.master.start();
        this.rs.start();
        this.waitForClusterOnline(this.master);
        this.cluster.getConfiguration().set("hbase.regionserver.impl", MyRegionServer.class.getName());
        this.rs2 = this.cluster.addRegionServer();
        LOG.debug("Starting 2nd region server: " + this.rs2.getRegionServer().getServerName());
        this.rs2.start();
        this.waitForSecondRsStarted();
        this.master.getMaster().stop("Stopping master");
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", tablesOnMaster ? 3 : 2);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", tablesOnMaster ? 3 : 2);
        this.backupMaster = this.cluster.addMaster();
        LOG.debug("Starting new master: " + this.backupMaster.getMaster().getServerName());
        this.backupMaster.start();
        this.waitForClusterOnline(this.backupMaster);
        Assert.assertTrue((boolean)this.backupMaster.getMaster().isActiveMaster());
        Assert.assertTrue((boolean)this.backupMaster.getMaster().isInitialized());
        Assert.assertEquals((long)this.backupMaster.getMaster().getServerManager().getOnlineServersList().size(), (long)(tablesOnMaster ? 3L : 2L));
    }

    @Test
    public void testReportForDutyWithRSRpcRetry() throws Exception {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("RSDelayedStart-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        this.cluster.getConfiguration().setLong("hbase.regionserver.rpc.retry.interval", 300L);
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)this.testUtil.getConfiguration());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", tablesOnMaster ? 2 : 1);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", tablesOnMaster ? 2 : 1);
        this.master = this.cluster.addMaster();
        this.rs = this.cluster.addRegionServer();
        LOG.debug("Starting master: " + this.master.getMaster().getServerName());
        this.master.start();
        scheduledThreadPoolExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                TestRegionServerReportForDuty.this.rs.start();
            }
        }, 1000L, TimeUnit.MILLISECONDS);
        this.waitForClusterOnline(this.master);
    }

    @Test
    public void testReportForDutyWithEnvironmentEdge() throws Exception {
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        this.cluster.getConfiguration().setInt("hbase.procedure.remote.dispatcher.delay.msec", 0);
        this.cluster.getConfiguration().setLong("hbase.regionserver.rpc.retry.interval", 0L);
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)this.testUtil.getConfiguration());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", tablesOnMaster ? 2 : 1);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", tablesOnMaster ? 2 : 1);
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        this.master = this.cluster.addMaster();
        this.rs = this.cluster.addRegionServer();
        LOG.debug("Starting master: " + this.master.getMaster().getServerName());
        this.master.start();
        this.rs.start();
        this.waitForClusterOnline(this.master);
    }

    private void waitForClusterOnline(JVMClusterUtil.MasterThread master) throws InterruptedException {
        while (!master.getMaster().isInitialized()) {
            Thread.sleep(500L);
            LOG.debug("Waiting for master to come online ...");
        }
        this.rs.waitForServerOnline();
    }

    private void waitForSecondRsStarted() throws InterruptedException {
        while (!((MyRegionServer)this.rs2.getRegionServer()).getRpcStubCreatedFlag()) {
            Thread.sleep(500L);
            LOG.debug("Waiting 2nd RS to be started ...");
        }
    }

    public static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        private ServerName sn;
        private boolean rpcStubCreatedFlag = false;
        private boolean masterChanged = false;

        public MyRegionServer(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        protected synchronized ServerName createRegionServerStatusStub(boolean refresh) {
            this.sn = super.createRegionServerStatusStub(refresh);
            this.rpcStubCreatedFlag = true;
            while (!this.masterChanged) {
                ServerName newSn = super.getMasterAddressTracker().getMasterAddress(true);
                if (newSn != null && !newSn.equals((Object)this.sn)) {
                    this.masterChanged = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return null;
                }
                LOG.debug("Waiting for master switch over ... ");
            }
            return this.sn;
        }

        public boolean getRpcStubCreatedFlag() {
            return this.rpcStubCreatedFlag;
        }
    }

    public static class NeverInitializedMaster
    extends HMaster {
        public NeverInitializedMaster(Configuration conf) throws IOException {
            super(conf);
        }

        protected void checkServiceStarted() throws ServerNotRunningYetException {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    static class LogCapturer {
        private StringWriter sw = new StringWriter();
        private WriterAppender appender;
        private org.apache.log4j.Logger logger;

        LogCapturer(org.apache.log4j.Logger logger) {
            this.logger = logger;
            Appender defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("stdout");
            if (defaultAppender == null) {
                defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("console");
            }
            PatternLayout layout = defaultAppender == null ? new PatternLayout() : defaultAppender.getLayout();
            this.appender = new WriterAppender((Layout)layout, (Writer)this.sw);
            this.logger.addAppender((Appender)this.appender);
        }

        String getOutput() {
            return this.sw.toString();
        }

        public void stopCapturing() {
            this.logger.removeAppender((Appender)this.appender);
        }
    }
}

