/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.DataBlockEncodingTool;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestDataBlockEncodingTool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDataBlockEncodingTool.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String ROOT_DIR = TEST_UTIL.getDataTestDir("TestDataBlockEncodingTool").toString();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static FileSystem fs;
    private static StoreFileWriter sfw;

    @Before
    public void setUp() throws IOException {
        fs = TEST_UTIL.getTestFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHFile(String fileName, boolean useTags, boolean allTags) throws IOException {
        Path path = new Path(ROOT_DIR, fileName);
        try {
            this.createHFileWithTags(path, useTags, allTags);
            TestDataBlockEncodingTool.testDataBlockingTool(path);
        }
        finally {
            if (fs.exists(path)) {
                fs.delete(path, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHFileWithTags(Path path, boolean useTags, boolean allTags) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(65536).withIncludesTags(useTags).build();
        sfw = new StoreFileWriter.Builder(conf, fs).withFilePath(path).withFileContext(meta).build();
        long now = System.currentTimeMillis();
        byte[] FAMILY = Bytes.toBytes((String)"cf");
        byte[] QUALIFIER = Bytes.toBytes((String)"q");
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    KeyValue kv;
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    if (useTags) {
                        Tag[] tags;
                        if (allTags) {
                            tags = new Tag[]{new ArrayBackedTag(0, Bytes.toString((byte[])b)), new ArrayBackedTag(0, Bytes.toString((byte[])b))};
                            kv = new KeyValue(b, FAMILY, QUALIFIER, now, b, tags);
                        } else if ((e - 97) % 2 == 0) {
                            kv = new KeyValue(b, FAMILY, QUALIFIER, now, b);
                        } else {
                            tags = new Tag[]{new ArrayBackedTag(0, Bytes.toString((byte[])b)), new ArrayBackedTag(0, Bytes.toString((byte[])b))};
                            kv = new KeyValue(b, FAMILY, QUALIFIER, now, b, tags);
                        }
                    } else {
                        kv = new KeyValue(b, FAMILY, QUALIFIER, now, b);
                    }
                    sfw.append((Cell)kv);
                }
            }
            sfw.appendMetadata(0L, false);
        }
        finally {
            sfw.close();
        }
    }

    private static void testDataBlockingTool(Path path) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        int maxKV = Integer.MAX_VALUE;
        boolean doVerify = true;
        boolean doBenchmark = true;
        String testHFilePath = path.toString();
        DataBlockEncodingTool.testCodecs(conf, maxKV, testHFilePath, Compression.Algorithm.GZ.getName(), doBenchmark, doVerify);
    }

    @Test
    public void testHFileAllCellsWithTags() throws IOException {
        this.testHFile("1234567890", true, true);
    }

    @Test
    public void testHFileAllCellsWithoutTags() throws IOException {
        this.testHFile("1234567089", false, false);
    }

    @Test
    public void testHFileHalfCellsWithTags() throws IOException {
        this.testHFile("1234560789", true, false);
    }
}

