/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionOnTwoFileSystems {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterRegionOnTwoFileSystems.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionOnTwoFileSystems.class);
    private static final HBaseCommonTestingUtility HFILE_UTIL = new HBaseCommonTestingUtility();
    private static final HBaseTestingUtility WAL_UTIL = new HBaseTestingUtility();
    private static byte[] CF = Bytes.toBytes((String)"f");
    private static byte[] CQ = Bytes.toBytes((String)"q");
    private static TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test:local")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build();
    private static int COMPACT_MIN = 4;
    private MasterRegion region;

    @BeforeClass
    public static void setUp() throws Exception {
        WAL_UTIL.startMiniDFSCluster(3);
        Configuration conf = HFILE_UTIL.getConfiguration();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        Path rootDir = HFILE_UTIL.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)rootDir);
        Path walRootDir = WAL_UTIL.getDataTestDirOnTestFS();
        FileSystem walFs = WAL_UTIL.getTestFileSystem();
        CommonFSUtils.setWALRootDir((Configuration)conf, (Path)walRootDir.makeQualified(walFs.getUri(), walFs.getWorkingDirectory()));
    }

    @AfterClass
    public static void tearDown() throws IOException {
        WAL_UTIL.shutdownMiniDFSCluster();
        WAL_UTIL.cleanupTestDir();
        HFILE_UTIL.cleanupTestDir();
    }

    private MasterRegion createMasterRegion(ServerName serverName) throws IOException {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)HFILE_UTIL.getConfiguration());
        Mockito.when((Object)server.getServerName()).thenReturn((Object)serverName);
        MasterRegionParams params = new MasterRegionParams();
        params.server(server).regionDirName("local").tableDescriptor(TD).flushSize(0x8000000L).flushPerChanges(1000000L).flushIntervalMs(TimeUnit.MINUTES.toMillis(15L)).compactMin(COMPACT_MIN).maxWals(32).useHsync(false).ringBufferSlotCount(16).rollPeriodMs(TimeUnit.MINUTES.toMillis(15L)).archivedWalSuffix("$masterlocalwal$").archivedHFileSuffix("$-masterlocalhfile-$");
        return MasterRegion.create((MasterRegionParams)params);
    }

    @Before
    public void setUpBeforeTest() throws IOException {
        Path rootDir = HFILE_UTIL.getDataTestDir();
        FileSystem fs = rootDir.getFileSystem(HFILE_UTIL.getConfiguration());
        fs.delete(rootDir, true);
        Path walRootDir = WAL_UTIL.getDataTestDirOnTestFS();
        FileSystem walFs = WAL_UTIL.getTestFileSystem();
        walFs.delete(walRootDir, true);
        this.region = this.createMasterRegion(ServerName.valueOf((String)"localhost", (int)12345, (long)System.currentTimeMillis()));
    }

    @After
    public void tearDownAfterTest() {
        this.region.close(true);
    }

    private int getStorefilesCount() {
        return ((HStore)Iterables.getOnlyElement((Iterable)this.region.region.getStores())).getStorefilesCount();
    }

    @Test
    public void testFlushAndCompact() throws Exception {
        int compactMinMinusOne = COMPACT_MIN - 1;
        int i = 0;
        while (i < compactMinMinusOne) {
            int index = i++;
            this.region.update(r -> r.put(new Put(Bytes.toBytes((int)index)).addColumn(CF, CQ, Bytes.toBytes((int)index))));
            this.region.flush(true);
        }
        byte[] bytes = Bytes.toBytes((int)compactMinMinusOne);
        this.region.update(r -> r.put(new Put(bytes).addColumn(CF, CQ, bytes)));
        this.region.flusherAndCompactor.requestFlush();
        HFILE_UTIL.waitFor(15000L, () -> this.getStorefilesCount() == 1);
        Path storeArchiveDir = HFileArchiveUtil.getStoreArchivePathForRootDir((Path)HFILE_UTIL.getDataTestDir(), (RegionInfo)this.region.region.getRegionInfo(), (byte[])CF);
        FileSystem rootFs = storeArchiveDir.getFileSystem(HFILE_UTIL.getConfiguration());
        HFILE_UTIL.waitFor(15000L, () -> {
            try {
                FileStatus[] fses = rootFs.listStatus(storeArchiveDir);
                return fses != null && fses.length == COMPACT_MIN;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        });
        LOG.info("hfile archive content {}", (Object)Arrays.stream(rootFs.listStatus(storeArchiveDir)).map(f -> f.getPath().toString()).collect(Collectors.joining(",")));
        Path walArchiveDir = new Path(CommonFSUtils.getWALRootDir((Configuration)HFILE_UTIL.getConfiguration()), "oldWALs");
        LOG.info("wal archive dir {}", (Object)walArchiveDir);
        AbstractFSWAL wal = (AbstractFSWAL)this.region.region.getWAL();
        Path currentWALFile = wal.getCurrentFileName();
        int i2 = 0;
        while (true) {
            this.region.requestRollAll();
            this.region.waitUntilWalRollFinished();
            Path newWALFile = wal.getCurrentFileName();
            if (!newWALFile.equals((Object)currentWALFile)) break;
            if (i2 == 10) {
                Assert.fail((String)("Can not roll wal after " + i2 + " times"));
            }
            Thread.sleep(1000L);
            ++i2;
        }
        HFILE_UTIL.waitFor(15000L, () -> {
            try {
                FileStatus[] fses = WAL_UTIL.getTestFileSystem().listStatus(walArchiveDir);
                if (fses != null && fses.length > 0) {
                    LOG.info("wal archive dir content {}", (Object)Arrays.stream(fses).map(f -> f.getPath().toString()).collect(Collectors.joining(",")));
                } else {
                    LOG.info("none found");
                }
                return fses != null && fses.length >= 1;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        });
    }

    @Test
    public void testRecovery() throws IOException {
        int countPerRound = 100;
        for (int round = 0; round < 5; ++round) {
            for (int i = 0; i < countPerRound; ++i) {
                int row = round * countPerRound + i;
                Put put = new Put(Bytes.toBytes((int)row)).addColumn(CF, CQ, Bytes.toBytes((int)row));
                this.region.update(r -> r.put(put));
            }
            this.region.close(true);
            this.region = this.createMasterRegion(ServerName.valueOf((String)"localhost", (int)12345, (long)(System.currentTimeMillis() + (long)round + 1L)));
            try (RegionScanner scanner = this.region.getScanner(new Scan());){
                ArrayList cells = new ArrayList();
                boolean moreValues = true;
                for (int i = 0; i < (round + 1) * countPerRound; ++i) {
                    Assert.assertTrue((boolean)moreValues);
                    moreValues = scanner.next(cells);
                    Assert.assertEquals((long)1L, (long)cells.size());
                    Result result = Result.create(cells);
                    cells.clear();
                    Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
                    Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(CF, CQ)));
                }
                Assert.assertFalse((boolean)moreValues);
                continue;
            }
        }
    }
}

