/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRoundRobinAssignmentOnRestart
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRoundRobinAssignmentOnRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRoundRobinAssignmentOnRestart.class);
    private final int regionNum = 10;
    private final int rsNum = 2;

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    @Test
    public void test() throws Exception {
        this.UTIL.startMiniCluster(2);
        this.UTIL.getMiniHBaseCluster().getMaster().getMasterRpcServices().synchronousBalanceSwitch(false);
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createMultiRegionTable(TABLE, FAMILY, 10);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)2L, (long)threads.size());
        ServerName testServer = threads.get(0).getRegionServer().getServerName();
        int port = testServer.getPort();
        List regionInfos = cluster.getMaster().getAssignmentManager().getRegionsOnServer(testServer);
        LOG.debug("RegionServer {} has {} regions", (Object)testServer, (Object)regionInfos.size());
        Assert.assertTrue((regionInfos.size() >= TABLES.length * 10 / 2 ? 1 : 0) != 0);
        cluster.stopRegionServer(testServer);
        cluster.waitForRegionServerToStop(testServer, 60000L);
        cluster.getConf().setInt("hbase.regionserver.port", port);
        cluster.startRegionServer();
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        List localServers = master.getServerManager().getOnlineServersList();
        ServerName newTestServer = null;
        for (ServerName serverName : localServers) {
            if (!serverName.getAddress().equals((Object)testServer.getAddress())) continue;
            newTestServer = serverName;
            break;
        }
        Assert.assertNotNull(newTestServer);
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableAvailable(TABLE);
        }
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        List newRegionInfos = cluster.getMaster().getAssignmentManager().getRegionsOnServer(newTestServer);
        LOG.debug("RegionServer {} has {} regions", (Object)newTestServer, (Object)newRegionInfos.size());
        Assert.assertTrue((String)"Should not retain all regions when restart", (newRegionInfos.size() < regionInfos.size() ? 1 : 0) != 0);
    }
}

