/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={FilterTests.class, MediumTests.class})
public class TestSeekHints {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static String cf = "f";
    private static String cq = "q";
    private static String table = "t";
    private static Table ht;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.caching", 1000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setLong("hbase.hregion.max.filesize", 0x280000000L);
        TEST_UTIL.startMiniCluster();
        ht = TEST_UTIL.createTable(TableName.valueOf((String)table), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (byte b = 0; b < 20; b = (byte)((byte)(b + 1))) {
            Put put = new Put(new byte[]{b}).addColumn(Bytes.toBytes((String)cf), Bytes.toBytes((String)cq), Bytes.toBytes((String)"value"));
            ht.put(put);
        }
        TEST_UTIL.flush();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNormalScanForwardsSeek() throws IOException {
        byte i;
        KeepAllButSeekFilter filter = new KeepAllButSeekFilter(10, 15);
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<byte[]> actualRowsList = new ArrayList<byte[]>();
        for (Result result : scanner) {
            actualRowsList.add(result.getRow());
        }
        byte[][] actualRows = (byte[][])actualRowsList.toArray((T[])new byte[0][]);
        ArrayList<byte[]> expectedRowsList = new ArrayList<byte[]>();
        for (i = 0; i < 10; i = (byte)((byte)(i + 1))) {
            expectedRowsList.add(new byte[]{i});
        }
        for (i = 15; i < 20; i = (byte)((byte)(i + 1))) {
            expectedRowsList.add(new byte[]{i});
        }
        byte[][] expectedRows = (byte[][])expectedRowsList.toArray((T[])new byte[0][]);
        Assert.assertArrayEquals((Object[])expectedRows, (Object[])actualRows);
    }

    @Test
    public void testReversedScanBackwardsSeek() throws IOException {
        byte i;
        KeepAllButSeekFilter filter = new KeepAllButSeekFilter(10, 5);
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        scan.setReversed(true);
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<byte[]> actualRowsList = new ArrayList<byte[]>();
        for (Result result : scanner) {
            actualRowsList.add(result.getRow());
        }
        byte[][] actualRows = (byte[][])actualRowsList.toArray((T[])new byte[0][]);
        ArrayList<byte[]> expectedRowsList = new ArrayList<byte[]>();
        for (i = 19; i > 10; i = (byte)((byte)(i - 1))) {
            expectedRowsList.add(new byte[]{i});
        }
        for (i = 5; i >= 0; i = (byte)((byte)(i - 1))) {
            expectedRowsList.add(new byte[]{i});
        }
        byte[][] expectedRows = (byte[][])expectedRowsList.toArray((T[])new byte[0][]);
        Assert.assertArrayEquals((Object[])expectedRows, (Object[])actualRows);
    }

    static {
        CLASS_RULE = HBaseClassTestRule.forClass(TestSeekHints.class);
    }

    public static class KeepAllButSeekFilter
    extends FilterBase {
        private byte seekStartRow;
        private byte seekTargetRow;

        public KeepAllButSeekFilter(byte seekStartRow, byte seekTargetRow) {
            this.seekStartRow = seekStartRow;
            this.seekTargetRow = seekTargetRow;
        }

        public Filter.ReturnCode filterCell(Cell c) throws IOException {
            byte rowKeyPrefix = CellUtil.cloneRow((Cell)c)[0];
            if (rowKeyPrefix == this.seekStartRow) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            return Filter.ReturnCode.INCLUDE;
        }

        public Cell getNextCellHint(Cell currentCell) {
            return PrivateCellUtil.createFirstOnRow((byte[])new byte[]{this.seekTargetRow});
        }

        public byte[] toByteArray() {
            return new byte[]{this.seekStartRow, this.seekTargetRow};
        }

        public static KeepAllButSeekFilter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new KeepAllButSeekFilter(pbBytes[0], pbBytes[1]);
        }
    }
}

