/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.AlgebraicMathBase;
import org.apache.pig.builtin.BigDecimalWrapper;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class AlgebraicBigDecimalMathBase
extends AlgebraicMathBase<BigDecimal>
implements Accumulator<BigDecimal> {
    private BigDecimal intermediateVal = null;

    protected static BigDecimal getSeed(AlgebraicMathBase.KNOWN_OP op) {
        switch (op) {
            case SUM: {
                return BigDecimal.ZERO;
            }
            case MAX: {
                return BigDecimalWrapper.NEGATIVE_INFINITY();
            }
            case MIN: {
                return BigDecimalWrapper.POSITIVE_INFINITY();
            }
        }
        return null;
    }

    private static BigDecimal doWork(BigDecimal arg1, BigDecimal arg2, AlgebraicMathBase.KNOWN_OP op) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        BigDecimal retVal = null;
        switch (op) {
            case SUM: {
                retVal = arg1.add(arg2);
                break;
            }
            case MAX: {
                if (BigDecimalWrapper.class.isInstance(arg1) && ((BigDecimalWrapper)arg1).isNegativeInfinity()) {
                    retVal = arg2;
                    break;
                }
                if (BigDecimalWrapper.class.isInstance(arg2) && ((BigDecimalWrapper)arg2).isNegativeInfinity()) {
                    retVal = arg1;
                    break;
                }
                retVal = arg1.max(arg2);
                break;
            }
            case MIN: {
                if (BigDecimalWrapper.class.isInstance(arg1) && ((BigDecimalWrapper)arg1).isPositiveInfinity()) {
                    retVal = arg2;
                    break;
                }
                if (BigDecimalWrapper.class.isInstance(arg2) && ((BigDecimalWrapper)arg2).isPositiveInfinity()) {
                    retVal = arg1;
                    break;
                }
                retVal = arg1.min(arg2);
                break;
            }
            default: {
                retVal = null;
            }
        }
        return retVal;
    }

    protected static BigDecimal doTupleWork(Tuple input, AlgebraicMathBase.KnownOpProvider opProvider) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values == null || values.size() == 0L) {
            return null;
        }
        BigDecimal sofar = AlgebraicBigDecimalMathBase.getSeed(opProvider.getOp());
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Number n = (Number)t.get(0);
                if (n == null) continue;
                BigDecimal d = (BigDecimal)n;
                sawNonNull = true;
                sofar = AlgebraicBigDecimalMathBase.doWork(sofar, d, opProvider.getOp());
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                throw new ExecException("Problem doing work on BigDecimal", errCode, 4, exp);
            }
        }
        return sawNonNull ? sofar : null;
    }

    @Override
    public BigDecimal exec(Tuple input) throws IOException {
        try {
            return AlgebraicBigDecimalMathBase.doTupleWork(input, this.opProvider);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on BigDecimal", errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 70));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            BigDecimal curVal = AlgebraicBigDecimalMathBase.doTupleWork(b, this.opProvider);
            if (curVal == null) {
                return;
            }
            if (this.intermediateVal == null) {
                this.intermediateVal = AlgebraicBigDecimalMathBase.getSeed(this.opProvider.getOp());
            }
            this.intermediateVal = AlgebraicBigDecimalMathBase.doWork(this.intermediateVal, curVal, this.opProvider.getOp());
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            throw new ExecException("Error executing function on BigDecimal", errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateVal = null;
    }

    @Override
    public BigDecimal getValue() {
        return this.intermediateVal;
    }

    public static abstract class Final
    extends AlgebraicMathBase.Final<BigDecimal> {
        @Override
        public BigDecimal exec(Tuple input) throws IOException {
            try {
                return AlgebraicBigDecimalMathBase.doTupleWork(input, this);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on BigDecimal", errCode, 4, e);
            }
        }
    }

    public static abstract class Intermediate
    extends AlgebraicMathBase.Intermediate {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(AlgebraicBigDecimalMathBase.doTupleWork(input, this));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing function on BigDecimal", errCode, 4, e);
            }
        }
    }
}

