/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.rdd.RDD;

public class CounterConverter
implements RDDConverter<Tuple, Tuple, POCounter> {
    private static final Log LOG = LogFactory.getLog(CounterConverter.class);

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POCounter poCounter) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, poCounter, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        CounterConverterFunction f = new CounterConverterFunction(poCounter);
        JavaRDD jRdd = rdd.toJavaRDD().mapPartitionsWithIndex((Function2)f, true);
        return jRdd.rdd();
    }

    private static class CounterConverterFunction
    implements Function2<Integer, Iterator<Tuple>, Iterator<Tuple>>,
    Serializable {
        private final POCounter poCounter;
        private long localCount = 1L;
        private long sparkCount = 0L;

        private CounterConverterFunction(POCounter poCounter) {
            this.poCounter = poCounter;
        }

        public Iterator<Tuple> call(Integer index, Iterator<Tuple> input) {
            Tuple inp = null;
            Tuple output = null;
            long sizeBag = 0L;
            ArrayList<Tuple> listOutput = new ArrayList<Tuple>();
            try {
                while (input.hasNext()) {
                    inp = input.next();
                    output = TupleFactory.getInstance().newTuple(inp.getAll().size() + 3);
                    for (int i = 0; i < inp.getAll().size(); ++i) {
                        output.set(i + 3, inp.get(i));
                    }
                    if (this.poCounter.isRowNumber() || this.poCounter.isDenseRank()) {
                        output.set(2, this.getLocalCounter());
                        this.incrementSparkCounter();
                        this.incrementLocalCounter();
                    } else if (!this.poCounter.isDenseRank()) {
                        int positionBag = inp.getAll().size() - 1;
                        if (inp.getType(positionBag) == 120) {
                            sizeBag = ((DefaultAbstractBag)inp.get(positionBag)).size();
                        }
                        output.set(2, this.getLocalCounter());
                        this.addToSparkCounter(sizeBag);
                        this.addToLocalCounter(sizeBag);
                    }
                    output.set(0, index);
                    output.set(1, this.getSparkCounter());
                    listOutput.add(output);
                }
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
            return listOutput.iterator();
        }

        private long getLocalCounter() {
            return this.localCount;
        }

        private long incrementLocalCounter() {
            return this.localCount++;
        }

        private long addToLocalCounter(long amount) {
            return this.localCount += amount;
        }

        private long getSparkCounter() {
            return this.sparkCount;
        }

        private long incrementSparkCounter() {
            return this.sparkCount++;
        }

        private long addToSparkCounter(long amount) {
            return this.sparkCount += amount;
        }
    }
}

