/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.StoreFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.tools.pigstats.PigWarnCounter;

public final class PigHadoopLogger
implements PigLogger {
    private static Log log = LogFactory.getLog(PigHadoopLogger.class);
    private static PigHadoopLogger logger = null;
    private PigWarnCounter reporter = null;
    private boolean aggregate = false;

    private PigHadoopLogger() {
    }

    public static PigHadoopLogger getInstance() {
        if (logger == null) {
            logger = new PigHadoopLogger();
        }
        return logger;
    }

    public void setReporter(PigWarnCounter reporter) {
        this.reporter = reporter;
    }

    public void warn(Object o, String msg, Enum warningEnum) {
        String className = o.getClass().getName();
        String displayMessage = className + "(" + warningEnum + "): " + msg;
        if (this.getAggregate()) {
            if (this.reporter != null) {
                if (o instanceof EvalFunc || o instanceof LoadFunc || o instanceof StoreFunc) {
                    this.reporter.incrWarnCounter(className, warningEnum.name(), 1L);
                }
                this.reporter.incrWarnCounter(warningEnum, 1L);
            } else {
                log.warn((Object)displayMessage);
            }
        } else {
            log.warn((Object)displayMessage);
        }
    }

    public synchronized boolean getAggregate() {
        return this.aggregate;
    }

    public synchronized void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }
}

