/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHAMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestHAMetrics.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHAMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            Assert.assertEquals((Object)nn0.getHAState(), (Object)"standby");
            Assert.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((Object)nn1.getHAState(), (Object)"standby");
            Assert.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToActive(0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeStatus");
            Long ltt1 = (Long)mbs.getAttribute(mxbeanName, "LastHATransitionTime");
            Assert.assertTrue((String)"lastHATransitionTime should be > 0", (ltt1 > 0L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"active", (Object)nn0.getHAState());
            Assert.assertEquals((long)0L, (long)nn0.getMillisSinceLastLoadedEdits());
            Assert.assertEquals((Object)"standby", (Object)nn1.getHAState());
            Assert.assertTrue((0L < nn1.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            cluster.transitionToStandby(0);
            Long ltt2 = (Long)mbs.getAttribute(mxbeanName, "LastHATransitionTime");
            Assert.assertTrue((String)("lastHATransitionTime should be > " + ltt1), (ltt2 > ltt1 ? 1 : 0) != 0);
            cluster.transitionToActive(1);
            Assert.assertEquals((Object)"standby", (Object)nn0.getHAState());
            Assert.assertTrue((0L < nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"active", (Object)nn1.getHAState());
            Assert.assertEquals((long)0L, (long)nn1.getMillisSinceLastLoadedEdits());
            Thread.sleep(2000L);
            Assert.assertTrue((2000L <= nn0.getMillisSinceLastLoadedEdits() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)nn0.getPendingDataNodeMessageCount());
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/foo"), 10L, (short)1, 1L);
            Assert.assertTrue((0 < nn0.getPendingDataNodeMessageCount() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            long millisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(1), cluster.getNameNode(0));
            Assert.assertEquals((long)0L, (long)nn0.getPendingDataNodeMessageCount());
            Assert.assertEquals((long)0L, (long)nn1.getPendingDataNodeMessageCount());
            long newMillisSinceLastLoadedEdits = nn0.getMillisSinceLastLoadedEdits();
            Assert.assertTrue((String)("expected " + millisSinceLastLoadedEdits + " > " + newMillisSinceLastLoadedEdits), (millisSinceLastLoadedEdits > newMillisSinceLastLoadedEdits ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHAInodeCount() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", Integer.MAX_VALUE);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount1"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount2"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount3"), 10L, (short)1, 1L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testHAInodeCount4"), 10L, (short)1, 1L);
            Assert.assertEquals((long)5L, (long)nn0.getFilesTotal());
            Assert.assertEquals((long)1L, (long)nn1.getFilesTotal());
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            cluster.restartNameNode(0);
            Assert.assertEquals((Object)nn0.getHAState(), (Object)"standby");
            nn0 = cluster.getNamesystem(0);
            Assert.assertEquals((long)5L, (long)nn0.getFilesTotal());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fs});
        cluster.shutdown();
    }
}

