/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.avro.AvroStorageSchemaConversionUtilities;
import org.joda.time.DateTime;

public class AvroStorageDataConversionUtilities {
    public static GenericData.Record packIntoAvro(Tuple t, Schema s) throws IOException {
        try {
            GenericData.Record record = new GenericData.Record(s);
            for (Schema.Field f : s.getFields()) {
                Object o = t.get(f.pos());
                Schema innerSchema = f.schema();
                record.put(f.pos(), AvroStorageDataConversionUtilities.packIntoAvro(o, innerSchema));
            }
            return record;
        }
        catch (Exception e) {
            throw new IOException("exception in AvroStorageDataConversionUtilities.packIntoAvro", e);
        }
    }

    public static GenericData.Array<Object> packIntoAvro(DataBag db, Schema s) throws IOException {
        try {
            GenericData.Array array = new GenericData.Array(new Long(db.size()).intValue(), s);
            for (Tuple t : db) {
                if (s.getElementType() != null && s.getElementType().getType() == Schema.Type.RECORD) {
                    array.add((Object)AvroStorageDataConversionUtilities.packIntoAvro(t, s.getElementType()));
                    continue;
                }
                if (t.size() == 1) {
                    array.add(t.get(0));
                    continue;
                }
                throw new IOException("AvroStorageDataConversionUtilities.packIntoAvro: Can't pack " + t + " into schema " + s);
            }
            return array;
        }
        catch (Exception e) {
            throw new IOException("exception in AvroStorageDataConversionUtilities.packIntoAvro", e);
        }
    }

    private static Object packIntoAvro(Object o, Schema s) throws IOException {
        if (AvroStorageSchemaConversionUtilities.isNullableUnion(s)) {
            if (o == null) {
                return null;
            }
            s = AvroStorageSchemaConversionUtilities.removeSimpleUnion(s);
        }
        switch (s.getType()) {
            case RECORD: {
                return AvroStorageDataConversionUtilities.packIntoAvro((Tuple)o, s);
            }
            case ARRAY: {
                return AvroStorageDataConversionUtilities.packIntoAvro((DataBag)o, s);
            }
            case MAP: {
                return AvroStorageDataConversionUtilities.packIntoAvro((Map)o, s);
            }
            case BYTES: {
                return ByteBuffer.wrap(((DataByteArray)o).get());
            }
            case FIXED: {
                return new GenericData.Fixed(s, ((DataByteArray)o).get());
            }
            case ENUM: {
                return new GenericData.EnumSymbol(s, o.toString());
            }
        }
        if (DataType.findType(o) == 30) {
            return ((DateTime)o).getMillis();
        }
        return o;
    }

    private static Map<Utf8, Object> packIntoAvro(Map<CharSequence, Object> input, Schema schema) throws IOException {
        HashMap<Utf8, Object> output = new HashMap<Utf8, Object>();
        for (Map.Entry<CharSequence, Object> e : input.entrySet()) {
            Utf8 k = AvroStorageDataConversionUtilities.utf8(e.getKey());
            output.put(k, AvroStorageDataConversionUtilities.packIntoAvro(e.getValue(), schema.getValueType()));
        }
        return output;
    }

    private static Utf8 utf8(CharSequence v) {
        if (v instanceof Utf8) {
            return (Utf8)v;
        }
        StringBuilder sb = new StringBuilder(v.length());
        sb.append(v);
        return new Utf8(sb.toString());
    }
}

