/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;

@InterfaceAudience.Private
public class POIdentityInOutTez
extends POLocalRearrangeTez
implements TezInput,
TezOutput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POIdentityInOutTez.class);
    private String inputKey;
    private transient KeyValueReader reader;
    private transient KeyValuesReader shuffleReader;
    private transient boolean shuffleInput;
    private transient boolean finished = false;
    private transient boolean hasNext = false;

    public POIdentityInOutTez(OperatorKey k, POLocalRearrange inputRearrange, String inputKey) {
        super(inputRearrange);
        this.mKey = k;
        this.inputKey = inputKey;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            Reader r = input.getReader();
            if (r instanceof KeyValueReader) {
                this.reader = (KeyValueReader)r;
                this.hasNext = this.reader.next();
            } else {
                this.shuffleInput = true;
                this.shuffleReader = (KeyValuesReader)r;
                this.hasNext = this.shuffleReader.next();
            }
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + r));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        LogicalOutput output = outputs.get(this.outputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.outputKey + " is missing");
        }
        try {
            this.writer = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.outputKey + " : output=" + output + ", writer=" + this.writer));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            if (this.shuffleInput) {
                while (this.hasNext) {
                    Object curKey = this.shuffleReader.getCurrentKey();
                    Iterable vals = this.shuffleReader.getCurrentValues();
                    if (this.isSkewedJoin) {
                        NullablePartitionWritable wrappedKey = new NullablePartitionWritable((PigNullableWritable)curKey);
                        wrappedKey.setPartition(-1);
                        curKey = wrappedKey;
                    }
                    for (Object val : vals) {
                        this.writer.write(curKey, val);
                    }
                    this.hasNext = this.shuffleReader.next();
                }
            } else {
                while (this.hasNext) {
                    if (this.isSkewedJoin) {
                        NullablePartitionWritable wrappedKey = new NullablePartitionWritable((PigNullableWritable)this.reader.getCurrentKey());
                        wrappedKey.setPartition(-1);
                        this.writer.write((Object)wrappedKey, this.reader.getCurrentValue());
                    } else {
                        this.writer.write(this.reader.getCurrentKey(), this.reader.getCurrentValue());
                    }
                    this.hasNext = this.reader.next();
                }
            }
            this.finished = true;
            return RESULT_EOP;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    @Override
    public String name() {
        return "POIdentityInOutTez - " + this.mKey.toString() + "\t<-\t " + this.inputKey + "\t->\t " + this.outputKey;
    }
}

