/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.bloom.BloomFilter;

public class BloomPackager
extends Packager {
    private static final long serialVersionUID = 1L;
    private static final Result RESULT_EMPTY = new Result(1, null);
    private static final Result RESULT_EOP = new Result(3, null);
    private boolean bloomCreatedInMap;
    private int vectorSizeBytes;
    private int numBloomFilters;
    private int numHash;
    private int hashType;
    private transient ByteArrayOutputStream baos;
    private transient BloomFilter[] bloomFilters;
    private transient int nextFilterIdx;

    public BloomPackager(boolean bloomCreatedInMap, int numBloomFilters, int vectorSizeBytes, int numHash, int hashType) {
        this.bloomCreatedInMap = bloomCreatedInMap;
        this.vectorSizeBytes = vectorSizeBytes;
        this.numHash = numHash;
        this.hashType = hashType;
        this.numBloomFilters = numBloomFilters;
    }

    @Override
    public void attachInput(Object key, DataBag[] bags, boolean[] readOnce) throws ExecException {
        this.key = key;
        this.bags = bags;
        this.readOnce = readOnce;
    }

    @Override
    public Result getNext() throws ExecException {
        try {
            if (this.bags == null) {
                return new Result(3, null);
            }
            if (this.bloomCreatedInMap) {
                return this.combineBloomFilters();
            }
            if (this.parent.isEndOfAllInput()) {
                return this.retrieveBloomFilter();
            }
            if (!this.bags[0].iterator().hasNext()) {
                return new Result(3, null);
            }
            if (this.bloomFilters == null) {
                this.bloomFilters = new BloomFilter[this.numBloomFilters];
            }
            Tuple tup = this.bags[0].iterator().next();
            this.addKeyToBloomFilter(this.key, (Integer)tup.get(0));
            this.detachInput();
            return RESULT_EMPTY;
        }
        catch (IOException e) {
            throw new ExecException("Error while constructing final bloom filter", e);
        }
    }

    private Result combineBloomFilters() throws IOException {
        Iterator<Tuple> iter = this.bags[0].iterator();
        Tuple tup = iter.next();
        DataByteArray bloomBytes = (DataByteArray)tup.get(0);
        BloomFilter bloomFilter = BloomFilter.bloomIn(bloomBytes);
        while (iter.hasNext()) {
            tup = iter.next();
            bloomFilter.or(BloomFilter.bloomIn((DataByteArray)tup.get(0)));
        }
        Object partition = this.key;
        this.detachInput();
        return this.getSerializedBloomFilter(partition, bloomFilter, bloomBytes.get().length);
    }

    private Result getSerializedBloomFilter(Object partition, BloomFilter bloomFilter, int serializedSize) throws ExecException, IOException {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream(serializedSize);
        }
        this.baos.reset();
        DataOutputStream dos = new DataOutputStream(this.baos);
        bloomFilter.write(dos);
        dos.flush();
        Tuple res = mTupleFactory.newTuple(2);
        res.set(0, partition);
        res.set(1, new DataByteArray(this.baos.toByteArray()));
        Result r = new Result();
        r.result = res;
        r.returnStatus = 0;
        return r;
    }

    private void addKeyToBloomFilter(Object key, int partition) throws ExecException {
        Key k = new Key(((DataByteArray)key).get());
        BloomFilter filter = this.bloomFilters[partition];
        if (filter == null) {
            this.bloomFilters[partition] = filter = new BloomFilter(this.vectorSizeBytes * 8, this.numHash, this.hashType);
        }
        filter.add(k);
    }

    private Result retrieveBloomFilter() throws IOException {
        while (this.nextFilterIdx < this.numBloomFilters) {
            if (this.bloomFilters[this.nextFilterIdx] != null) {
                return this.getSerializedBloomFilter(this.nextFilterIdx, this.bloomFilters[this.nextFilterIdx++], this.vectorSizeBytes + 64);
            }
            ++this.nextFilterIdx;
        }
        return RESULT_EOP;
    }

    public boolean isBloomCreatedInMap() {
        return this.bloomCreatedInMap;
    }
}

