/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.io.PrintStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.XMLPhysicalPlanPrinter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSparkPrinter
extends SparkOpPlanVisitor {
    private PrintStream mStream = null;
    private Document doc = null;
    private Element root = null;

    public XMLSparkPrinter(PrintStream ps, SparkOperPlan plan) throws ParserConfigurationException {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
        this.mStream = ps;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.root = this.doc.createElement("sparkPlan");
        this.doc.appendChild(this.root);
    }

    public void closePlan() throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(this.doc);
        transformer.transform(source, result);
        this.mStream.println(sw.toString());
    }

    @Override
    public void visitSparkOp(SparkOperator so) throws VisitorException {
        Element sparkNode = this.doc.createElement("sparkNode");
        sparkNode.setAttribute("scope", "" + so.getOperatorKey().id);
        if (so instanceof NativeSparkOperator) {
            Element nativeSparkOper = this.doc.createElement("nativeSpark");
            nativeSparkOper.setTextContent(((NativeSparkOperator)so).getCommandString());
            sparkNode.appendChild(nativeSparkOper);
            this.root.appendChild(sparkNode);
            return;
        }
        if (so.physicalPlan != null && so.physicalPlan.size() > 0) {
            XMLPhysicalPlanPrinter printer = new XMLPhysicalPlanPrinter(so.physicalPlan, this.doc, sparkNode);
            printer.visit();
        }
        this.root.appendChild(sparkNode);
    }
}

