/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.LitePackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

public class SparkPOPackageAnnotator
extends SparkOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(SparkPOPackageAnnotator.class);

    public SparkPOPackageAnnotator(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        if (!sparkOp.physicalPlan.isEmpty()) {
            PackageDiscoverer pkgDiscoverer = new PackageDiscoverer(sparkOp.physicalPlan);
            pkgDiscoverer.visit();
        }
    }

    static class PackageDiscoverer
    extends PhyPlanVisitor {
        private POPackage pkg;
        private PhysicalPlan plan;

        public PackageDiscoverer(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.plan = plan;
        }

        @Override
        public void visitPackage(POPackage pkg) throws VisitorException {
            this.pkg = pkg;
            PhysicalOperator graOp = this.plan.getPredecessors(pkg).get(0);
            if (!(graOp instanceof POGlobalRearrange)) {
                throw new OptimizerException("Package operator is not preceded by GlobalRearrange operator in Spark Plan", 2087, 4);
            }
            List<PhysicalOperator> lraOps = this.plan.getPredecessors(graOp);
            if (pkg.getNumInps() != lraOps.size()) {
                throw new OptimizerException("Unexpected problem during optimization. Could not find all LocalRearrange operators. Expected " + pkg.getNumInps() + ". Got " + lraOps.size() + ".", 2086, 4);
            }
            Collections.sort(lraOps);
            for (PhysicalOperator op : lraOps) {
                if (!(op instanceof POLocalRearrange)) {
                    throw new OptimizerException("GlobalRearrange operator can only be preceded by LocalRearrange operator(s) in Spark Plan", 2087, 4);
                }
                this.annotatePkgWithLRA((POLocalRearrange)op);
            }
        }

        private void annotatePkgWithLRA(POLocalRearrange lrearrange) throws VisitorException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Annotating package " + this.pkg + " with localrearrange operator " + lrearrange + " with index " + lrearrange.getIndex()));
            }
            if (this.pkg.getPkgr() instanceof LitePackager && lrearrange.getIndex() != 0) {
                throw new VisitorException("POLocalRearrange for POPackageLite cannot have index other than 0, but has index - " + lrearrange.getIndex());
            }
            Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = this.pkg.getPkgr().getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>();
            }
            if (keyInfo.get(lrearrange.getIndex()) != null) {
                int errCode = 2087;
                String msg = "Unexpected problem during optimization. Found index:" + lrearrange.getIndex() + " in multiple LocalRearrange operators.";
                throw new OptimizerException(msg, errCode, 4);
            }
            keyInfo.put(Integer.valueOf(lrearrange.getIndex()), new Pair<Boolean, Map<Integer, Integer>>(lrearrange.isProjectStar(), lrearrange.getProjectedColsMap()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("KeyInfo for packager for package operator " + this.pkg + " is " + keyInfo));
            }
            this.pkg.getPkgr().setKeyInfo(keyInfo);
            this.pkg.getPkgr().setKeyTuple(lrearrange.isKeyTuple());
            this.pkg.getPkgr().setKeyCompound(lrearrange.isKeyCompound());
        }
    }
}

