/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigException;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.tools.pigstats.PigStats;

public abstract class Launcher {
    private static final Log log = LogFactory.getLog(Launcher.class);
    private static final String OOM_ERR = "OutOfMemoryError";
    private boolean pigException = false;
    private boolean outOfMemory = false;
    private String newLine = "\n";
    protected String jobControlExceptionStackTrace = null;
    protected Exception jobControlException = null;
    protected long totalHadoopTimeSpent;
    protected Map<FileSpec, Exception> failureMap;
    protected JobControl jc = null;

    protected Launcher() {
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            this.newLine = "\r\n";
        }
        this.reset();
    }

    public void reset() {
        this.failureMap = Maps.newHashMap();
        this.totalHadoopTimeSpent = 0L;
    }

    public abstract PigStats launchPig(PhysicalPlan var1, String var2, PigContext var3) throws Exception;

    public abstract void explain(PhysicalPlan var1, PigContext var2, PrintStream var3, String var4, boolean var5) throws PlanException, VisitorException, IOException;

    public abstract void kill() throws BackendException;

    public abstract void killJob(String var1, Configuration var2) throws BackendException;

    protected boolean isComplete(double prog) {
        return (int)Math.ceil(prog) == 1;
    }

    protected long computeTimeSpent(Iterator<TaskReport> taskReports) {
        long timeSpent = 0L;
        while (taskReports.hasNext()) {
            TaskReport r = taskReports.next();
            timeSpent += r.getFinishTime() - r.getStartTime();
        }
        return timeSpent;
    }

    protected void getErrorMessages(Iterator<TaskReport> reports, String type, boolean errNotDbg, PigContext pigContext) throws Exception {
        while (reports.hasNext()) {
            TaskReport report = reports.next();
            String[] msgs = report.getDiagnostics();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            String exceptionCreateFailMsg = null;
            boolean jobFailed = false;
            if (msgs.length > 0) {
                if (report.getCurrentStatus() == TIPStatus.FAILED) {
                    jobFailed = true;
                }
                HashSet<String> errorMessageSet = new HashSet<String>();
                for (int j = 0; j < msgs.length; ++j) {
                    if (errorMessageSet.contains(msgs[j])) continue;
                    errorMessageSet.add(msgs[j]);
                    if (errNotDbg) {
                        try {
                            LogUtils.writeLog("Backend error message", msgs[j], pigContext.getProperties().getProperty("pig.logfile"), log);
                            Exception e = this.getExceptionFromString(msgs[j]);
                            exceptions.add(e);
                        }
                        catch (Exception e1) {
                            exceptionCreateFailMsg = msgs[j];
                        }
                        continue;
                    }
                    log.debug((Object)("Error message from task (" + type + ") " + report.getTaskID() + msgs[j]));
                }
            }
            if (jobFailed && exceptions.size() == 0 && exceptionCreateFailMsg != null) {
                int errCode = 2997;
                String msg = "Unable to recreate exception from backed error: " + exceptionCreateFailMsg;
                throw new ExecException(msg, errCode, 4);
            }
            if (!jobFailed) continue;
            if (exceptions.size() > 1) {
                for (int j = 0; j < exceptions.size(); ++j) {
                    String headerMessage = "Error message from task (" + type + ") " + report.getTaskID();
                    LogUtils.writeLog((Throwable)exceptions.get(j), pigContext.getProperties().getProperty("pig.logfile"), log, false, headerMessage, false, false);
                }
                throw (Exception)exceptions.get(0);
            }
            if (exceptions.size() == 1) {
                throw (Exception)exceptions.get(0);
            }
            int errCode = 2115;
            String msg = "Internal error. Expected to throw exception from the backend. Did not find any exception to throw.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    protected double calculateProgress(JobControl jc) throws IOException {
        double prog = 0.0;
        prog += (double)jc.getSuccessfulJobs().size();
        ArrayList runnJobs = jc.getRunningJobs();
        for (org.apache.hadoop.mapred.jobcontrol.Job j : runnJobs) {
            prog += Launcher.progressOfRunningJob(j);
        }
        return prog;
    }

    private static double progressOfRunningJob(org.apache.hadoop.mapred.jobcontrol.Job j) throws IOException {
        Job mrJob = j.getJob();
        try {
            return (mrJob.mapProgress() + mrJob.reduceProgress()) / 2.0f;
        }
        catch (Exception ir) {
            return 0.0;
        }
    }

    public long getTotalHadoopTimeSpent() {
        return this.totalHadoopTimeSpent;
    }

    protected void setJobException(Throwable throwable) {
        this.jobControlExceptionStackTrace = Utils.getStackStraceStr(throwable);
        try {
            this.jobControlException = this.getExceptionFromString(this.jobControlExceptionStackTrace);
        }
        catch (Exception e) {
            String errMsg = "Could not resolve error that occurred when launching job: " + this.jobControlExceptionStackTrace;
            this.jobControlException = new RuntimeException(errMsg, throwable);
        }
    }

    public Exception getExceptionFromString(String stackTrace) throws Exception {
        String[] lines = stackTrace.split(this.newLine);
        Throwable t = this.getExceptionFromStrings(lines, 0);
        if (!this.pigException) {
            int errCode = 6015;
            String msg = "During execution, encountered a Hadoop error.";
            ExecException ee = new ExecException(msg, errCode, 16, t);
            ee.setStackTrace(t.getStackTrace());
            return ee;
        }
        this.pigException = false;
        if (this.outOfMemory) {
            this.outOfMemory = false;
            int errCode = 6016;
            String msg = "Out of memory.";
            ExecException ee = new ExecException(msg, errCode, 16, t);
            ee.setStackTrace(t.getStackTrace());
            return ee;
        }
        return (Exception)t;
    }

    private Throwable getExceptionFromStrings(String[] stackTraceLines, int startingLineNum) throws Exception {
        if (stackTraceLines.length > 0 && startingLineNum < stackTraceLines.length - 1) {
            String exceptionNameDelimiter = "(\\w+(\\$\\w+)?\\.)+\\w+";
            Pattern exceptionNamePattern = Pattern.compile(exceptionNameDelimiter);
            Matcher exceptionNameMatcher = exceptionNamePattern.matcher(stackTraceLines[startingLineNum]);
            String exceptionName = null;
            String exceptionMessage = null;
            if (exceptionNameMatcher.find()) {
                exceptionName = exceptionNameMatcher.group();
                if (exceptionName.contains(OOM_ERR)) {
                    this.outOfMemory = true;
                }
                if (stackTraceLines[startingLineNum].length() > exceptionNameMatcher.end()) {
                    exceptionMessage = stackTraceLines[startingLineNum].substring(exceptionNameMatcher.end() + 2);
                }
                ++startingLineNum;
            }
            if (exceptionName != null) {
                int lineNum;
                ArrayList stackTraceElements = Lists.newArrayList();
                String stackElementRegex = "\\s+at\\s+(\\w+(\\$\\w+)?\\.)+(\\<)?\\w+(\\>)?";
                Pattern stackElementPattern = Pattern.compile(stackElementRegex);
                String pigExceptionRegex = "org\\.apache\\.pig\\.";
                Pattern pigExceptionPattern = Pattern.compile(pigExceptionRegex);
                String moreElementRegex = "\\s+\\.\\.\\.\\s+\\d+\\s+more";
                Pattern moreElementPattern = Pattern.compile(moreElementRegex);
                for (lineNum = startingLineNum; lineNum < stackTraceLines.length - 1; ++lineNum) {
                    Matcher stackElementMatcher = stackElementPattern.matcher(stackTraceLines[lineNum]);
                    if (stackElementMatcher.find()) {
                        StackTraceElement ste = this.getStackTraceElement(stackTraceLines[lineNum]);
                        stackTraceElements.add(ste);
                        String className = ste.getClassName();
                        Matcher pigExceptionMatcher = pigExceptionPattern.matcher(className);
                        if (!pigExceptionMatcher.find()) continue;
                        this.pigException = true;
                        continue;
                    }
                    Matcher moreElementMatcher = moreElementPattern.matcher(stackTraceLines[lineNum]);
                    if (!moreElementMatcher.find()) break;
                    ++lineNum;
                    break;
                }
                startingLineNum = lineNum;
                Object object = PigContext.instantiateFuncFromSpec(exceptionName);
                if (object instanceof PigException) {
                    String errMessageRegex = "ERROR\\s+\\d+:";
                    Pattern errMessagePattern = Pattern.compile(errMessageRegex);
                    Matcher errMessageMatcher = errMessagePattern.matcher(exceptionMessage);
                    if (errMessageMatcher.find()) {
                        String errMessageStub = errMessageMatcher.group();
                        exceptionMessage = exceptionMessage.substring(errMessageMatcher.end() + 1);
                        String errCodeRegex = "\\d+";
                        Pattern errCodePattern = Pattern.compile(errCodeRegex);
                        Matcher errCodeMatcher = errCodePattern.matcher(errMessageStub);
                        String code = null;
                        if (errCodeMatcher.find()) {
                            code = errCodeMatcher.group();
                        }
                        int errCode = code != null ? Integer.parseInt(code) : 2998;
                        FuncSpec funcSpec = new FuncSpec(exceptionName, exceptionMessage);
                        object = PigContext.instantiateFuncFromSpec(funcSpec);
                        ((PigException)object).setErrorCode(errCode);
                        ((PigException)object).setErrorSource(PigException.determineErrorSource(errCode));
                    } else {
                        FuncSpec funcSpec = new FuncSpec(exceptionName, exceptionMessage);
                        object = PigContext.instantiateFuncFromSpec(funcSpec);
                        ((PigException)object).setErrorCode(2997);
                        ((PigException)object).setErrorSource((byte)4);
                    }
                } else {
                    object = PigContext.instantiateFuncFromSpec(new FuncSpec(exceptionName, exceptionMessage));
                }
                StackTraceElement[] steArr = new StackTraceElement[stackTraceElements.size()];
                ((Throwable)object).setStackTrace(stackTraceElements.toArray(steArr));
                if (startingLineNum < stackTraceLines.length - 1) {
                    Throwable e = this.getExceptionFromStrings(stackTraceLines, startingLineNum);
                    ((Throwable)object).initCause(e);
                }
                return (Throwable)object;
            }
            int errCode = 2055;
            String msg = "Did not find exception name to create exception from string: " + Arrays.toString(stackTraceLines);
            throw new ExecException(msg, errCode, 4);
        }
        int errCode = 2056;
        String msg = "Cannot create exception from empty string.";
        throw new ExecException(msg, errCode, 4);
    }

    public StackTraceElement getStackTraceElement(String line) throws Exception {
        String qualifiedMethodNameRegex = "(\\w+(\\$\\w+)?\\.)+(<)?\\w+(>)?";
        Pattern qualifiedMethodNamePattern = Pattern.compile(qualifiedMethodNameRegex);
        Matcher contentMatcher = qualifiedMethodNamePattern.matcher(line);
        String content = null;
        if (!contentMatcher.find()) {
            int errCode = 2057;
            String msg = "Did not find fully qualified method name to reconstruct stack trace: " + line;
            throw new ExecException(msg, errCode, 4);
        }
        content = line.substring(contentMatcher.start());
        Matcher qualifiedMethodNameMatcher = qualifiedMethodNamePattern.matcher(content);
        String qualifiedMethodName = null;
        String fileDetails = null;
        if (!qualifiedMethodNameMatcher.find()) {
            int errCode = 2057;
            String msg = "Did not find fully qualified method name to reconstruct stack trace: " + line;
            throw new ExecException(msg, errCode, 4);
        }
        qualifiedMethodName = qualifiedMethodNameMatcher.group();
        fileDetails = content.substring(qualifiedMethodNameMatcher.end() + 1);
        String[] items = qualifiedMethodName.split("\\.");
        String declaringClass = items[0];
        String methodName = items[items.length - 1];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < items.length - 1; ++i) {
            sb.append('.');
            sb.append(items[i]);
        }
        declaringClass = declaringClass + sb.toString();
        fileDetails = fileDetails.substring(0, fileDetails.length() - 1);
        items = fileDetails.split(":");
        String fileName = null;
        int lineNumber = -1;
        if (items.length > 0) {
            fileName = items[0];
            if (items.length > 1) {
                lineNumber = Integer.parseInt(items[1]);
            }
        }
        return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    public void destroy() {
    }

    protected void addGCParams(Properties properties, String key, boolean skipIfEmpty) {
        String value = properties.getProperty(key);
        if (value == null) {
            if (skipIfEmpty) {
                return;
            }
            value = properties.getProperty("pig.gc.default.params", "-XX:+UseParallelGC");
            properties.setProperty(key, value);
        } else if (!value.matches("-XX:\\+Use[a-zA-Z0-9_]+GC")) {
            value = value + " " + properties.getProperty("pig.gc.default.params", "-XX:+UseParallelGC");
            properties.setProperty(key, value);
        }
    }

    public class JobControlThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            Launcher.this.setJobException(throwable);
        }
    }

    protected class HangingJobKiller
    extends Thread {
        @Override
        public void run() {
            try {
                Launcher.this.kill();
            }
            catch (Exception e) {
                log.warn((Object)("Error in killing Execution Engine: " + e));
            }
        }
    }
}

