/****************************************************************************
 * arch/xtensa/src/esp32s3/hardware/esp32s3_sensitive.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_XTENSA_SRC_ESP32S3_HARDWARE_ESP32S3_SENSITIVE_H
#define __ARCH_XTENSA_SRC_ESP32S3_HARDWARE_ESP32S3_SENSITIVE_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "esp32s3_soc.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* SENSITIVE_CACHE_DATAARRAY_CONNECT_0_REG register
 * Cache data array configuration register 0.
 */

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_0_REG (DR_REG_SENSITIVE_BASE + 0x0)

/* SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock cache data array registers.
 */

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK    (BIT(0))
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_M  (SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_V << SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_S)
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_V  0x00000001
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_LOCK_S  0

/* SENSITIVE_CACHE_DATAARRAY_CONNECT_1_REG register
 * Cache data array configuration register 1.
 */

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_1_REG (DR_REG_SENSITIVE_BASE + 0x4)

/* SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN : R/W; bitpos: [7:0]; default:
 * 255;
 * Cache data array connection configuration.
 */

#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN    0x000000ff
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_M  (SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_V << SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_S)
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_V  0x000000ff
#define SENSITIVE_CACHE_DATAARRAY_CONNECT_FLATTEN_S  0

/* SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG register
 * APB peripheral configuration register 0.
 */

#define SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x8)

/* SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock APB peripheral Configuration Register.
 */

#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_M  (SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V << SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S)
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V  0x00000001
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S  0

/* SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG register
 * APB peripheral configuration register 1.
 */

#define SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0xc)

/* SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST : R/W; bitpos: [0]; default:
 * 1;
 * Set 1 to support split function for AHB access to APB peripherals.
 */

#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_M  (SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V << SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S)
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V  0x00000001
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S  0

/* SENSITIVE_INTERNAL_SRAM_USAGE_0_REG register
 * Internal SRAM configuration register 0.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_0_REG (DR_REG_SENSITIVE_BASE + 0x10)

/* SENSITIVE_INTERNAL_SRAM_USAGE_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock internal SRAM Configuration Register.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK    (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_M  (SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V << SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V  0x00000001
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S  0

/* SENSITIVE_INTERNAL_SRAM_USAGE_1_REG register
 * Internal SRAM configuration register 1.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_1_REG (DR_REG_SENSITIVE_BASE + 0x14)

/* SENSITIVE_INTERNAL_SRAM_CPU_USAGE : R/W; bitpos: [10:4]; default: 127;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by cpu.
 */

#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE    0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_M  (SENSITIVE_INTERNAL_SRAM_CPU_USAGE_V << SENSITIVE_INTERNAL_SRAM_CPU_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_V  0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CPU_USAGE_S  4

/* SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE : R/W; bitpos: [3:2]; default: 3;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by dcache.
 */

#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE    0x00000003
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_M  (SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_V << SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_V  0x00000003
#define SENSITIVE_INTERNAL_SRAM_DCACHE_USAGE_S  2

/* SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE : R/W; bitpos: [1:0]; default: 3;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by icache.
 */

#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE    0x00000003
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_M  (SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_V << SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_V  0x00000003
#define SENSITIVE_INTERNAL_SRAM_ICACHE_USAGE_S  0

/* SENSITIVE_INTERNAL_SRAM_USAGE_2_REG register
 * Internal SRAM configuration register 2.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_2_REG (DR_REG_SENSITIVE_BASE + 0x18)

/* SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC : R/W; bitpos: [17:16];
 * default: 0;
 * Which internal SRAM bank (16KB) of 64KB can be accessed by core1 trace
 * bus.
 */

#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC    0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_M  (SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_V << SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_S)
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_V  0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_ALLOC_S  16

/* SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC : R/W; bitpos: [15:14];
 * default: 0;
 * Which internal SRAM bank (16KB) of 64KB can be accessed by core0 trace
 * bus.
 */

#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC    0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_M  (SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_V << SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_S)
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_V  0x00000003
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_ALLOC_S  14

/* SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE : R/W; bitpos: [13:7]; default:
 * 0;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by core1 trace bus.
 */

#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE    0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_M  (SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_V << SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_V  0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CORE1_TRACE_USAGE_S  7

/* SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE : R/W; bitpos: [6:0]; default:
 * 0;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by core0 trace bus.
 */

#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE    0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_M  (SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_V << SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_V  0x0000007f
#define SENSITIVE_INTERNAL_SRAM_CORE0_TRACE_USAGE_S  0

/* SENSITIVE_INTERNAL_SRAM_USAGE_3_REG register
 * Internal SRAM configuration register 3.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_3_REG (DR_REG_SENSITIVE_BASE + 0x1c)

/* SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE : R/W; bitpos: [3:0]; default: 0;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by mac dump.
 */

#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE    0x0000000f
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_M  (SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_V << SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_V  0x0000000f
#define SENSITIVE_INTERNAL_SRAM_MAC_DUMP_USAGE_S  0

/* SENSITIVE_INTERNAL_SRAM_USAGE_4_REG register
 * Internal SRAM configuration register 4.
 */

#define SENSITIVE_INTERNAL_SRAM_USAGE_4_REG (DR_REG_SENSITIVE_BASE + 0x20)

/* SENSITIVE_INTERNAL_SRAM_LOG_USAGE : R/W; bitpos: [6:0]; default: 0;
 * Set 1 to someone bit means corresponding internal SRAM level can be
 * accessed by log bus.
 */

#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE    0x0000007f
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_M  (SENSITIVE_INTERNAL_SRAM_LOG_USAGE_V << SENSITIVE_INTERNAL_SRAM_LOG_USAGE_S)
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_V  0x0000007f
#define SENSITIVE_INTERNAL_SRAM_LOG_USAGE_S  0

/* SENSITIVE_RETENTION_DISABLE_REG register
 * Retention configuration register.
 */

#define SENSITIVE_RETENTION_DISABLE_REG (DR_REG_SENSITIVE_BASE + 0x24)

/* SENSITIVE_RETENTION_DISABLE : R/W; bitpos: [0]; default: 0;
 * Set 1 to disable retention function and lock disable state.
 */

#define SENSITIVE_RETENTION_DISABLE    (BIT(0))
#define SENSITIVE_RETENTION_DISABLE_M  (SENSITIVE_RETENTION_DISABLE_V << SENSITIVE_RETENTION_DISABLE_S)
#define SENSITIVE_RETENTION_DISABLE_V  0x00000001
#define SENSITIVE_RETENTION_DISABLE_S  0

/* SENSITIVE_CACHE_TAG_ACCESS_0_REG register
 * Cache tag configuration register 0.
 */

#define SENSITIVE_CACHE_TAG_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x28)

/* SENSITIVE_CACHE_TAG_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock cache tag Configuration Register.
 */

#define SENSITIVE_CACHE_TAG_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_M  (SENSITIVE_CACHE_TAG_ACCESS_LOCK_V << SENSITIVE_CACHE_TAG_ACCESS_LOCK_S)
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_V  0x00000001
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_S  0

/* SENSITIVE_CACHE_TAG_ACCESS_1_REG register
 * Cache tag configuration register 1.
 */

#define SENSITIVE_CACHE_TAG_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0x2c)

/* SENSITIVE_PRO_D_TAG_WR_ACS : R/W; bitpos: [3]; default: 1;
 * Set 1 to enable Dcache write access tag memory.
 */

#define SENSITIVE_PRO_D_TAG_WR_ACS    (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_M  (SENSITIVE_PRO_D_TAG_WR_ACS_V << SENSITIVE_PRO_D_TAG_WR_ACS_S)
#define SENSITIVE_PRO_D_TAG_WR_ACS_V  0x00000001
#define SENSITIVE_PRO_D_TAG_WR_ACS_S  3

/* SENSITIVE_PRO_D_TAG_RD_ACS : R/W; bitpos: [2]; default: 1;
 * Set 1 to enable Dcache read access tag memory.
 */

#define SENSITIVE_PRO_D_TAG_RD_ACS    (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_M  (SENSITIVE_PRO_D_TAG_RD_ACS_V << SENSITIVE_PRO_D_TAG_RD_ACS_S)
#define SENSITIVE_PRO_D_TAG_RD_ACS_V  0x00000001
#define SENSITIVE_PRO_D_TAG_RD_ACS_S  2

/* SENSITIVE_PRO_I_TAG_WR_ACS : R/W; bitpos: [1]; default: 1;
 * Set 1 to enable Icache write access tag memory.
 */

#define SENSITIVE_PRO_I_TAG_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_M  (SENSITIVE_PRO_I_TAG_WR_ACS_V << SENSITIVE_PRO_I_TAG_WR_ACS_S)
#define SENSITIVE_PRO_I_TAG_WR_ACS_V  0x00000001
#define SENSITIVE_PRO_I_TAG_WR_ACS_S  1

/* SENSITIVE_PRO_I_TAG_RD_ACS : R/W; bitpos: [0]; default: 1;
 * Set 1 to enable Icache read access tag memory.
 */

#define SENSITIVE_PRO_I_TAG_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_M  (SENSITIVE_PRO_I_TAG_RD_ACS_V << SENSITIVE_PRO_I_TAG_RD_ACS_S)
#define SENSITIVE_PRO_I_TAG_RD_ACS_V  0x00000001
#define SENSITIVE_PRO_I_TAG_RD_ACS_S  0

/* SENSITIVE_CACHE_MMU_ACCESS_0_REG register
 * Cache MMU configuration register 0.
 */

#define SENSITIVE_CACHE_MMU_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x30)

/* SENSITIVE_CACHE_MMU_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock cache MMU registers.
 */

#define SENSITIVE_CACHE_MMU_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_M  (SENSITIVE_CACHE_MMU_ACCESS_LOCK_V << SENSITIVE_CACHE_MMU_ACCESS_LOCK_S)
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_V  0x00000001
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_S  0

/* SENSITIVE_CACHE_MMU_ACCESS_1_REG register
 * Cache MMU configuration register 1.
 */

#define SENSITIVE_CACHE_MMU_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0x34)

/* SENSITIVE_PRO_MMU_WR_ACS : R/W; bitpos: [1]; default: 1;
 * Set 1 to enable write access MMU memory.
 */

#define SENSITIVE_PRO_MMU_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_M  (SENSITIVE_PRO_MMU_WR_ACS_V << SENSITIVE_PRO_MMU_WR_ACS_S)
#define SENSITIVE_PRO_MMU_WR_ACS_V  0x00000001
#define SENSITIVE_PRO_MMU_WR_ACS_S  1

/* SENSITIVE_PRO_MMU_RD_ACS : R/W; bitpos: [0]; default: 1;
 * Set 1 to enable read access MMU memory.
 */

#define SENSITIVE_PRO_MMU_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_M  (SENSITIVE_PRO_MMU_RD_ACS_V << SENSITIVE_PRO_MMU_RD_ACS_S)
#define SENSITIVE_PRO_MMU_RD_ACS_V  0x00000001
#define SENSITIVE_PRO_MMU_RD_ACS_S  0

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG register
 * spi2 dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x38)

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock spi2 dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG register
 * spi2 dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x3c)

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * spi2's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * spi2's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * spi2's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * spi2's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * spi2's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * spi2's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_0_REG register
 * spi3 dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x40)

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock spi3 dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_1_REG register
 * spi3 dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x44)

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * spi3's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * spi3's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * spi3's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * spi3's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * spi3's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * spi3's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI3_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_0_REG register
 * uhci0 dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x48)

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock uhci0 dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_1_REG register
 * uhci0 dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x4c)

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [11:10]; default: 3;
 * uhci0's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [9:8]; default: 3;
 * uhci0's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * uhci0's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * uhci0's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * uhci0's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * uhci0's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_UHCI0_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG register
 * i2s0 dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x50)

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock i2s0 dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG register
 * i2s0 dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x54)

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * i2s0's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * i2s0's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * i2s0's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * i2s0's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * i2s0's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * i2s0's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_0_REG register
 * i2s1 dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x58)

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock i2s1 dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_1_REG register
 * i2s1 dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x5c)

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * i2s1's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * i2s1's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * i2s1's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * i2s1's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * i2s1's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * i2s1's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S1_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG register
 * mac dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x60)

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock mac dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG register
 * mac dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x64)

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * mac's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * mac's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * mac's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * mac's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * mac's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * mac's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG register
 * backup dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x68)

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock backup dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG register
 * backup dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x6c)

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [11:10]; default: 3;
 * backup's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [9:8]; default: 3;
 * backup's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * backup's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * backup's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * backup's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * backup's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG register
 * aes dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x70)

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock aes dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG register
 * aes dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x74)

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * aes's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * aes's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * aes's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * aes's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * aes's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * aes's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG register
 * sha dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x78)

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock sha dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG register
 * sha dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x7c)

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * sha's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * sha's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * sha's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * sha's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * sha's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * sha's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG register
 * adc_dac dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x80)

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock adc_dac dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG register
 * adc_dac dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x84)

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [11:10]; default: 3;
 * adc_dac's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [9:8]; default: 3;
 * adc_dac's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * adc_dac's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * adc_dac's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * adc_dac's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * adc_dac's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_0_REG register
 * rmt dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x88)

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock rmt dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_1_REG register
 * rmt dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x8c)

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * rmt's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * rmt's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * rmt's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * rmt's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * rmt's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * rmt's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_RMT_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_0_REG register
 * lcd_cam dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x90)

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock lcd_cam dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_1_REG register
 * lcd_cam dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x94)

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [11:10]; default: 3;
 * lcd_cam's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [9:8]; default: 3;
 * lcd_cam's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * lcd_cam's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * lcd_cam's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * lcd_cam's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * lcd_cam's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LCD_CAM_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_0_REG register
 * usb dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x98)

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock usb dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_1_REG register
 * usb dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x9c)

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * usb's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * usb's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * usb's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * usb's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * usb's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * usb's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_USB_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG register
 * lc dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xa0)

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default:
 * 0;
 * Set 1 to lock lc dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG register
 * lc dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xa4)

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * lc's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * lc's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * lc's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * lc's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * lc's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * lc's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_0_REG register
 * sdio dma permission configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xa8)

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock sdio dma permission Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_1_REG register
 * sdio dma permission configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xac)

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1 : R/W;
 * bitpos: [11:10]; default: 3;
 * sdio's permission(store,load) in dcache data sram block1
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0 : R/W;
 * bitpos: [9:8]; default: 3;
 * sdio's permission(store,load) in dcache data sram block0
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3 : R/W; bitpos: [7:6];
 * default: 3;
 * sdio's permission(store,load) in data region3 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_3_S  6

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2 : R/W; bitpos: [5:4];
 * default: 3;
 * sdio's permission(store,load) in data region2 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_2_S  4

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1 : R/W; bitpos: [3:2];
 * default: 3;
 * sdio's permission(store,load) in data region1 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_1_S  2

/* SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0 : R/W; bitpos: [1:0];
 * default: 3;
 * sdio's permission(store,load) in data region0 of SRAM
 */

#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0    0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_M  (SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_V << SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_V  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_PMS_CONSTRAIN_SRAM_PMS_0_S  0

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG register
 * dma permission monitor configuration register 0.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0xb0)

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock  dma permission monitor Configuration Register.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG register
 * dma permission monitor configuration register 1.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0xb4)

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default:
 * 1;
 * Set 1 to enable dma pms monitor, if dma access violated permission, will
 * trigger interrupt.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear dma_pms_monitor_violate interrupt
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG register
 * dma permission monitor configuration register 2.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xb8)

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos:
 * [24:3]; default: 0;
 * recorded dma's address bit[25:4] status when dma access violated
 * permission, real address is 0x3c00_0000+addr*16
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003fffff
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x003fffff
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  3

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos:
 * [2:1]; default: 0;
 * recorded dma's world status when dma access violated permission
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  1

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * recorded dma's interrupt status when dma access violated permission
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG register
 * dma permission monitor configuration register 3.
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0xbc)

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO; bitpos:
 * [16:1]; default: 0;
 * recorded dma's byte enable status when dma access violated permission
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000ffff
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0x0000ffff
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1

/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [0];
 * default: 0;
 * recorded dma's write status when dma access violated permission,
 * 1(write), 0(read)
 */

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG register
 * sram split line configuration register 0
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xc0)

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK : R/W; bitpos:
 * [0]; default: 0;
 * Set 1 to lock sram split configuration register
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG register
 * sram split line configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xc4)

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR : R/W; bitpos: [21:14];
 * default: 0;
 * splitaddr of core_x_iram0_dram_dma_line, configured as [15:8]bit of
 * actual address
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR    0x000000ff
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V  0x000000ff
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S  14

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6 : R/W; bitpos: [13:12];
 * default: 0;
 * category6 of core_x_iram0_dram_dma_line, if the splitaddress in block6 of
 * SRAM, configured as 0x10, else if the splitaddress below block6 of SRAM,
 * configured as 0x11, else if splitaddress higher than block6 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_6_S  12

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5 : R/W; bitpos: [11:10];
 * default: 0;
 * category5 of core_x_iram0_dram_dma_line, if the splitaddress in block5 of
 * SRAM, configured as 0x10, else if the splitaddress below block5 of SRAM,
 * configured as 0x11, else if splitaddress higher than block5 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_5_S  10

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4 : R/W; bitpos: [9:8];
 * default: 0;
 * category4 of core_x_iram0_dram_dma_line, if the splitaddress in block4 of
 * SRAM, configured as 0x10, else if the splitaddress below block4 of SRAM,
 * configured as 0x11, else if splitaddress higher than block4 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_4_S  8

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3 : R/W; bitpos: [7:6];
 * default: 0;
 * category3 of core_x_iram0_dram_dma_line, if the splitaddress in block3 of
 * SRAM, configured as 0x10, else if the splitaddress below block3 of SRAM,
 * configured as 0x11, else if splitaddress higher than block3 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_3_S  6

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2 : R/W; bitpos: [5:4];
 * default: 0;
 * category2 of core_x_iram0_dram_dma_line, if the splitaddress in block2 of
 * SRAM, configured as 0x10, else if the splitaddress below block2 of SRAM,
 * configured as 0x11, else if splitaddress higher than block2 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S  4

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1 : R/W; bitpos: [3:2];
 * default: 0;
 * category1 of core_x_iram0_dram_dma_line, if the splitaddress in block1 of
 * SRAM, configured as 0x10, else if the splitaddress below block1 of SRAM,
 * configured as 0x11, else if splitaddress higher than block1 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S  2

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0 : R/W; bitpos: [1:0];
 * default: 0;
 * category0 of core_x_iram0_dram_dma_line, if the splitaddress in block0 of
 * SRAM, configured as 0x10, else if the splitaddress below block0 of SRAM,
 * configured as 0x11, else if splitaddress higher than block0 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG register
 * sram split line configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0xc8)

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR : R/W; bitpos: [21:14];
 * default: 0;
 * splitaddr of core_x_iram0_dram_dma_line, configured as [15:8]bit of
 * actual address
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR    0x000000ff
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V  0x000000ff
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S  14

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6 : R/W; bitpos: [13:12];
 * default: 0;
 * category6 of core_x_iram0_dram_dma_line, if the splitaddress in block6 of
 * SRAM, configured as 0x10, else if the splitaddress below block6 of SRAM,
 * configured as 0x11, else if splitaddress higher than block6 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_6_S  12

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5 : R/W; bitpos: [11:10];
 * default: 0;
 * category5 of core_x_iram0_dram_dma_line, if the splitaddress in block5 of
 * SRAM, configured as 0x10, else if the splitaddress below block5 of SRAM,
 * configured as 0x11, else if splitaddress higher than block5 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_5_S  10

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4 : R/W; bitpos: [9:8];
 * default: 0;
 * category4 of core_x_iram0_dram_dma_line, if the splitaddress in block4 of
 * SRAM, configured as 0x10, else if the splitaddress below block4 of SRAM,
 * configured as 0x11, else if splitaddress higher than block4 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_4_S  8

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3 : R/W; bitpos: [7:6];
 * default: 0;
 * category3 of core_x_iram0_dram_dma_line, if the splitaddress in block3 of
 * SRAM, configured as 0x10, else if the splitaddress below block3 of SRAM,
 * configured as 0x11, else if splitaddress higher than block3 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_3_S  6

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2 : R/W; bitpos: [5:4];
 * default: 0;
 * category2 of core_x_iram0_dram_dma_line, if the splitaddress in block2 of
 * SRAM, configured as 0x10, else if the splitaddress below block2 of SRAM,
 * configured as 0x11, else if splitaddress higher than block2 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S  4

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1 : R/W; bitpos: [3:2];
 * default: 0;
 * category1 of core_x_iram0_dram_dma_line, if the splitaddress in block1 of
 * SRAM, configured as 0x10, else if the splitaddress below block1 of SRAM,
 * configured as 0x11, else if splitaddress higher than block1 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S  2

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0 : R/W; bitpos: [1:0];
 * default: 0;
 * category0 of core_x_iram0_dram_dma_line, if the splitaddress in block0 of
 * SRAM, configured as 0x10, else if the splitaddress below block0 of SRAM,
 * configured as 0x11, else if splitaddress higher than block0 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG register
 * sram split line configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0xcc)

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR : R/W; bitpos: [21:14];
 * default: 0;
 * splitaddr of core_x_iram0_dram_dma_line, configured as [15:8]bit of
 * actual address
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR    0x000000ff
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V  0x000000ff
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S  14

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6 : R/W; bitpos: [13:12];
 * default: 0;
 * category6 of core_x_iram0_dram_dma_line, if the splitaddress in block6 of
 * SRAM, configured as 0x10, else if the splitaddress below block6 of SRAM,
 * configured as 0x11, else if splitaddress higher than block6 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_6_S  12

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5 : R/W; bitpos: [11:10];
 * default: 0;
 * category5 of core_x_iram0_dram_dma_line, if the splitaddress in block5 of
 * SRAM, configured as 0x10, else if the splitaddress below block5 of SRAM,
 * configured as 0x11, else if splitaddress higher than block5 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_5_S  10

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4 : R/W; bitpos: [9:8];
 * default: 0;
 * category4 of core_x_iram0_dram_dma_line, if the splitaddress in block4 of
 * SRAM, configured as 0x10, else if the splitaddress below block4 of SRAM,
 * configured as 0x11, else if splitaddress higher than block4 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_4_S  8

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3 : R/W; bitpos: [7:6];
 * default: 0;
 * category3 of core_x_iram0_dram_dma_line, if the splitaddress in block3 of
 * SRAM, configured as 0x10, else if the splitaddress below block3 of SRAM,
 * configured as 0x11, else if splitaddress higher than block3 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_3_S  6

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2 : R/W; bitpos: [5:4];
 * default: 0;
 * category2 of core_x_iram0_dram_dma_line, if the splitaddress in block2 of
 * SRAM, configured as 0x10, else if the splitaddress below block2 of SRAM,
 * configured as 0x11, else if splitaddress higher than block2 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S  4

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1 : R/W; bitpos: [3:2];
 * default: 0;
 * category1 of core_x_iram0_dram_dma_line, if the splitaddress in block1 of
 * SRAM, configured as 0x10, else if the splitaddress below block1 of SRAM,
 * configured as 0x11, else if splitaddress higher than block1 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S  2

/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0 : R/W; bitpos: [1:0];
 * default: 0;
 * category0 of core_x_iram0_dram_dma_line, if the splitaddress in block0 of
 * SRAM, configured as 0x10, else if the splitaddress below block0 of SRAM,
 * configured as 0x11, else if splitaddress higher than block0 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG register
 * sram split line configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0xd0)

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR : R/W; bitpos: [21:14];
 * default: 0;
 * splitaddr of core_x_iram0_dram_dma_line, configured as [15:8]bit of
 * actual address
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR    0x000000ff
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V  0x000000ff
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S  14

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6 : R/W; bitpos: [13:12];
 * default: 0;
 * category6 of core_x_iram0_dram_dma_line, if the splitaddress in block6 of
 * SRAM, configured as 0x10, else if the splitaddress below block6 of SRAM,
 * configured as 0x11, else if splitaddress higher than block6 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_6_S  12

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5 : R/W; bitpos: [11:10];
 * default: 0;
 * category5 of core_x_iram0_dram_dma_line, if the splitaddress in block5 of
 * SRAM, configured as 0x10, else if the splitaddress below block5 of SRAM,
 * configured as 0x11, else if splitaddress higher than block5 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_5_S  10

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4 : R/W; bitpos: [9:8];
 * default: 0;
 * category4 of core_x_iram0_dram_dma_line, if the splitaddress in block4 of
 * SRAM, configured as 0x10, else if the splitaddress below block4 of SRAM,
 * configured as 0x11, else if splitaddress higher than block4 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_4_S  8

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3 : R/W; bitpos: [7:6];
 * default: 0;
 * category3 of core_x_iram0_dram_dma_line, if the splitaddress in block3 of
 * SRAM, configured as 0x10, else if the splitaddress below block3 of SRAM,
 * configured as 0x11, else if splitaddress higher than block3 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_3_S  6

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2 : R/W; bitpos: [5:4];
 * default: 0;
 * category2 of core_x_iram0_dram_dma_line, if the splitaddress in block2 of
 * SRAM, configured as 0x10, else if the splitaddress below block2 of SRAM,
 * configured as 0x11, else if splitaddress higher than block2 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S  4

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1 : R/W; bitpos: [3:2];
 * default: 0;
 * category1 of core_x_iram0_dram_dma_line, if the splitaddress in block1 of
 * SRAM, configured as 0x10, else if the splitaddress below block1 of SRAM,
 * configured as 0x11, else if splitaddress higher than block1 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S  2

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0 : R/W; bitpos: [1:0];
 * default: 0;
 * category0 of core_x_iram0_dram_dma_line, if the splitaddress in block0 of
 * SRAM, configured as 0x10, else if the splitaddress below block0 of SRAM,
 * configured as 0x11, else if splitaddress higher than block0 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S  0

/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG register
 * sram split line configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0xd4)

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR : R/W; bitpos: [21:14];
 * default: 0;
 * splitaddr of core_x_iram0_dram_dma_line, configured as [15:8]bit of
 * actual address
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR    0x000000ff
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V  0x000000ff
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S  14

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6 : R/W; bitpos: [13:12];
 * default: 0;
 * category6 of core_x_iram0_dram_dma_line, if the splitaddress in block6 of
 * SRAM, configured as 0x10, else if the splitaddress below block6 of SRAM,
 * configured as 0x11, else if splitaddress higher than block6 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_6_S  12

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5 : R/W; bitpos: [11:10];
 * default: 0;
 * category5 of core_x_iram0_dram_dma_line, if the splitaddress in block5 of
 * SRAM, configured as 0x10, else if the splitaddress below block5 of SRAM,
 * configured as 0x11, else if splitaddress higher than block5 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_5_S  10

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4 : R/W; bitpos: [9:8];
 * default: 0;
 * category4 of core_x_iram0_dram_dma_line, if the splitaddress in block4 of
 * SRAM, configured as 0x10, else if the splitaddress below block4 of SRAM,
 * configured as 0x11, else if splitaddress higher than block4 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_4_S  8

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3 : R/W; bitpos: [7:6];
 * default: 0;
 * category3 of core_x_iram0_dram_dma_line, if the splitaddress in block3 of
 * SRAM, configured as 0x10, else if the splitaddress below block3 of SRAM,
 * configured as 0x11, else if splitaddress higher than block3 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_3_S  6

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2 : R/W; bitpos: [5:4];
 * default: 0;
 * category2 of core_x_iram0_dram_dma_line, if the splitaddress in block2 of
 * SRAM, configured as 0x10, else if the splitaddress below block2 of SRAM,
 * configured as 0x11, else if splitaddress higher than block2 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S  4

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1 : R/W; bitpos: [3:2];
 * default: 0;
 * category1 of core_x_iram0_dram_dma_line, if the splitaddress in block1 of
 * SRAM, configured as 0x10, else if the splitaddress below block1 of SRAM,
 * configured as 0x11, else if splitaddress higher than block1 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S  2

/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0 : R/W; bitpos: [1:0];
 * default: 0;
 * category0 of core_x_iram0_dram_dma_line, if the splitaddress in block0 of
 * SRAM, configured as 0x10, else if the splitaddress below block0 of SRAM,
 * configured as 0x11, else if splitaddress higher than block0 of SRAM,
 * configured as 0x00
 */

#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S  0

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG register
 * corex iram0 permission configuration register 0
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xd8)

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock corex iram0 permission configuration register
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG register
 * corex iram0 permission configuration register 0
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xdc)

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W; bitpos:
 * [20:18]; default: 7;
 * core0/core1's permission of rom in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  18

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [17:15]; default: 7;
 * core0/core1's permission of icache data sram block1 in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S  15

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [14:12]; default: 7;
 * core0/core1's permission of icache data sram block0 in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  12

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 * [11:9]; default: 7;
 * core0/core1's permission of instruction region3 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  9

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 * [8:6]; default: 7;
 * core0/core1's permission of instruction region2 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  6

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 * [5:3]; default: 7;
 * core0/core1's permission of instruction region1 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  3

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 * [2:0]; default: 7;
 * core0/core1's permission of instruction region0 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  0

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG register
 * corex iram0 permission configuration register 1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0xe0)

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W; bitpos:
 * [20:18]; default: 7;
 * core0/core1's permission of rom in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  18

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [17:15]; default: 7;
 * core0/core1's permission of icache data sram block1 in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S  15

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [14:12]; default: 7;
 * core0/core1's permission of icache data sram block0 in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  12

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 * [11:9]; default: 7;
 * core0/core1's permission of instruction region3 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  9

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 * [8:6]; default: 7;
 * core0/core1's permission of instruction region2 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  6

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 * [5:3]; default: 7;
 * core0/core1's permission of instruction region1 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  3

/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 * [2:0]; default: 7;
 * core0/core1's permission of instruction region0 of SRAM in world1
 */

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG register
 * core0 iram0 permission monitor configuration register 0
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0xe4)

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 iram0 permission monitor register
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG register
 * core0 iram0 permission monitor configuration register 1
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0xe8)

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable core0 iram0 permission monitor, when core0_iram violated
 * permission, will trigger interrupt
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear core0 iram0 permission violated interrupt
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG register
 * core0 iram0 permission monitor configuration register 2
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xec)

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos:
 * [28:5]; default: 0;
 * recorded core0 iram0 address [25:2] status when core0 iram0 violated
 * permission, the real address is 0x40000000+addr*4
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00ffffff
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x00ffffff
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos:
 * [4:3]; default: 0;
 * recorded core0 iram0 world status, 0x01 means world0, 0x10 means world1.
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO; bitpos:
 * [2]; default: 0;
 * recorded core0 iram0 loadstore status, indicated the type of operation,
 * 0(fetch), 1(load/store).
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE    (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [1];
 * default: 0;
 * recorded core0 iram0 wr status, only if loadstore is 1 have meaning,
 * 1(store), 0(load).
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1

/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * recorded core0 iram0 pms monitor interrupt status.
 */

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_0_REG register
 * core1 iram0 permission monitor configuration register 0
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0xf0)

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 iram0 permission monitor register
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_1_REG register
 * core1 iram0 permission monitor configuration register 1
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0xf4)

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable core1 iram0 permission monitor, when core1_iram violated
 * permission, will trigger interrupt
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear core1 iram0 permission violated interrupt
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_2_REG register
 * core1 iram0 permission monitor configuration register 2
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xf8)

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos:
 * [28:5]; default: 0;
 * recorded core1 iram0 address [25:2] status when core1 iram0 violated
 * permission, the real address is 0x40000000+addr*4
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00ffffff
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x00ffffff
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos:
 * [4:3]; default: 0;
 * recorded core1 iram0 world status, 0x01 means world0, 0x10 means world1.
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO; bitpos:
 * [2]; default: 0;
 * recorded core1 iram0 loadstore status, indicated the type of operation,
 * 0(fetch), 1(load/store).
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE    (BIT(2))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [1];
 * default: 0;
 * recorded core1 iram0 wr status, only if loadstore is 1 have meaning,
 * 1(store), 0(load).
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(1))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1

/* SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * recorded core1 iram0 pms monitor interrupt status.
 */

#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG register
 * corex dram0 permission configuration register 0
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xfc)

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock corex dram0 permission configuration register
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG register
 * corex dram0 permission configuration register 1
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x100)

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W; bitpos:
 * [27:26]; default: 3;
 * core0/core1's permission (store,load) of rom in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  26

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W; bitpos:
 * [25:24]; default: 3;
 * core0/core1's permission (store,load) of rom in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  24

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [23:22]; default: 3;
 * core0/core1's permission of dcache data sram block1 in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_1_S  22

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [21:20]; default: 3;
 * core0/core1's permission of dcache data sram block0 in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  20

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 * [19:18]; default: 3;
 * core0/core1's permission of data region3 of SRAM in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 * [17:16]; default: 3;
 * core0/core1's permission of data region2 of SRAM in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 * [15:14]; default: 3;
 * core0/core1's permission of data region1 of SRAM in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 * [13:12]; default: 3;
 * core0/core1's permission of data region0 of SRAM in world1.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1 :
 * R/W; bitpos: [11:10]; default: 3;
 * core0/core1's permission of dcache data sram block1 in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_1_S  10

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 :
 * R/W; bitpos: [9:8]; default: 3;
 * core0/core1's permission of dcache data sram block0 in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  8

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * core0/core1's permission of data region3 of SRAM in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * core0/core1's permission of data region2 of SRAM in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * core0/core1's permission of data region1 of SRAM in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2

/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * core0/core1's permission of data region0 of SRAM in world0.
 */

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG register
 * core0 dram0 permission monitor configuration register 0
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x104)

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 dram0 permission monitor configuration register.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG register
 * core0 dram0 permission monitor configuration register 1
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x108)

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable core0 dram0 permission monitor interrupt.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear core0 dram0 permission monior interrupt.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG register
 * core0 dram0 permission monitor configuration register 2.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x10c)

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos:
 * [25:4]; default: 0;
 * recorded core0 dram0 address[25:4] status when core0 dram0 violated
 * permission,the real address is 0x3c000000+addr*16
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003fffff
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x003fffff
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos:
 * [3:2]; default: 0;
 * recorded core0 dram0 world status, 0x1 means world0, 0x2 means world1.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO; bitpos: [1];
 * default: 0;
 * recorded core0 dram0 lock status, 1 means s32c1i access.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * recorded core0 dram0 permission monitor interrupt status.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG register
 * core0 dram0 permission monitor configuration register 3.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x110)

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO; bitpos:
 * [16:1]; default: 0;
 * recorded core0 dram0 byteen status.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000ffff
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0x0000ffff
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1

/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [0];
 * default: 0;
 * recorded core0 dram0 wr status, 1 means store, 0 means load.
 */

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_0_REG register
 * core1 dram0 permission monitor configuration register 0
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x114)

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 dram0 permission monitor configuration register.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_1_REG register
 * core1 dram0 permission monitor configuration register 1
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x118)

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable core1 dram0 permission monitor interrupt.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear core1 dram0 permission monior interrupt.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_2_REG register
 * core1 dram0 permission monitor configuration register 2.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x11c)

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos:
 * [25:4]; default: 0;
 * recorded core1 dram0 address[25:4] status when core1 dram0 violated
 * permission,the real address is 0x3c000000+addr*16
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x003fffff
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x003fffff
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos:
 * [3:2]; default: 0;
 * recorded core1 dram0 world status, 0x1 means world0, 0x2 means world1.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO; bitpos: [1];
 * default: 0;
 * recorded core1 dram0 lock status, 1 means s32c1i access.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK    (BIT(1))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * recorded core1 dram0 permission monitor interrupt status.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_3_REG register
 * core1 dram0 permission monitor configuration register 3.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x120)

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO; bitpos:
 * [16:1]; default: 0;
 * recorded core1 dram0 byteen status.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000ffff
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0x0000ffff
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1

/* SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [0];
 * default: 0;
 * recorded core1 dram0 wr status, 1 means store, 0 means load.
 */

#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001
#define SENSITIVE_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG register
 * Core0 access peripherals permission configuration register 0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x124)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 access peripherals permission Configuration Register.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG register
 * Core0 access peripherals permission configuration register 1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x128)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W; bitpos: [31:30];
 * default: 3;
 * Core0 access uart1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0 : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access i2s0 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W; bitpos: [27:26];
 * default: 3;
 * Core0 access i2c permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W; bitpos: [25:24];
 * default: 3;
 * Core0 access misc permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF : R/W; bitpos: [21:20];
 * default: 3;
 * Core0 access hinf permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S  20

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access io_mux permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access rtc permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access fe permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2 : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access fe2 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access gpio permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access g0spi_0 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access g0spi_1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access uart permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG register
 * Core0 access peripherals permission configuration register 2.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x12c)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W; bitpos:
 * [31:30]; default: 3;
 * Core0 access systimer permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W; bitpos:
 * [29:28]; default: 3;
 * Core0 access timergroup1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W; bitpos:
 * [27:26]; default: 3;
 * Core0 access timergroup permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0 : R/W; bitpos: [25:24];
 * default: 3;
 * Core0 access pwm0 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB : R/W; bitpos: [23:22];
 * default: 3;
 * Core0 access bb permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BB_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP : R/W; bitpos: [19:18];
 * default: 3;
 * Core0 access backup permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S  18

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access ledc permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access slc permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access pcnt permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access rmt permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access slchost permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access uhci0 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access i2c_ext0 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access bt permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG register
 * Core0 access peripherals permission configuration register 3.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x130)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access pwr permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC : R/W; bitpos:
 * [27:26]; default: 3;
 * Core0 access wifimac permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W; bitpos: [23:22];
 * default: 3;
 * Core0 access rwbt permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2 : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access uart2 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access i2s1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1 : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access pwm1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access can permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST : R/W; bitpos:
 * [9:8]; default: 3;
 * Core0 access sdio_host permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1 : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access i2c_ext1 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access apb_ctrl permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3 : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access spi_3 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access spi_2 permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG register
 * Core0 access peripherals permission configuration register 4.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x134)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W;
 * bitpos: [31:30]; default: 3;
 * Core0 access world_controller permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access dio permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W; bitpos: [27:26];
 * default: 3;
 * Core0 access ad permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W; bitpos:
 * [25:24]; default: 3;
 * Core0 access cache_config permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W; bitpos:
 * [23:22]; default: 3;
 * Core0 access dma_copy permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W; bitpos:
 * [21:20]; default: 3;
 * Core0 access interrupt permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  20

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W; bitpos:
 * [19:18]; default: 3;
 * Core0 access sensitive permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  18

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access system permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access usb permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access bt_pwr permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM : R/W; bitpos:
 * [11:10]; default: 3;
 * Core0 access lcd_cam permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access apb_adc permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W; bitpos:
 * [7:6]; default: 3;
 * Core0 access crypto_dma permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W; bitpos:
 * [5:4]; default: 3;
 * Core0 access crypto_peri permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access usb_wrap permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W; bitpos:
 * [1:0]; default: 3;
 * Core0 access usb_device permission in world0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG register
 * Core0 access peripherals permission configuration register 5.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x138)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W; bitpos: [31:30];
 * default: 3;
 * Core0 access uart1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0 : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access i2s0 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W; bitpos: [27:26];
 * default: 3;
 * Core0 access i2c permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W; bitpos: [25:24];
 * default: 3;
 * Core0 access misc permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF : R/W; bitpos: [21:20];
 * default: 3;
 * Core0 access hinf permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S  20

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access io_mux permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access rtc permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access fe permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2 : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access fe2 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access gpio permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access g0spi_0 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access g0spi_1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access uart permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG register
 * Core0 access peripherals permission configuration register 6.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x13c)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W; bitpos:
 * [31:30]; default: 3;
 * Core0 access systimer permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W; bitpos:
 * [29:28]; default: 3;
 * Core0 access timergroup1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W; bitpos:
 * [27:26]; default: 3;
 * Core0 access timergroup permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0 : R/W; bitpos: [25:24];
 * default: 3;
 * Core0 access pwm0 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB : R/W; bitpos: [23:22];
 * default: 3;
 * Core0 access bb permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BB_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP : R/W; bitpos: [19:18];
 * default: 3;
 * Core0 access backup permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S  18

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access ledc permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access slc permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access pcnt permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access rmt permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access slchost permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access uhci0 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access i2c_ext0 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access bt permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG register
 * Core0 access peripherals permission configuration register 7.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x140)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access pwr permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC : R/W; bitpos:
 * [27:26]; default: 3;
 * Core0 access wifimac permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W; bitpos: [23:22];
 * default: 3;
 * Core0 access rwbt permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2 : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access uart2 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access i2s1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1 : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access pwm1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN : R/W; bitpos: [11:10];
 * default: 3;
 * Core0 access can permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST : R/W; bitpos:
 * [9:8]; default: 3;
 * Core0 access sdio_host permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1 : R/W; bitpos: [7:6];
 * default: 3;
 * Core0 access i2c_ext1 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W; bitpos: [5:4];
 * default: 3;
 * Core0 access apb_ctrl permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3 : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access spi_3 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W; bitpos: [1:0];
 * default: 3;
 * Core0 access spi_2 permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG register
 * Core0 access peripherals permission configuration register 8.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x144)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W;
 * bitpos: [31:30]; default: 3;
 * Core0 access world_controller permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  30

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W; bitpos: [29:28];
 * default: 3;
 * Core0 access dio permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  28

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W; bitpos: [27:26];
 * default: 3;
 * Core0 access ad permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  26

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W; bitpos:
 * [25:24]; default: 3;
 * Core0 access cache_config permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  24

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W; bitpos:
 * [23:22]; default: 3;
 * Core0 access dma_copy permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  22

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W; bitpos:
 * [21:20]; default: 3;
 * Core0 access interrupt permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  20

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W; bitpos:
 * [19:18]; default: 3;
 * Core0 access sensitive permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  18

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W; bitpos: [17:16];
 * default: 3;
 * Core0 access system permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  16

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB : R/W; bitpos: [15:14];
 * default: 3;
 * Core0 access usb permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_S  14

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR : R/W; bitpos: [13:12];
 * default: 3;
 * Core0 access bt_pwr permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S  12

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM : R/W; bitpos:
 * [11:10]; default: 3;
 * Core0 access lcd_cam permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S  10

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W; bitpos: [9:8];
 * default: 3;
 * Core0 access apb_adc permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W; bitpos:
 * [7:6]; default: 3;
 * Core0 access crypto_dma permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W; bitpos:
 * [5:4]; default: 3;
 * Core0 access crypto_peri permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP : R/W; bitpos: [3:2];
 * default: 3;
 * Core0 access usb_wrap permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S  2

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W; bitpos:
 * [1:0]; default: 3;
 * Core0 access usb_device permission in world1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG register
 * Core0 access peripherals permission configuration register 9.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x148)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCFast memory split address in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCFast memory split address in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG register
 * Core0 access peripherals permission configuration register 10.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x14c)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCFast memory high region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCFast memory low region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCFast memory high region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCFast memory low region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG register
 * Core0 access peripherals permission configuration register 11.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG (DR_REG_SENSITIVE_BASE + 0x150)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCSlow_0 memory split address in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCSlow_0 memory split address in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG register
 * Core0 access peripherals permission configuration register 12.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG (DR_REG_SENSITIVE_BASE + 0x154)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCSlow_0 memory high region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S  9

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCSlow_0 memory low region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCSlow_0 memory high region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S  3

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCSlow_0 memory low region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_13_REG register
 * Core0 access peripherals permission configuration register 13.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_13_REG (DR_REG_SENSITIVE_BASE + 0x158)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCSlow_1 memory split address in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCSlow_1 memory split address in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_14_REG register
 * Core0 access peripherals permission configuration register 14.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_14_REG (DR_REG_SENSITIVE_BASE + 0x15c)

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCSlow_1 memory high region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S  9

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCSlow_1 memory low region permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S  6

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCSlow_1 memory high region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S  3

/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCSlow_1 memory low region permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_0_REG register
 * Core0 region permission register 0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x160)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 region permission registers.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_1_REG register
 * Core0 region permission register 1.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x164)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10 : R/W; bitpos:
 * [21:20]; default: 3;
 * Region 10 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S  20

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9 : R/W; bitpos:
 * [19:18]; default: 3;
 * Region 9 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S  18

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8 : R/W; bitpos:
 * [17:16]; default: 3;
 * Region 8 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S  16

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7 : R/W; bitpos:
 * [15:14]; default: 3;
 * Region 7 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S  14

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W; bitpos:
 * [13:12]; default: 3;
 * Region 6 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W; bitpos:
 * [11:10]; default: 3;
 * Region 5 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W; bitpos:
 * [9:8]; default: 3;
 * Region 4 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * Region 3 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * Region 2 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * Region 1 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * Region 0 permission in world 0 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_2_REG register
 * Core0 region permission register 2.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x168)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10 : R/W; bitpos:
 * [21:20]; default: 3;
 * Region 10 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S  20

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9 : R/W; bitpos:
 * [19:18]; default: 3;
 * Region 9 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S  18

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8 : R/W; bitpos:
 * [17:16]; default: 3;
 * Region 8 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S  16

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7 : R/W; bitpos:
 * [15:14]; default: 3;
 * Region 7 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S  14

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W; bitpos:
 * [13:12]; default: 3;
 * Region 6 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W; bitpos:
 * [11:10]; default: 3;
 * Region 5 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W; bitpos:
 * [9:8]; default: 3;
 * Region 4 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * Region 3 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * Region 2 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * Region 1 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * Region 0 permission in world 1 for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0    0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x00000003
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_3_REG register
 * Core0 region permission register 3.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x16c)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 0 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_0_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_4_REG register
 * Core0 region permission register 4.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x170)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 0 end address and Region 1 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_1_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_5_REG register
 * Core0 region permission register 5.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x174)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 1 end address and Region 2 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_2_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_6_REG register
 * Core0 region permission register 6.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x178)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 2 end address and Region 3 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_3_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_7_REG register
 * Core0 region permission register 7.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x17c)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 3 end address and Region 4 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_4_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_8_REG register
 * Core0 region permission register 8.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x180)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 4 end address and Region 5 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_5_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_9_REG register
 * Core0 region permission register 9.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x184)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 5 end address and Region 6 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_6_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_10_REG register
 * Core0 region permission register 10.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x188)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 6 end address and Region 7 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_7_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_11_REG register
 * Core0 region permission register 11.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_11_REG (DR_REG_SENSITIVE_BASE + 0x18c)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 7 end address and Region 8 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_8_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_12_REG register
 * Core0 region permission register 12.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_12_REG (DR_REG_SENSITIVE_BASE + 0x190)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 8 end address and Region 9 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_9_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_13_REG register
 * Core0 region permission register 13.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_13_REG (DR_REG_SENSITIVE_BASE + 0x194)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 9 end address and Region 10 start address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_10_S  0

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_14_REG register
 * Core0 region permission register 14.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_14_REG (DR_REG_SENSITIVE_BASE + 0x198)

/* SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 10 end address for core0.
 */

#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11    0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_M  (SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_V << SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_S)
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_V  0x3fffffff
#define SENSITIVE_CORE_0_REGION_PMS_CONSTRAIN_ADDR_11_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG register
 * Core0 permission report register 0.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x19c)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 permission report registers.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG register
 * Core0 permission report register 1.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x1a0)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default:
 * 1;
 * Set 1 to enable interrupt that core0 initiate illegal PIF bus access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default:
 * 1;
 * Set 1 to clear interrupt that core0 initiate illegal PIF bus access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG register
 * Core0 permission report register 2.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x1a4)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO; bitpos:
 * [7:6]; default: 0;
 * Record world information when core0 initiate illegal access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO; bitpos: [5];
 * default: 0;
 * Record access direction when core0 initiate illegal access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO; bitpos:
 * [4:2]; default: 0;
 * Record access type when core0 initiates an illegal access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO; bitpos:
 * [1]; default: 0;
 * Record hport information when core0 initiate illegal access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default:
 * 0;
 * Record core0 illegal access interrupt state.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG register
 * Core0 permission report register 3.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x1a8)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO; bitpos:
 * [31:0]; default: 0;
 * Record address information when core0 initiate illegal access.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR    0xffffffff
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xffffffff
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG register
 * Core0 permission report register 4.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG (DR_REG_SENSITIVE_BASE + 0x1ac)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable interrupt that core0 initiate unsupported access type.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear interrupt that core0 initiate unsupported access type.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG register
 * Core0 permission report register 5.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG (DR_REG_SENSITIVE_BASE + 0x1b0)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO;
 * bitpos: [4:3]; default: 0;
 * Record world information when core0 initiate unsupported access type.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO;
 * bitpos: [2:1]; default: 0;
 * Record access type when core0 initiate unsupported access type.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE    0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * Record core0 unsupported access type interrupt state.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG register
 * Core0 permission report register 6.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG (DR_REG_SENSITIVE_BASE + 0x1b4)

/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO;
 * bitpos: [31:0]; default: 0;
 * Record address information when core0 initiate unsupported access type.
 */

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR    0xffffffff
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xffffffff
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_REG register
 * core0 vecbase override configuration register 0
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x1b8)

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core0 vecbase configuration register
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_M  (SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_V << SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_S)
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_LOCK_S  0

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_0_REG register
 * core0 vecbase override configuration register 0
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_0_REG (DR_REG_SENSITIVE_BASE + 0x1bc)

/* SENSITIVE_CORE_0_VECBASE_WORLD_MASK : R/W; bitpos: [0]; default: 1;
 * Set 1 to mask world, then only world0_value will work.
 */

#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK    (BIT(0))
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_M  (SENSITIVE_CORE_0_VECBASE_WORLD_MASK_V << SENSITIVE_CORE_0_VECBASE_WORLD_MASK_S)
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_V  0x00000001
#define SENSITIVE_CORE_0_VECBASE_WORLD_MASK_S  0

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_1_REG register
 * core0 vecbase override configuration register 1
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_1_REG (DR_REG_SENSITIVE_BASE + 0x1c0)

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL : R/W; bitpos: [23:22]; default: 0;
 * Set 0x3 to sel vecbase_override to override vecbase register.
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL    0x00000003
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_M  (SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_V << SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_S)
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_V  0x00000003
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_SEL_S  22

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE : R/W; bitpos: [21:0];
 * default: 0;
 * world0 vecbase_override register, when core0 in world0 use this register
 * to override vecbase register.
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE    0x003fffff
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_M  (SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_V << SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_S)
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_V  0x003fffff
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD0_VALUE_S  0

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_2_REG register
 * core0 vecbase override configuration register 1
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_2_REG (DR_REG_SENSITIVE_BASE + 0x1c4)

/* SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE : R/W; bitpos: [21:0];
 * default: 0;
 * world1 vecbase_override register, when core0 in world1 use this register
 * to override vecbase register.
 */

#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE    0x003fffff
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_M  (SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_V << SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_S)
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_V  0x003fffff
#define SENSITIVE_CORE_0_VECBASE_OVERRIDE_WORLD1_VALUE_S  0

/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG register
 * core0 toomanyexception override configuration register 0.
 */

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG (DR_REG_SENSITIVE_BASE + 0x1c8)

/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock core0 toomanyexception override configuration register
 */

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_M  (SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V << SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S)
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V  0x00000001
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S  0

/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG register
 * core0 toomanyexception override configuration register 1.
 */

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG (DR_REG_SENSITIVE_BASE + 0x1cc)

/* SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to mask toomanyexception.
 */

#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE    (BIT(0))
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_M  (SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_V << SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_S)
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_V  0x00000001
#define SENSITIVE_CORE_0_TOOMANYEXCEPTIONS_M_OVERRIDE_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_0_REG register
 * Core1 access peripherals permission configuration register 0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x1d0)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 pif permission configuration register.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_1_REG register
 * Core1 access peripherals permission configuration register 1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x1d4)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W; bitpos: [31:30];
 * default: 3;
 * Core1 access uart1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0 : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access i2s0 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S0_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W; bitpos: [27:26];
 * default: 3;
 * Core1 access i2c permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W; bitpos: [25:24];
 * default: 3;
 * Core1 access misc permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF : R/W; bitpos: [21:20];
 * default: 3;
 * Core1 access hinf permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_HINF_S  20

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access io_mux permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access rtc permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access fe permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2 : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access fe2 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_FE2_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access gpio permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access g0spi_0 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access g0spi_1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access uart permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_2_REG register
 * Core1 access peripherals permission configuration register 2.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x1d8)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W; bitpos:
 * [31:30]; default: 3;
 * Core1 access systimer permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W; bitpos:
 * [29:28]; default: 3;
 * Core1 access timergroup1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W; bitpos:
 * [27:26]; default: 3;
 * Core1 access timergroup permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0 : R/W; bitpos: [25:24];
 * default: 3;
 * Core1 access pwm0 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM0_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB : R/W; bitpos: [23:22];
 * default: 3;
 * Core1 access bb permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BB_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP : R/W; bitpos: [19:18];
 * default: 3;
 * Core1 access backup permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BACKUP_S  18

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access ledc permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access slc permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLC_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access pcnt permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PCNT_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access rmt permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access slchost permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SLCHOST_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access uhci0 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access i2c_ext0 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access bt permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_3_REG register
 * Core1 access peripherals permission configuration register 3.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x1dc)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access pwr permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWR_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC : R/W; bitpos:
 * [27:26]; default: 3;
 * Core1 access wifimac permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WIFIMAC_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W; bitpos: [23:22];
 * default: 3;
 * Core1 access rwbt permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2 : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access uart2 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_UART2_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access i2s1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1 : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access pwm1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_PWM1_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access can permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CAN_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST : R/W; bitpos:
 * [9:8]; default: 3;
 * Core1 access sdio_host permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SDIO_HOST_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1 : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access i2c_ext1 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT1_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access apb_ctrl permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3 : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access spi_3 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_3_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access spi_2 permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_4_REG register
 * Core1 access peripherals permission configuration register 4.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x1e0)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W;
 * bitpos: [31:30]; default: 3;
 * Core1 access world_controller permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access dio permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W; bitpos: [27:26];
 * default: 3;
 * Core1 access ad permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W; bitpos:
 * [25:24]; default: 3;
 * Core1 access cache_config permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W; bitpos:
 * [23:22]; default: 3;
 * Core1 access dma_copy permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W; bitpos:
 * [21:20]; default: 3;
 * Core1 access interrupt permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  20

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W; bitpos:
 * [19:18]; default: 3;
 * Core1 access sensitive permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  18

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access system permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access usb permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access bt_pwr permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_BT_PWR_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM : R/W; bitpos:
 * [11:10]; default: 3;
 * Core1 access lcd_cam permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_LCD_CAM_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access apb_adc permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W; bitpos:
 * [7:6]; default: 3;
 * Core1 access crypto_dma permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W; bitpos:
 * [5:4]; default: 3;
 * Core1 access crypto_peri permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access usb_wrap permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_WRAP_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W; bitpos:
 * [1:0]; default: 3;
 * Core1 access usb_device permission in world0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_5_REG register
 * Core1 access peripherals permission configuration register 5.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x1e4)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W; bitpos: [31:30];
 * default: 3;
 * Core1 access uart1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0 : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access i2s0 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S0_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W; bitpos: [27:26];
 * default: 3;
 * Core1 access i2c permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W; bitpos: [25:24];
 * default: 3;
 * Core1 access misc permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF : R/W; bitpos: [21:20];
 * default: 3;
 * Core1 access hinf permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_HINF_S  20

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access io_mux permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access rtc permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access fe permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2 : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access fe2 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_FE2_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access gpio permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access g0spi_0 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access g0spi_1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access uart permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_6_REG register
 * Core1 access peripherals permission configuration register 6.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x1e8)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W; bitpos:
 * [31:30]; default: 3;
 * Core1 access systimer permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W; bitpos:
 * [29:28]; default: 3;
 * Core1 access timergroup1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W; bitpos:
 * [27:26]; default: 3;
 * Core1 access timergroup permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0 : R/W; bitpos: [25:24];
 * default: 3;
 * Core1 access pwm0 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM0_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB : R/W; bitpos: [23:22];
 * default: 3;
 * Core1 access bb permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BB_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP : R/W; bitpos: [19:18];
 * default: 3;
 * Core1 access backup permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BACKUP_S  18

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access ledc permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access slc permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLC_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access pcnt permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PCNT_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access rmt permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access slchost permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SLCHOST_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access uhci0 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access i2c_ext0 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access bt permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_7_REG register
 * Core1 access peripherals permission configuration register 7.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x1ec)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access pwr permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWR_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC : R/W; bitpos:
 * [27:26]; default: 3;
 * Core1 access wifimac permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WIFIMAC_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W; bitpos: [23:22];
 * default: 3;
 * Core1 access rwbt permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2 : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access uart2 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_UART2_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access i2s1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1 : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access pwm1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_PWM1_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN : R/W; bitpos: [11:10];
 * default: 3;
 * Core1 access can permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CAN_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST : R/W; bitpos:
 * [9:8]; default: 3;
 * Core1 access sdio_host permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SDIO_HOST_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1 : R/W; bitpos: [7:6];
 * default: 3;
 * Core1 access i2c_ext1 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT1_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W; bitpos: [5:4];
 * default: 3;
 * Core1 access apb_ctrl permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3 : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access spi_3 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_3_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W; bitpos: [1:0];
 * default: 3;
 * Core1 access spi_2 permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_8_REG register
 * Core1 access peripherals permission configuration register 8.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x1f0)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W;
 * bitpos: [31:30]; default: 3;
 * Core1 access world_controller permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  30

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W; bitpos: [29:28];
 * default: 3;
 * Core1 access dio permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  28

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W; bitpos: [27:26];
 * default: 3;
 * Core1 access ad permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  26

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W; bitpos:
 * [25:24]; default: 3;
 * Core1 access cache_config permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  24

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W; bitpos:
 * [23:22]; default: 3;
 * Core1 access dma_copy permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  22

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W; bitpos:
 * [21:20]; default: 3;
 * Core1 access interrupt permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  20

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W; bitpos:
 * [19:18]; default: 3;
 * Core1 access sensitive permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  18

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W; bitpos: [17:16];
 * default: 3;
 * Core1 access system permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  16

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB : R/W; bitpos: [15:14];
 * default: 3;
 * Core1 access usb permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_S  14

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR : R/W; bitpos: [13:12];
 * default: 3;
 * Core1 access bt_pwr permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_BT_PWR_S  12

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM : R/W; bitpos:
 * [11:10]; default: 3;
 * Core1 access lcd_cam permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_LCD_CAM_S  10

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W; bitpos: [9:8];
 * default: 3;
 * Core1 access apb_adc permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W; bitpos:
 * [7:6]; default: 3;
 * Core1 access crypto_dma permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W; bitpos:
 * [5:4]; default: 3;
 * Core1 access crypto_peri permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP : R/W; bitpos: [3:2];
 * default: 3;
 * Core1 access usb_wrap permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_WRAP_S  2

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W; bitpos:
 * [1:0]; default: 3;
 * Core1 access usb_device permission in world1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_9_REG register
 * Core1 access peripherals permission configuration register 9.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x1f4)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCFast memory split address in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCFast memory split address in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_10_REG register
 * core1 access peripherals permission configuration register 10.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x1f8)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCFast memory high region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCFast memory low region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCFast memory high region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCFast memory low region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_11_REG register
 * core1 access peripherals permission configuration register 11.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_11_REG (DR_REG_SENSITIVE_BASE + 0x1fc)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCSlow_0 memory split address in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCSlow_0 memory split address in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_12_REG register
 * core1 access peripherals permission configuration register 12.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_12_REG (DR_REG_SENSITIVE_BASE + 0x200)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCSlow_0 memory high region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_H_S  9

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCSlow_0 memory low region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_1_L_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCSlow_0 memory high region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_H_S  3

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCSlow_0 memory low region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_0_WORLD_0_L_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_13_REG register
 * core1 access peripherals permission configuration register 13.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_13_REG (DR_REG_SENSITIVE_BASE + 0x204)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1 : R/W;
 * bitpos: [21:11]; default: 2047;
 * RTCSlow_1 memory split address in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_1_S  11

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0 : R/W;
 * bitpos: [10:0]; default: 2047;
 * RTCSlow_1 memory split address in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0    0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_V  0x000007ff
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_SPLTADDR_WORLD_0_S  0

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_14_REG register
 * core1 access peripherals permission configuration register 14.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_14_REG (DR_REG_SENSITIVE_BASE + 0x208)

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H : R/W; bitpos:
 * [11:9]; default: 7;
 * RTCSlow_1 memory high region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_H_S  9

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L : R/W; bitpos:
 * [8:6]; default: 7;
 * RTCSlow_1 memory low region permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_1_L_S  6

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H : R/W; bitpos:
 * [5:3]; default: 7;
 * RTCSlow_1 memory high region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_H_S  3

/* SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L : R/W; bitpos:
 * [2:0]; default: 7;
 * RTCSlow_1 memory low region permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_M  (SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V << SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S)
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_CONSTRAIN_RTCSLOW_1_WORLD_0_L_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_0_REG register
 * core1 region permission register 0.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x20c)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 region permission registers.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_1_REG register
 * core1 region permission register 1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x210)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10 : R/W; bitpos:
 * [21:20]; default: 3;
 * Region 10 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_10_S  20

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9 : R/W; bitpos:
 * [19:18]; default: 3;
 * Region 9 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_9_S  18

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8 : R/W; bitpos:
 * [17:16]; default: 3;
 * Region 8 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_8_S  16

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7 : R/W; bitpos:
 * [15:14]; default: 3;
 * Region 7 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_7_S  14

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W; bitpos:
 * [13:12]; default: 3;
 * Region 6 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W; bitpos:
 * [11:10]; default: 3;
 * Region 5 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W; bitpos:
 * [9:8]; default: 3;
 * Region 4 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * Region 3 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * Region 2 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * Region 1 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * Region 0 permission in world 0 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_2_REG register
 * core1 region permission register 2.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x214)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10 : R/W; bitpos:
 * [21:20]; default: 3;
 * Region 10 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_10_S  20

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9 : R/W; bitpos:
 * [19:18]; default: 3;
 * Region 9 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_9_S  18

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8 : R/W; bitpos:
 * [17:16]; default: 3;
 * Region 8 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_8_S  16

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7 : R/W; bitpos:
 * [15:14]; default: 3;
 * Region 7 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_7_S  14

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W; bitpos:
 * [13:12]; default: 3;
 * Region 6 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W; bitpos:
 * [11:10]; default: 3;
 * Region 5 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W; bitpos:
 * [9:8]; default: 3;
 * Region 4 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W; bitpos:
 * [7:6]; default: 3;
 * Region 3 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W; bitpos:
 * [5:4]; default: 3;
 * Region 2 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W; bitpos:
 * [3:2]; default: 3;
 * Region 1 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W; bitpos:
 * [1:0]; default: 3;
 * Region 0 permission in world 1 for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0    0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x00000003
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_3_REG register
 * core1 region permission register 3.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x218)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 0 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_0_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_4_REG register
 * core1 region permission register 4.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x21c)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 0 end address and Region 1 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_1_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_5_REG register
 * core1 region permission register 5.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x220)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 1 end address and Region 2 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_2_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_6_REG register
 * core1 region permission register 6.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x224)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 2 end address and Region 3 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_3_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_7_REG register
 * core1 region permission register 7.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x228)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 3 end address and Region 4 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_4_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_8_REG register
 * core1 region permission register 8.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x22c)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 4 end address and Region 5 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_5_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_9_REG register
 * core1 region permission register 9.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x230)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 5 end address and Region 6 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_6_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_10_REG register
 * core1 region permission register 10.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x234)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 6 end address and Region 7 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_7_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_11_REG register
 * core1 region permission register 11.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_11_REG (DR_REG_SENSITIVE_BASE + 0x238)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 7 end address and Region 8 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_8_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_12_REG register
 * core1 region permission register 12.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_12_REG (DR_REG_SENSITIVE_BASE + 0x23c)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 8 end address and Region 9 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_9_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_13_REG register
 * core1 region permission register 13.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_13_REG (DR_REG_SENSITIVE_BASE + 0x240)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 9 end address and Region 10 start address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_10_S  0

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_14_REG register
 * core1 region permission register 14.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_14_REG (DR_REG_SENSITIVE_BASE + 0x244)

/* SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11 : R/W; bitpos: [29:0];
 * default: 0;
 * Region 10 end address for core1.
 */

#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11    0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_M  (SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_V << SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_S)
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_V  0x3fffffff
#define SENSITIVE_CORE_1_REGION_PMS_CONSTRAIN_ADDR_11_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_0_REG register
 * core1 permission report register 0.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x248)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 permission report registers.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_1_REG register
 * core1 permission report register 1.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x24c)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default:
 * 1;
 * Set 1 to enable interrupt that core1 initiate illegal PIF bus access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default:
 * 1;
 * Set 1 to clear interrupt that core1 initiate illegal PIF bus access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_2_REG register
 * core1 permission report register 2.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x250)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO; bitpos:
 * [7:6]; default: 0;
 * Record world information when core1 initiate illegal access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO; bitpos: [5];
 * default: 0;
 * Record access direction when core1 initiate illegal access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(5))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO; bitpos:
 * [4:2]; default: 0;
 * Record access type when core1 initiates an illegal access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x00000007
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO; bitpos:
 * [1]; default: 0;
 * Record hport information when core1 initiate illegal access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default:
 * 0;
 * Record core1 illegal access interrupt state.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_3_REG register
 * core1 permission report register 3.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x254)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO; bitpos:
 * [31:0]; default: 0;
 * Record address information when core1 initiate illegal access.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR    0xffffffff
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xffffffff
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_4_REG register
 * core1 permission report register 4.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_4_REG (DR_REG_SENSITIVE_BASE + 0x258)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W; bitpos: [1];
 * default: 1;
 * Set 1 to enable interrupt that core1 initiate unsupported access type.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to clear interrupt that core1 initiate unsupported access type.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_5_REG register
 * core1 permission report register 5.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_5_REG (DR_REG_SENSITIVE_BASE + 0x25c)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO;
 * bitpos: [4:3]; default: 0;
 * Record world information when core1 initiate unsupported access type.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO;
 * bitpos: [2:1]; default: 0;
 * Record access type when core1 initiate unsupported access type.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE    0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x00000003
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO; bitpos: [0];
 * default: 0;
 * Record core1 unsupported access type interrupt state.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_6_REG register
 * core1 permission report register 6.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_6_REG (DR_REG_SENSITIVE_BASE + 0x260)

/* SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO;
 * bitpos: [31:0]; default: 0;
 * Record address information when core1 initiate unsupported access type.
 */

#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR    0xffffffff
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xffffffff
#define SENSITIVE_CORE_1_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_REG register
 * core1 vecbase override configuration register 0
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x264)

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock core1 vecbase configuration register
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_M  (SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_V << SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_S)
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_LOCK_S  0

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_0_REG register
 * core1 vecbase override configuration register 0
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_0_REG (DR_REG_SENSITIVE_BASE + 0x268)

/* SENSITIVE_CORE_1_VECBASE_WORLD_MASK : R/W; bitpos: [0]; default: 1;
 * Set 1 to mask world, then only world0_value will work.
 */

#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK    (BIT(0))
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_M  (SENSITIVE_CORE_1_VECBASE_WORLD_MASK_V << SENSITIVE_CORE_1_VECBASE_WORLD_MASK_S)
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_V  0x00000001
#define SENSITIVE_CORE_1_VECBASE_WORLD_MASK_S  0

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_1_REG register
 * core1 vecbase override configuration register 1
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_1_REG (DR_REG_SENSITIVE_BASE + 0x26c)

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL : R/W; bitpos: [23:22]; default: 0;
 * Set 0x3 to sel vecbase_override to override vecbase register.
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL    0x00000003
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_M  (SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_V << SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_S)
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_V  0x00000003
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_SEL_S  22

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE : R/W; bitpos: [21:0];
 * default: 0;
 * world0 vecbase_override register, when core1 in world0 use this register
 * to override vecbase register.
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE    0x003fffff
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_M  (SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_V << SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_S)
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_V  0x003fffff
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD0_VALUE_S  0

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_2_REG register
 * core1 vecbase override configuration register 1
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_2_REG (DR_REG_SENSITIVE_BASE + 0x270)

/* SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE : R/W; bitpos: [21:0];
 * default: 0;
 * world1 vecbase_override register, when core1 in world1 use this register
 * to override vecbase register.
 */

#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE    0x003fffff
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_M  (SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_V << SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_S)
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_V  0x003fffff
#define SENSITIVE_CORE_1_VECBASE_OVERRIDE_WORLD1_VALUE_S  0

/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG register
 * core1 toomanyexception override configuration register 0.
 */

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_0_REG (DR_REG_SENSITIVE_BASE + 0x274)

/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK : R/W; bitpos: [0];
 * default: 0;
 * Set 1 to lock core1 toomanyexception override configuration register
 */

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK    (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_M  (SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V << SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S)
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_V  0x00000001
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_LOCK_S  0

/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG register
 * core1 toomanyexception override configuration register 1.
 */

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_1_REG (DR_REG_SENSITIVE_BASE + 0x278)

/* SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE : R/W; bitpos: [0];
 * default: 1;
 * Set 1 to mask toomanyexception.
 */

#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE    (BIT(0))
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_M  (SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_V << SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_S)
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_V  0x00000001
#define SENSITIVE_CORE_1_TOOMANYEXCEPTIONS_M_OVERRIDE_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG register
 * BackUp access peripherals permission configuration register 0.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x27c)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock BackUp permission configuration registers.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG register
 * BackUp access peripherals permission configuration register 1.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x280)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1 : R/W; bitpos: [31:30]; default:
 * 3;
 * BackUp access uart1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S  30

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0 : R/W; bitpos: [29:28]; default:
 * 3;
 * BackUp access i2s0 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S0_S  28

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C : R/W; bitpos: [27:26]; default: 3;
 * BackUp access i2c permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S  26

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC : R/W; bitpos: [25:24]; default:
 * 3;
 * BackUp access misc permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S  24

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF : R/W; bitpos: [21:20]; default:
 * 3;
 * BackUp access hinf permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_HINF_S  20

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX : R/W; bitpos: [17:16];
 * default: 3;
 * BackUp access io_mux permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S  16

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC : R/W; bitpos: [15:14]; default: 3;
 * BackUp access rtc permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S  14

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE : R/W; bitpos: [11:10]; default: 3;
 * BackUp access fe permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S  10

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2 : R/W; bitpos: [9:8]; default: 3;
 * BackUp access fe2 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE2_S  8

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO : R/W; bitpos: [7:6]; default: 3;
 * BackUp access gpio permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S  6

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0 : R/W; bitpos: [5:4]; default:
 * 3;
 * BackUp access g0spi_0 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S  4

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1 : R/W; bitpos: [3:2]; default:
 * 3;
 * BackUp access g0spi_1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S  2

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART : R/W; bitpos: [1:0]; default: 3;
 * BackUp access uart permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG register
 * BackUp access peripherals permission configuration register 2.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x284)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER : R/W; bitpos: [31:30];
 * default: 3;
 * BackUp access systimer permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S  30

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1 : R/W; bitpos: [29:28];
 * default: 3;
 * BackUp access timergroup1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S  28

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP : R/W; bitpos: [27:26];
 * default: 3;
 * BackUp access timergroup permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S  26

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0 : R/W; bitpos: [25:24]; default:
 * 3;
 * BackUp access pwm0 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM0_S  24

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB : R/W; bitpos: [23:22]; default: 3;
 * BackUp access bb permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BB_S  22

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP : R/W; bitpos: [19:18];
 * default: 3;
 * BackUp access backup permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BACKUP_S  18

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC : R/W; bitpos: [17:16]; default:
 * 3;
 * BackUp access ledc permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S  16

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC : R/W; bitpos: [15:14]; default: 3;
 * BackUp access slc permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLC_S  14

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT : R/W; bitpos: [13:12]; default:
 * 3;
 * BackUp access pcnt permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PCNT_S  12

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT : R/W; bitpos: [11:10]; default: 3;
 * BackUp access rmt permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S  10

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST : R/W; bitpos: [9:8]; default:
 * 3;
 * BackUp access slchost permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SLCHOST_S  8

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0 : R/W; bitpos: [7:6]; default: 3;
 * BackUp access uhci0 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S  6

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0 : R/W; bitpos: [5:4];
 * default: 3;
 * BackUp access i2c_ext0 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S  4

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT : R/W; bitpos: [1:0]; default: 3;
 * BackUp access bt permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG register
 * BackUp access peripherals permission configuration register 3.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x288)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR : R/W; bitpos: [29:28]; default: 3;
 * BackUp access pwr permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWR_S  28

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC : R/W; bitpos: [27:26];
 * default: 3;
 * BackUp access wifimac permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WIFIMAC_S  26

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT : R/W; bitpos: [23:22]; default:
 * 3;
 * BackUp access rwbt permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S  22

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2 : R/W; bitpos: [17:16]; default:
 * 3;
 * BackUp access uart2 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART2_S  16

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1 : R/W; bitpos: [15:14]; default:
 * 3;
 * BackUp access i2s1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S  14

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1 : R/W; bitpos: [13:12]; default:
 * 3;
 * BackUp access pwm1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PWM1_S  12

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN : R/W; bitpos: [11:10]; default: 3;
 * BackUp access can permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CAN_S  10

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST : R/W; bitpos: [9:8];
 * default: 3;
 * BackUp access sdio_host permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SDIO_HOST_S  8

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1 : R/W; bitpos: [7:6];
 * default: 3;
 * BackUp access i2c_ext1 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT1_S  6

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL : R/W; bitpos: [5:4];
 * default: 3;
 * BackUp access apb_ctrl permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S  4

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3 : R/W; bitpos: [3:2]; default: 3;
 * BackUp access spi_3 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_3_S  2

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2 : R/W; bitpos: [1:0]; default: 3;
 * BackUp access spi_2 permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG register
 * BackUp access peripherals permission configuration register 4.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x28c)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER : R/W; bitpos:
 * [31:30]; default: 3;
 * BackUp access world_controller permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WORLD_CONTROLLER_S  30

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO : R/W; bitpos: [29:28]; default: 3;
 * BackUp access dio permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DIO_S  28

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD : R/W; bitpos: [27:26]; default: 3;
 * BackUp access ad permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_AD_S  26

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG : R/W; bitpos: [25:24];
 * default: 3;
 * BackUp access cache_config permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CACHE_CONFIG_S  24

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY : R/W; bitpos: [23:22];
 * default: 3;
 * BackUp access dma_copy permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_DMA_COPY_S  22

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT : R/W; bitpos: [21:20];
 * default: 3;
 * BackUp access interrupt permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_INTERRUPT_S  20

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE : R/W; bitpos: [19:18];
 * default: 3;
 * BackUp access sensitive permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SENSITIVE_S  18

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM : R/W; bitpos: [17:16];
 * default: 3;
 * BackUp access system permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTEM_S  16

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB : R/W; bitpos: [15:14]; default: 3;
 * BackUp access usb permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_S  14

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR : R/W; bitpos: [13:12];
 * default: 3;
 * BackUp access bt_pwr permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_PWR_S  12

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM : R/W; bitpos: [11:10];
 * default: 3;
 * BackUp access lcd_cam permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LCD_CAM_S  10

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC : R/W; bitpos: [9:8]; default:
 * 3;
 * BackUp access apb_adc permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S  8

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA : R/W; bitpos: [7:6];
 * default: 3;
 * BackUp access crypto_dma permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S  6

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI : R/W; bitpos: [5:4];
 * default: 3;
 * BackUp access crypto_peri permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S  4

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP : R/W; bitpos: [3:2];
 * default: 3;
 * BackUp access usb_wrap permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_WRAP_S  2

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE : R/W; bitpos: [1:0];
 * default: 3;
 * BackUp access usb_device permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG register
 * BackUp access peripherals permission configuration register 5.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x290)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR : R/W; bitpos:
 * [10:0]; default: 2047;
 * BackUp access rtcfast_spltaddr permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR    0x000007ff
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_V  0x000007ff
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_SPLTADDR_S  0

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_6_REG register
 * BackUp access peripherals permission configuration register 6.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x294)

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H : R/W; bitpos: [5:3];
 * default: 7;
 * BackUp access rtcfast_h permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_V  0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_H_S  3

/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L : R/W; bitpos: [2:0];
 * default: 7;
 * BackUp access rtcfast_l permission.
 */

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_V  0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTCFAST_L_S  0

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG register
 * BackUp permission report register 0.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x298)

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock BackUp permission report registers.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S  0

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG register
 * BackUp permission report register 1.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x29c)

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default:
 * 1;
 * Set 1 to enable interrupt that BackUp initiate illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S  1

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default:
 * 1;
 * Set 1 to clear interrupt that BackUp initiate illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S  0

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG register
 * BackUp permission report register 2.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x2a0)

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO; bitpos: [6];
 * default: 0;
 * Record access direction when BackUp initiate illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  6

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO; bitpos:
 * [5:3]; default: 0;
 * Record access type when BackUp initiates an illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  3

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS : RO; bitpos:
 * [2:1]; default: 0;
 * Record htrans when BackUp initiates an illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS    0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S  1

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default:
 * 0;
 * Record BackUp illegal access interrupt state.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V  0x00000001
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S  0

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG register
 * BackUp permission report register 3.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x2a4)

/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR : RO; bitpos: [31:0];
 * default: 0;
 * Record address information when BackUp initiate illegal access.
 */

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR    0xffffffff
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V  0xffffffff
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S  0

/* SENSITIVE_EDMA_BOUNDARY_LOCK_REG register
 * EDMA boundary lock register.
 */

#define SENSITIVE_EDMA_BOUNDARY_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2a8)

/* SENSITIVE_EDMA_BOUNDARY_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA boundary registers.
 */

#define SENSITIVE_EDMA_BOUNDARY_LOCK    (BIT(0))
#define SENSITIVE_EDMA_BOUNDARY_LOCK_M  (SENSITIVE_EDMA_BOUNDARY_LOCK_V << SENSITIVE_EDMA_BOUNDARY_LOCK_S)
#define SENSITIVE_EDMA_BOUNDARY_LOCK_V  0x00000001
#define SENSITIVE_EDMA_BOUNDARY_LOCK_S  0

/* SENSITIVE_EDMA_BOUNDARY_0_REG register
 * EDMA boundary 0 configuration
 */

#define SENSITIVE_EDMA_BOUNDARY_0_REG (DR_REG_SENSITIVE_BASE + 0x2ac)

/* SENSITIVE_EDMA_BOUNDARY_0 : R/W; bitpos: [13:0]; default: 0;
 * This field is used to configure the boundary 0 of external RAM. The unit
 * is 4K. For example, set this field to 0x80, then the address boundary 0
 * would be 0x3C080000 (0x3C000000 + 0x80 * 4K).
 */

#define SENSITIVE_EDMA_BOUNDARY_0    0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_0_M  (SENSITIVE_EDMA_BOUNDARY_0_V << SENSITIVE_EDMA_BOUNDARY_0_S)
#define SENSITIVE_EDMA_BOUNDARY_0_V  0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_0_S  0

/* SENSITIVE_EDMA_BOUNDARY_1_REG register
 * EDMA boundary 1 configuration
 */

#define SENSITIVE_EDMA_BOUNDARY_1_REG (DR_REG_SENSITIVE_BASE + 0x2b0)

/* SENSITIVE_EDMA_BOUNDARY_1 : R/W; bitpos: [13:0]; default: 8192;
 * This field is used to configure the boundary 1 of external RAM. The unit
 * is 4K. For example, set this field to 0x80, then the address boundary 0
 * would be 0x3C080000 (0x3C000000 + 0x80 * 4K).
 */

#define SENSITIVE_EDMA_BOUNDARY_1    0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_1_M  (SENSITIVE_EDMA_BOUNDARY_1_V << SENSITIVE_EDMA_BOUNDARY_1_S)
#define SENSITIVE_EDMA_BOUNDARY_1_V  0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_1_S  0

/* SENSITIVE_EDMA_BOUNDARY_2_REG register
 * EDMA boundary 2 configuration
 */

#define SENSITIVE_EDMA_BOUNDARY_2_REG (DR_REG_SENSITIVE_BASE + 0x2b4)

/* SENSITIVE_EDMA_BOUNDARY_2 : R/W; bitpos: [13:0]; default: 8192;
 * This field is used to configure the boundary 2 of external RAM. The unit
 * is 4K. For example, set this field to 0x80, then the address boundary 0
 * would be 0x3C080000 (0x3C000000 + 0x80 * 4K).
 */

#define SENSITIVE_EDMA_BOUNDARY_2    0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_2_M  (SENSITIVE_EDMA_BOUNDARY_2_V << SENSITIVE_EDMA_BOUNDARY_2_S)
#define SENSITIVE_EDMA_BOUNDARY_2_V  0x00003fff
#define SENSITIVE_EDMA_BOUNDARY_2_S  0

/* SENSITIVE_EDMA_PMS_SPI2_LOCK_REG register
 * EDMA-SPI2 permission lock register.
 */

#define SENSITIVE_EDMA_PMS_SPI2_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2b8)

/* SENSITIVE_EDMA_PMS_SPI2_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-SPI2 permission control registers.
 */

#define SENSITIVE_EDMA_PMS_SPI2_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_M  (SENSITIVE_EDMA_PMS_SPI2_LOCK_V << SENSITIVE_EDMA_PMS_SPI2_LOCK_S)
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_SPI2_LOCK_S  0

/* SENSITIVE_EDMA_PMS_SPI2_REG register
 * EDMA-SPI2 permission control register.
 */

#define SENSITIVE_EDMA_PMS_SPI2_REG (DR_REG_SENSITIVE_BASE + 0x2bc)

/* SENSITIVE_EDMA_PMS_SPI2_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of SPI2 accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SPI2_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_M  (SENSITIVE_EDMA_PMS_SPI2_ATTR2_V << SENSITIVE_EDMA_PMS_SPI2_ATTR2_S)
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_SPI2_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of SPI2 accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SPI2_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_M  (SENSITIVE_EDMA_PMS_SPI2_ATTR1_V << SENSITIVE_EDMA_PMS_SPI2_ATTR1_S)
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_SPI2_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_SPI3_LOCK_REG register
 * EDMA-SPI3 permission lock register.
 */

#define SENSITIVE_EDMA_PMS_SPI3_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2c0)

/* SENSITIVE_EDMA_PMS_SPI3_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-SPI3 permission control registers.
 */

#define SENSITIVE_EDMA_PMS_SPI3_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_M  (SENSITIVE_EDMA_PMS_SPI3_LOCK_V << SENSITIVE_EDMA_PMS_SPI3_LOCK_S)
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_SPI3_LOCK_S  0

/* SENSITIVE_EDMA_PMS_SPI3_REG register
 * EDMA-SPI3 permission control register.
 */

#define SENSITIVE_EDMA_PMS_SPI3_REG (DR_REG_SENSITIVE_BASE + 0x2c4)

/* SENSITIVE_EDMA_PMS_SPI3_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of SPI3 accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SPI3_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_M  (SENSITIVE_EDMA_PMS_SPI3_ATTR2_V << SENSITIVE_EDMA_PMS_SPI3_ATTR2_S)
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_SPI3_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of SPI3 accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SPI3_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_M  (SENSITIVE_EDMA_PMS_SPI3_ATTR1_V << SENSITIVE_EDMA_PMS_SPI3_ATTR1_S)
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_SPI3_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_UHCI0_LOCK_REG register
 * EDMA-UHCI0 permission lock register.
 */

#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2c8)

/* SENSITIVE_EDMA_PMS_UHCI0_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-UHCI0 permission control registers.
 */

#define SENSITIVE_EDMA_PMS_UHCI0_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_M  (SENSITIVE_EDMA_PMS_UHCI0_LOCK_V << SENSITIVE_EDMA_PMS_UHCI0_LOCK_S)
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_UHCI0_LOCK_S  0

/* SENSITIVE_EDMA_PMS_UHCI0_REG register
 * EDMA-UHCI0 permission control register.
 */

#define SENSITIVE_EDMA_PMS_UHCI0_REG (DR_REG_SENSITIVE_BASE + 0x2cc)

/* SENSITIVE_EDMA_PMS_UHCI0_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of UHCI0 accessing
 * address, which is larger than boundary 1 and less than boundary 2,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_M  (SENSITIVE_EDMA_PMS_UHCI0_ATTR2_V << SENSITIVE_EDMA_PMS_UHCI0_ATTR2_S)
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_UHCI0_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of UHCI0 accessing
 * address, which is larger than boundary 0 and less than boundary 1,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_M  (SENSITIVE_EDMA_PMS_UHCI0_ATTR1_V << SENSITIVE_EDMA_PMS_UHCI0_ATTR1_S)
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_UHCI0_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_I2S0_LOCK_REG register
 * EDMA-I2S0 permission lock register.
 */

#define SENSITIVE_EDMA_PMS_I2S0_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2d0)

/* SENSITIVE_EDMA_PMS_I2S0_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-I2S0 permission control registers.
 */

#define SENSITIVE_EDMA_PMS_I2S0_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_M  (SENSITIVE_EDMA_PMS_I2S0_LOCK_V << SENSITIVE_EDMA_PMS_I2S0_LOCK_S)
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_I2S0_LOCK_S  0

/* SENSITIVE_EDMA_PMS_I2S0_REG register
 * EDMA-I2S0 permission control register.
 */

#define SENSITIVE_EDMA_PMS_I2S0_REG (DR_REG_SENSITIVE_BASE + 0x2d4)

/* SENSITIVE_EDMA_PMS_I2S0_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of I2S0 accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_I2S0_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_M  (SENSITIVE_EDMA_PMS_I2S0_ATTR2_V << SENSITIVE_EDMA_PMS_I2S0_ATTR2_S)
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_I2S0_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of I2S0 accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_I2S0_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_M  (SENSITIVE_EDMA_PMS_I2S0_ATTR1_V << SENSITIVE_EDMA_PMS_I2S0_ATTR1_S)
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_I2S0_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_I2S1_LOCK_REG register
 * EDMA-I2S1 permission lock register.
 */

#define SENSITIVE_EDMA_PMS_I2S1_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2d8)

/* SENSITIVE_EDMA_PMS_I2S1_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-I2S1 permission control registers.
 */

#define SENSITIVE_EDMA_PMS_I2S1_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_M  (SENSITIVE_EDMA_PMS_I2S1_LOCK_V << SENSITIVE_EDMA_PMS_I2S1_LOCK_S)
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_I2S1_LOCK_S  0

/* SENSITIVE_EDMA_PMS_I2S1_REG register
 * EDMA-I2S1 permission control register.
 */

#define SENSITIVE_EDMA_PMS_I2S1_REG (DR_REG_SENSITIVE_BASE + 0x2dc)

/* SENSITIVE_EDMA_PMS_I2S1_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of I2S1 accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_I2S1_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_M  (SENSITIVE_EDMA_PMS_I2S1_ATTR2_V << SENSITIVE_EDMA_PMS_I2S1_ATTR2_S)
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_I2S1_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of I2S1 accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_I2S1_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_M  (SENSITIVE_EDMA_PMS_I2S1_ATTR1_V << SENSITIVE_EDMA_PMS_I2S1_ATTR1_S)
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_I2S1_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_REG register
 * EDMA-LCD/CAM permission lock register.
 */

#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2e0)

/* SENSITIVE_EDMA_PMS_LCD_CAM_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-LCD/CAM permission control registers.
 */

#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_M  (SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_V << SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_S)
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_LCD_CAM_LOCK_S  0

/* SENSITIVE_EDMA_PMS_LCD_CAM_REG register
 * EDMA-LCD/CAM permission control register.
 */

#define SENSITIVE_EDMA_PMS_LCD_CAM_REG (DR_REG_SENSITIVE_BASE + 0x2e4)

/* SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of LCD/CAM accessing
 * address, which is larger than boundary 1 and less than boundary 2,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_M  (SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_V << SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_S)
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of LCD/CAM accessing
 * address, which is larger than boundary 0 and less than boundary 1,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_M  (SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_V << SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_S)
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_LCD_CAM_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_AES_LOCK_REG register
 * EDMA-AES permission lock register.
 */

#define SENSITIVE_EDMA_PMS_AES_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2e8)

/* SENSITIVE_EDMA_PMS_AES_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-AES permission control registers.
 */

#define SENSITIVE_EDMA_PMS_AES_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_AES_LOCK_M  (SENSITIVE_EDMA_PMS_AES_LOCK_V << SENSITIVE_EDMA_PMS_AES_LOCK_S)
#define SENSITIVE_EDMA_PMS_AES_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_AES_LOCK_S  0

/* SENSITIVE_EDMA_PMS_AES_REG register
 * EDMA-AES permission control register.
 */

#define SENSITIVE_EDMA_PMS_AES_REG (DR_REG_SENSITIVE_BASE + 0x2ec)

/* SENSITIVE_EDMA_PMS_AES_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of AES accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_AES_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR2_M  (SENSITIVE_EDMA_PMS_AES_ATTR2_V << SENSITIVE_EDMA_PMS_AES_ATTR2_S)
#define SENSITIVE_EDMA_PMS_AES_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_AES_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of AES accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_AES_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR1_M  (SENSITIVE_EDMA_PMS_AES_ATTR1_V << SENSITIVE_EDMA_PMS_AES_ATTR1_S)
#define SENSITIVE_EDMA_PMS_AES_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_AES_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_SHA_LOCK_REG register
 * EDMA-SHA permission lock register.
 */

#define SENSITIVE_EDMA_PMS_SHA_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2f0)

/* SENSITIVE_EDMA_PMS_SHA_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-SHA permission control registers.
 */

#define SENSITIVE_EDMA_PMS_SHA_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_SHA_LOCK_M  (SENSITIVE_EDMA_PMS_SHA_LOCK_V << SENSITIVE_EDMA_PMS_SHA_LOCK_S)
#define SENSITIVE_EDMA_PMS_SHA_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_SHA_LOCK_S  0

/* SENSITIVE_EDMA_PMS_SHA_REG register
 * EDMA-SHA permission control register.
 */

#define SENSITIVE_EDMA_PMS_SHA_REG (DR_REG_SENSITIVE_BASE + 0x2f4)

/* SENSITIVE_EDMA_PMS_SHA_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of SHA accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SHA_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_M  (SENSITIVE_EDMA_PMS_SHA_ATTR2_V << SENSITIVE_EDMA_PMS_SHA_ATTR2_S)
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_SHA_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of SHA accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_SHA_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_M  (SENSITIVE_EDMA_PMS_SHA_ATTR1_V << SENSITIVE_EDMA_PMS_SHA_ATTR1_S)
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_SHA_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_REG register
 * EDMA-ADC/DAC permission lock register.
 */

#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x2f8)

/* SENSITIVE_EDMA_PMS_ADC_DAC_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-ADC/DAC permission control registers.
 */

#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_M  (SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_V << SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_S)
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_ADC_DAC_LOCK_S  0

/* SENSITIVE_EDMA_PMS_ADC_DAC_REG register
 * EDMA-ADC/DAC permission control register.
 */

#define SENSITIVE_EDMA_PMS_ADC_DAC_REG (DR_REG_SENSITIVE_BASE + 0x2fc)

/* SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of ADC/DAC accessing
 * address, which is larger than boundary 1 and less than boundary 2,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_M  (SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_V << SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_S)
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of ADC/DAC accessing
 * address, which is larger than boundary 0 and less than boundary 1,
 * through EDMA. Bit 0: set this bit to enable read permission. Bit 1: set
 * this bit to enable write permission.
 */

#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_M  (SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_V << SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_S)
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_ADC_DAC_ATTR1_S  0

/* SENSITIVE_EDMA_PMS_RMT_LOCK_REG register
 * EDMA-RMT permission lock register.
 */

#define SENSITIVE_EDMA_PMS_RMT_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x300)

/* SENSITIVE_EDMA_PMS_RMT_LOCK : R/W; bitpos: [0]; default: 0;
 * Set 1 to lock EDMA-RMT permission control registers.
 */

#define SENSITIVE_EDMA_PMS_RMT_LOCK    (BIT(0))
#define SENSITIVE_EDMA_PMS_RMT_LOCK_M  (SENSITIVE_EDMA_PMS_RMT_LOCK_V << SENSITIVE_EDMA_PMS_RMT_LOCK_S)
#define SENSITIVE_EDMA_PMS_RMT_LOCK_V  0x00000001
#define SENSITIVE_EDMA_PMS_RMT_LOCK_S  0

/* SENSITIVE_EDMA_PMS_RMT_REG register
 * EDMA-RMT permission control register.
 */

#define SENSITIVE_EDMA_PMS_RMT_REG (DR_REG_SENSITIVE_BASE + 0x304)

/* SENSITIVE_EDMA_PMS_RMT_ATTR2 : R/W; bitpos: [3:2]; default: 3;
 * This field is used to configure the permission of RMT accessing address,
 * which is larger than boundary 1 and less than boundary 2, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_RMT_ATTR2    0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_M  (SENSITIVE_EDMA_PMS_RMT_ATTR2_V << SENSITIVE_EDMA_PMS_RMT_ATTR2_S)
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_V  0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR2_S  2

/* SENSITIVE_EDMA_PMS_RMT_ATTR1 : R/W; bitpos: [1:0]; default: 3;
 * This field is used to configure the permission of RMT accessing address,
 * which is larger than boundary 0 and less than boundary 1, through EDMA.
 * Bit 0: set this bit to enable read permission. Bit 1: set this bit to
 * enable write permission.
 */

#define SENSITIVE_EDMA_PMS_RMT_ATTR1    0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_M  (SENSITIVE_EDMA_PMS_RMT_ATTR1_V << SENSITIVE_EDMA_PMS_RMT_ATTR1_S)
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_V  0x00000003
#define SENSITIVE_EDMA_PMS_RMT_ATTR1_S  0

/* SENSITIVE_CLOCK_GATE_REG_REG register
 * Sensitive module clock gate configuration register.
 */

#define SENSITIVE_CLOCK_GATE_REG_REG (DR_REG_SENSITIVE_BASE + 0x308)

/* SENSITIVE_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 * Set 1 to enable clock gate function.
 */

#define SENSITIVE_REG_CLK_EN    (BIT(0))
#define SENSITIVE_REG_CLK_EN_M  (SENSITIVE_REG_CLK_EN_V << SENSITIVE_REG_CLK_EN_S)
#define SENSITIVE_REG_CLK_EN_V  0x00000001
#define SENSITIVE_REG_CLK_EN_S  0

/* SENSITIVE_RTC_PMS_REG register
 * RTC coprocessor permission register.
 */

#define SENSITIVE_RTC_PMS_REG (DR_REG_SENSITIVE_BASE + 0x30c)

/* SENSITIVE_DIS_RTC_CPU : R/W; bitpos: [0]; default: 0;
 * Set 1 to disable rtc coprocessor.
 */

#define SENSITIVE_DIS_RTC_CPU    (BIT(0))
#define SENSITIVE_DIS_RTC_CPU_M  (SENSITIVE_DIS_RTC_CPU_V << SENSITIVE_DIS_RTC_CPU_S)
#define SENSITIVE_DIS_RTC_CPU_V  0x00000001
#define SENSITIVE_DIS_RTC_CPU_S  0

/* SENSITIVE_DATE_REG register
 * Sensitive version register.
 */

#define SENSITIVE_DATE_REG (DR_REG_SENSITIVE_BASE + 0xffc)

/* SENSITIVE_DATE : R/W; bitpos: [27:0]; default: 34607744;
 * Sensitive Date register.
 */

#define SENSITIVE_DATE    0x0fffffff
#define SENSITIVE_DATE_M  (SENSITIVE_DATE_V << SENSITIVE_DATE_S)
#define SENSITIVE_DATE_V  0x0fffffff
#define SENSITIVE_DATE_S  0

#endif /* __ARCH_XTENSA_SRC_ESP32S3_HARDWARE_ESP32S3_SENSITIVE_H */
