/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliations;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.DiscussionHistory;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Occupant;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Feature;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Identity;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoElement;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ItemRequestListener;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Room
implements InfoRequestListener,
ItemRequestListener {
    private EnumSet<RoomType> roomTypes;
    private Entity jid;
    private String name;
    private String password;
    private boolean rewriteDuplicateNick = true;
    private DiscussionHistory history = new DiscussionHistory();
    private Affiliations affiliations = new Affiliations();
    private Map<Entity, Occupant> occupants = new ConcurrentHashMap<Entity, Occupant>();

    public Room(Entity jid, String name, RoomType ... types) {
        EnumSet<RoomType> potentialTypes;
        if (jid == null) {
            throw new IllegalArgumentException("JID can not be null");
        }
        if (jid.getResource() != null) {
            throw new IllegalArgumentException("JID must be bare");
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Name can not be null or empty");
        }
        this.jid = jid;
        this.name = name;
        if (types != null && types.length > 0) {
            potentialTypes = EnumSet.copyOf(Arrays.asList(types));
            RoomType.validateAntonyms(potentialTypes);
        } else {
            potentialTypes = EnumSet.noneOf(RoomType.class);
        }
        this.roomTypes = RoomType.complement(potentialTypes);
    }

    public Entity getJID() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public EnumSet<RoomType> getRoomTypes() {
        return this.roomTypes.clone();
    }

    public boolean isRoomType(RoomType type) {
        return this.roomTypes.contains((Object)type);
    }

    public boolean rewritesDuplicateNick() {
        return this.rewriteDuplicateNick;
    }

    public void setRewriteDuplicateNick(boolean rewriteDuplicateNick) {
        this.rewriteDuplicateNick = rewriteDuplicateNick;
    }

    public Occupant addOccupant(Entity occupantJid, String name) {
        Affiliation affiliation = this.affiliations.getAffiliation(occupantJid);
        if (affiliation == Affiliation.Outcast) {
            throw new RuntimeException("forbidden");
        }
        if (affiliation == null) {
            affiliation = Affiliation.None;
        }
        Role role = Role.getRole(affiliation, this.roomTypes);
        Occupant occupant = new Occupant(occupantJid, name, this, role);
        if (this.isRoomType(RoomType.MembersOnly) && affiliation == Affiliation.None) {
            throw new RuntimeException("registration-required");
        }
        this.occupants.put(occupantJid, occupant);
        return occupant;
    }

    public Occupant findOccupantByJID(Entity occupantJid) {
        return this.occupants.get(occupantJid);
    }

    public Occupant findOccupantByNick(String nick) {
        for (Occupant occupant : this.getOccupants()) {
            if (!occupant.getNick().equals(nick)) continue;
            return occupant;
        }
        return null;
    }

    public Set<Occupant> getModerators() {
        return this.getByRole(Role.Moderator);
    }

    private Set<Occupant> getByRole(Role role) {
        HashSet<Occupant> matches = new HashSet<Occupant>();
        for (Occupant occupant : this.getOccupants()) {
            if (!role.equals((Object)occupant.getRole())) continue;
            matches.add(occupant);
        }
        return matches;
    }

    public boolean isInRoom(Entity jid) {
        return this.findOccupantByJID(jid) != null;
    }

    public boolean isInRoom(String nick) {
        return this.findOccupantByNick(nick) != null;
    }

    public void removeOccupant(Entity occupantJid) {
        this.occupants.remove(occupantJid);
    }

    public int getOccupantCount() {
        return this.occupants.size();
    }

    public boolean isEmpty() {
        return this.occupants.isEmpty();
    }

    public Set<Occupant> getOccupants() {
        HashSet<Occupant> set = new HashSet<Occupant>(this.occupants.values());
        return Collections.unmodifiableSet(set);
    }

    public List<InfoElement> getInfosFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        ArrayList<InfoElement> infoElements = new ArrayList<InfoElement>();
        infoElements.add((InfoElement)new Identity("conference", "text", this.getName()));
        infoElements.add((InfoElement)new Feature("http://jabber.org/protocol/muc"));
        for (RoomType type : this.roomTypes) {
            if (!type.includeInDisco()) continue;
            infoElements.add((InfoElement)new Feature(type.getDiscoName()));
        }
        return infoElements;
    }

    public List<Item> getItemsFor(InfoRequest request) throws ServiceDiscoveryRequestException {
        ArrayList<Item> items = new ArrayList<Item>();
        if (!this.isRoomType(RoomType.FullyAnonymous) && !this.isRoomType(RoomType.SemiAnonymous)) {
            for (Occupant occupant : this.getOccupants()) {
                items.add(new Item((Entity)new EntityImpl(this.getJID(), occupant.getNick())));
            }
        }
        return items;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DiscussionHistory getHistory() {
        return this.history;
    }

    public Affiliations getAffiliations() {
        return this.affiliations;
    }
}

