/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;

public class Occupant {
    private Room room;
    private Role role;
    private Entity jid;
    private String nick;

    public Occupant(Entity jid, String nick, Room room, Role role) {
        if (jid == null) {
            throw new IllegalArgumentException("JID can not be null");
        }
        if (nick == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        if (room == null) {
            throw new IllegalArgumentException("Room can not be null");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role can not be null");
        }
        this.jid = jid;
        this.nick = nick;
        this.room = room;
        this.role = role;
    }

    public Affiliation getAffiliation() {
        Affiliation affiliation = this.room.getAffiliations().getAffiliation(this.jid);
        if (affiliation == null) {
            affiliation = Affiliation.None;
        }
        return affiliation;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public Entity getJid() {
        return this.jid;
    }

    public boolean hasVoice() {
        return this.role == Role.Moderator || this.role == Role.Participant;
    }

    public String toString() {
        return this.jid.getFullQualifiedName();
    }

    public boolean isModerator() {
        return this.role == Role.Moderator;
    }

    public Entity getJidInRoom() {
        return new EntityImpl(this.room.getJID(), this.nick);
    }
}

