/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.RosterGroup;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RosterStanzaUtils {
    public static StanzaBuilder createRosterItemsIQ(Entity to, String id, IQStanzaType type, Iterable<RosterItem> rosterItems) {
        StanzaBuilder stanzaBuilder = (StanzaBuilder)StanzaBuilder.createIQStanza(null, to, type, id).startInnerElement("query", "jabber:iq:roster");
        for (RosterItem rosterItem : rosterItems) {
            RosterStanzaUtils.createRosterItem(stanzaBuilder, rosterItem);
        }
        stanzaBuilder.endInnerElement();
        return stanzaBuilder;
    }

    public static Stanza createRosterItemPushIQ(Entity to, String id, RosterItem rosterItem) {
        return RosterStanzaUtils.createRosterItemIQ(to, id, IQStanzaType.SET, rosterItem);
    }

    public static Stanza createRosterItemIQ(Entity to, String id, IQStanzaType iqStanzaType, RosterItem rosterItem) {
        ArrayList<RosterItem> itemList = new ArrayList<RosterItem>();
        itemList.add(rosterItem);
        return (Stanza)RosterStanzaUtils.createRosterItemsIQ(to, id, iqStanzaType, itemList).build();
    }

    public static void createRosterItem(StanzaBuilder stanzaBuilder, RosterItem rosterItem) {
        List<RosterGroup> groupList;
        ((StanzaBuilder)stanzaBuilder.startInnerElement("item", "jabber:iq:roster")).addAttribute("jid", rosterItem.getJid().getFullQualifiedName());
        if (rosterItem.getName() != null) {
            stanzaBuilder.addAttribute("name", rosterItem.getName());
        }
        if (rosterItem.getSubscriptionType() != null) {
            stanzaBuilder.addAttribute("subscription", rosterItem.getSubscriptionType().value());
        }
        if (rosterItem.getAskSubscriptionType() != AskSubscriptionType.NOT_SET) {
            stanzaBuilder.addAttribute("ask", rosterItem.getAskSubscriptionType().value());
        }
        if ((groupList = rosterItem.getGroups()) != null) {
            for (RosterGroup rosterGroup : groupList) {
                ((StanzaBuilder)((StanzaBuilder)stanzaBuilder.startInnerElement("group", "jabber:iq:roster")).addText(rosterGroup.getName())).endInnerElement();
            }
        }
        stanzaBuilder.endInnerElement();
    }
}

