/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common.function;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.PDRange;
import org.pdfbox.pdmodel.common.function.PDFunction;

public abstract class PDDictionaryFunction
extends PDFunction {
    private COSDictionary function = null;

    protected PDDictionaryFunction(int functionType) {
        this.function = new COSDictionary();
        this.function.setInt("FunctionType", functionType);
    }

    public PDDictionaryFunction(COSDictionary functionDictionary) {
        this.function = functionDictionary;
    }

    public COSBase getCOSObject() {
        return this.function;
    }

    public COSDictionary getCOSDictionary() {
        return this.function;
    }

    private COSArray getRangeArray(String fieldName, int n) {
        COSArray rangeArray = (COSArray)this.function.getDictionaryObject(COSName.getPDFName("Range"));
        if (rangeArray == null) {
            rangeArray = new COSArray();
            this.function.setItem(fieldName, (COSBase)rangeArray);
            while (rangeArray.size() < n * 2) {
                rangeArray.add(new COSFloat(0.0f));
                rangeArray.add(new COSFloat(0.0f));
            }
        }
        return rangeArray;
    }

    public int getNumberOfOutputParameters() {
        COSArray array = this.getRangeArray("Range", 0);
        return array.size() / 2;
    }

    public PDRange getRangeForOutput(int n) {
        COSArray rangeArray = this.getRangeArray("Range", n);
        return new PDRange(rangeArray, n);
    }

    public void setRangeForOutput(PDRange range, int n) {
        COSArray rangeArray = this.getRangeArray("Range", n);
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }

    public int getNumberOfInputParameters() {
        COSArray array = this.getRangeArray("Domain", 0);
        return array.size() / 2;
    }

    public PDRange getDomainForInput(int n) {
        COSArray rangeArray = this.getRangeArray("Domain", n);
        return new PDRange(rangeArray, n);
    }

    public void setDomainForInput(PDRange range, int n) {
        COSArray rangeArray = this.getRangeArray("Domain", n);
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }
}

