/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.u2f.SkEcdsaPublicKey;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;

public class SkECDSAPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final String KEY_TYPE = "sk-ecdsa-sha2-nistp256@openssh.com";
    public static final int MAX_APP_NAME_LENGTH = 1024;
    public static final SkECDSAPublicKeyEntryDecoder INSTANCE = new SkECDSAPublicKeyEntryDecoder();
    private static final String NO_TOUCH_REQUIRED_HEADER = "no-touch-required";
    private static final String VERIFY_REQUIRED_HEADER = "verify-required";

    public SkECDSAPublicKeyEntryDecoder() {
        super(Collections.singleton(KEY_TYPE));
    }

    @Override
    public SkEcdsaPublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (!KEY_TYPE.equals(keyType)) {
            throw new InvalidKeySpecException("Invalid keyType: " + keyType);
        }
        boolean noTouchRequired = this.parseBooleanHeader(headers, NO_TOUCH_REQUIRED_HEADER, false);
        boolean verifyRequired = this.parseBooleanHeader(headers, VERIFY_REQUIRED_HEADER, false);
        PublicKey pk = ECDSAPublicKeyEntryDecoder.INSTANCE.decodePublicKey(ECCurves.nistp256, keyData);
        ECPublicKey ecPublicKey = ValidateUtils.checkInstanceOf(pk, ECPublicKey.class, "Key must be an ECPublicKey");
        String appName = KeyEntryResolver.decodeString(keyData, 1024);
        return new SkEcdsaPublicKey(appName, noTouchRequired, verifyRequired, ecPublicKey);
    }

    @Override
    public String encodePublicKey(OutputStream s, PublicKey k) throws IOException {
        SkEcdsaPublicKey key = ValidateUtils.checkInstanceOf(k, SkEcdsaPublicKey.class, "Key must be an SkEcdsaPublicKey");
        ECDSAPublicKeyEntryDecoder.encodePublicKey(s, KEY_TYPE, ECCurves.nistp256, key.getDelegatePublicKey().getW());
        KeyEntryResolver.encodeString(s, key.getAppName());
        return KEY_TYPE;
    }

    @Override
    public KeyFactory getKeyFactoryInstance() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() {
        throw new UnsupportedOperationException("Private key operations are not supported for security keys.");
    }
}

