/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.global;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler {
    public static final String REQUEST = "hostkeys-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler();

    public OpenSshHostKeysHandler() {
        super(REQUEST);
        this.setIgnoreInvalidKeys(true);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
        this.setIgnoreInvalidKeys(true);
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue((!wantReply ? 1 : 0) != 0, (String)"Unexpected reply required for the host keys of %s", (Object)session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys", new Object[]{session, wantReply, GenericUtils.size(keys)});
        }
        ClientSession client = (ClientSession)ValidateUtils.checkInstanceOf((Object)session, ClientSession.class, (String)"handleHostKeys(%s) called on a ServerSession", (Object)session);
        List<PublicKey> validKeys = keys.stream().filter(key -> {
            if (key instanceof OpenSshCertificate) {
                return this.isValidHostCertificate(client, (OpenSshCertificate)key);
            }
            return !(key instanceof UnsupportedSshPublicKey);
        }).collect(Collectors.toList());
        Buffer request = session.createBuffer((byte)80);
        request.putString("hostkeys-prove-00@openssh.com");
        request.putBoolean(true);
        validKeys.forEach(arg_0 -> ((Buffer)request).putPublicKey(arg_0));
        client.request(request, "hostkeys-prove-00@openssh.com", (cmd, reply) -> {
            if (cmd == 81) {
                this.handleHostKeyRotation(client, validKeys, reply);
            }
        });
        return RequestHandler.Result.Replied;
    }

    protected void handleHostKeyRotation(ClientSession client, List<PublicKey> proposedKeys, Buffer reply) {
        ArrayList<PublicKey> newKeys = new ArrayList<PublicKey>();
        proposedKeys.forEach(k -> {
            Signature verifier;
            String algo;
            byte[] signature = reply.getBytes();
            String keyType = KeyUtils.getKeyType((Key)k);
            PublicKey signingKey = k;
            if (k instanceof OpenSshCertificate) {
                signingKey = ((OpenSshCertificate)k).getCertPubKey();
            }
            if ("ssh-rsa".equals(algo = KeyUtils.getKeyType((Key)signingKey))) {
                String negotiated = (String)client.getKexNegotiationResult().get(KexProposalOption.ALGORITHMS);
                String canonical = KeyUtils.getCanonicalKeyType((String)negotiated);
                if ("ssh-rsa".equals(canonical) || "ssh-rsa-cert-v01@openssh.com".equals(canonical)) {
                    algo = KeyUtils.getSignatureAlgorithm((String)negotiated);
                } else {
                    ByteArrayBuffer sigBuf = new ByteArrayBuffer(signature);
                    try {
                        algo = sigBuf.getString();
                        if ("ssh-rsa".equals(algo) || !"ssh-rsa".equals(KeyUtils.getCanonicalKeyType((String)algo))) {
                            return;
                        }
                    }
                    catch (BufferException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("handleHostKeyRotation({}) ignoring {} key because signature data is invalid", (Object)client, (Object)keyType);
                        }
                        return;
                    }
                }
            }
            if ((verifier = (Signature)NamedFactory.create((Collection)client.getSignatureFactories(), (String)algo)) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleHostKeyRotation({}) ignoring {} key because no signature verifier for {}", new Object[]{client, keyType, algo});
                }
                return;
            }
            ByteArrayBuffer expected = new ByteArrayBuffer();
            expected.putString("hostkeys-prove-00@openssh.com");
            expected.putBytes(client.getSessionId());
            expected.putPublicKey(k);
            byte[] data = expected.getCompactData();
            try {
                verifier.initVerifier((SessionContext)client, signingKey);
                verifier.update((SessionContext)client, data);
                if (!verifier.verify((SessionContext)client, signature)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("handleHostKeyRotation({}) ignoring {} key because {} signature doesn't match", new Object[]{client, keyType, algo});
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleHostKeyRotation({}) ignoring {} key: exception during {} signature verification: {}", new Object[]{client, keyType, algo, e.toString()});
                }
                return;
            }
            newKeys.add((PublicKey)k);
        });
        if (reply.available() > 0) {
            this.log.warn("handleHostKeyRotation({}) extra data of {} bytes ignored", (Object)client, (Object)reply.available());
        }
        if (!newKeys.isEmpty()) {
            client.getFactoryManager().getNewHostKeysHandler().receiveNewHostKeys(client, newKeys);
        }
    }

    private boolean isValidHostCertificate(ClientSession session, OpenSshCertificate cert) {
        if (!(OpenSshCertificate.Type.HOST.equals((Object)cert.getType()) && OpenSshCertificate.isValidNow((OpenSshCertificate)cert) && cert.getCriticalOptions().isEmpty())) {
            return false;
        }
        try {
            if (!OpenSshCertificate.verifySignature((OpenSshCertificate)cert, (List)session.getSignatureFactories())) {
                return false;
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("isValidHostCertificate({}) could not verify host ertificate signature; got {}", (Object)session, (Object)e.toString());
            }
            return false;
        }
        Collection principals = cert.getPrincipals();
        if (!GenericUtils.isEmpty((Collection)principals)) {
            SocketAddress connectSocketAddress = session.getConnectAddress();
            String hostName = null;
            if (connectSocketAddress instanceof SshdSocketAddress) {
                hostName = ((SshdSocketAddress)connectSocketAddress).getHostName();
            } else if (connectSocketAddress instanceof InetSocketAddress) {
                hostName = ((InetSocketAddress)connectSocketAddress).getHostString();
            }
            return hostName != null && principals.contains(hostName);
        }
        return true;
    }
}

