/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettyIoServiceFactory;
import org.apache.sshd.netty.NettyIoSession;

public class NettyIoConnector
extends NettyIoService
implements IoConnector {
    private static final LoggingHandler LOGGING_TRACE = new LoggingHandler(NettyIoConnector.class, LogLevel.TRACE);

    public NettyIoConnector(NettyIoServiceFactory factory, IoHandler handler) {
        super(factory, handler);
        this.channelGroup = new DefaultChannelGroup("sshd-connector-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public IoConnectFuture connect(SocketAddress address, final AttributeRepository context, SocketAddress localAddress) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.factory.eventLoopGroup)).channel(NioSocketChannel.class)).attr(CONNECT_FUTURE_KEY, (Object)future)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                IoServiceEventListener listener = NettyIoConnector.this.getIoServiceEventListener();
                InetSocketAddress local = ch.localAddress();
                InetSocketAddress remote = ch.remoteAddress();
                try {
                    if (listener != null) {
                        try {
                            listener.connectionEstablished((IoConnector)NettyIoConnector.this, (SocketAddress)local, context, (SocketAddress)remote);
                        }
                        catch (Exception e) {
                            ch.close();
                            throw e;
                        }
                    }
                    NettyIoSession session = new NettyIoSession(NettyIoConnector.this, NettyIoConnector.this.handler, null);
                    if (context != null) {
                        session.setAttribute(AttributeRepository.class, context);
                    }
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{LOGGING_TRACE});
                    p.addLast(new ChannelHandler[]{session.adapter});
                }
                catch (Exception e) {
                    block9: {
                        if (listener != null) {
                            try {
                                listener.abortEstablishedConnection((IoConnector)NettyIoConnector.this, (SocketAddress)local, context, (SocketAddress)remote, (Throwable)e);
                            }
                            catch (Exception exc) {
                                if (!NettyIoConnector.this.log.isDebugEnabled()) break block9;
                                NettyIoConnector.this.log.debug("initChannel(" + ch + ") listener=" + listener + " ignoring abort event exception", (Throwable)exc);
                            }
                        }
                    }
                    throw e;
                }
            }
        });
        ChannelFuture chf = localAddress != null ? bootstrap.connect(address, localAddress) : bootstrap.connect(address);
        chf.addListener(cf -> {
            Throwable t = cf.cause();
            if (t != null) {
                future.setException(t);
            } else if (cf.isCancelled()) {
                future.cancel();
            }
        });
        return future;
    }

    public static class DefaultIoConnectFuture
    extends DefaultSshFuture<IoConnectFuture>
    implements IoConnectFuture {
        public DefaultIoConnectFuture(Object id, Object lock) {
            super(id, lock);
        }

        public IoSession getSession() {
            Object v = this.getValue();
            return v instanceof IoSession ? (IoSession)v : null;
        }

        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        public boolean isConnected() {
            Object v = this.getValue();
            return v instanceof IoSession;
        }

        public void setSession(IoSession session) {
            this.setValue(session);
        }

        public void setException(Throwable exception) {
            this.setValue(exception);
        }
    }
}

