/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.maven.api.Language;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Source;
import org.apache.maven.impl.PathSelector;

public record DefaultSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nullable String moduleName, @Nullable Version targetVersionOrNull, @Nonnull Path directory, @Nonnull List<String> includes, @Nonnull List<String> excludes, boolean stringFiltering, @Nullable Path targetPathOrNull, boolean enabled) implements SourceRoot
{
    public DefaultSourceRoot(ProjectScope scope, Language language, Path directory) {
        this(scope, language, null, null, directory, null, null, false, null, true);
    }

    public DefaultSourceRoot(@Nonnull ProjectScope scope, @Nonnull Language language, @Nullable String moduleName, @Nullable Version targetVersionOrNull, @Nullable Path directory, @Nullable List<String> includes, @Nullable List<String> excludes, boolean stringFiltering, @Nullable Path targetPathOrNull, boolean enabled) {
        this.scope = Objects.requireNonNull(scope);
        this.language = Objects.requireNonNull(language);
        this.moduleName = DefaultSourceRoot.nonBlank(moduleName).orElse(null);
        this.targetVersionOrNull = targetVersionOrNull;
        this.directory = directory.normalize();
        this.includes = includes != null ? List.copyOf(includes) : List.of();
        this.excludes = excludes != null ? List.copyOf(excludes) : List.of();
        this.stringFiltering = stringFiltering;
        this.targetPathOrNull = targetPathOrNull != null ? targetPathOrNull.normalize() : null;
        this.enabled = enabled;
    }

    public DefaultSourceRoot(Path baseDir, ProjectScope scope, Resource resource) {
        this(scope, Language.RESOURCES, null, null, baseDir.resolve(DefaultSourceRoot.nonBlank(resource.getDirectory()).orElseThrow(() -> new IllegalArgumentException("Source declaration without directory value."))), resource.getIncludes(), resource.getExcludes(), Boolean.parseBoolean(resource.getFiltering()), DefaultSourceRoot.nonBlank(resource.getTargetPath()).map(x$0 -> Path.of(x$0, new String[0])).orElse(null), true);
    }

    public static DefaultSourceRoot fromModel(Session session, Path baseDir, Function<ProjectScope, String> outputDir, Source source) {
        ProjectScope scope = DefaultSourceRoot.nonBlank(source.getScope()).map(arg_0 -> ((Session)session).requireProjectScope(arg_0)).orElse(ProjectScope.MAIN);
        Language language = DefaultSourceRoot.nonBlank(source.getLang()).map(arg_0 -> ((Session)session).requireLanguage(arg_0)).orElse(Language.JAVA_FAMILY);
        String moduleName = DefaultSourceRoot.nonBlank(source.getModule()).orElse(null);
        return new DefaultSourceRoot(scope, language, moduleName, DefaultSourceRoot.nonBlank(source.getTargetVersion()).map(arg_0 -> ((Session)session).parseVersion(arg_0)).orElse(null), DefaultSourceRoot.nonBlank(source.getDirectory()).map(baseDir::resolve).orElseGet(() -> {
            Path src = baseDir.resolve("src");
            if (moduleName != null) {
                src = src.resolve(moduleName);
            }
            return src.resolve(scope.id()).resolve(language.id());
        }), source.getIncludes(), source.getExcludes(), source.isStringFiltering(), DefaultSourceRoot.nonBlank(source.getTargetPath()).map(x$0 -> Path.of(x$0, new String[0])).orElse(null), source.isEnabled());
    }

    private static Optional<String> nonBlank(String value) {
        if (value != null && !(value = value.trim()).isBlank()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public PathMatcher matcher(Collection<String> defaultIncludes, boolean useDefaultExcludes) {
        Collection<String> actual = this.includes();
        if (actual == null || actual.isEmpty()) {
            actual = defaultIncludes;
        }
        return PathSelector.of(this.directory(), actual, this.excludes(), useDefaultExcludes);
    }

    public Optional<String> module() {
        return Optional.ofNullable(this.moduleName);
    }

    public Optional<Version> targetVersion() {
        return Optional.ofNullable(this.targetVersionOrNull);
    }

    public Optional<Path> targetPath() {
        return Optional.ofNullable(this.targetPathOrNull);
    }
}

