/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Objects;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;

public final class ManagedScopeDeriver
extends ConflictResolver.ScopeDeriver {
    private final InternalScopeManager scopeManager;
    private final DependencyScope systemScope;

    public ManagedScopeDeriver(InternalScopeManager scopeManager) {
        this.scopeManager = Objects.requireNonNull(scopeManager, "scopeManager");
        this.systemScope = scopeManager.getSystemDependencyScope().orElse(null);
    }

    public void deriveScope(ConflictResolver.ScopeContext context) {
        context.setDerivedScope(this.getDerivedScope(context.getParentScope(), context.getChildScope()));
    }

    public String getDerivedScope(String parentScope, String childScope) {
        int childWidth;
        DependencyScope parent = parentScope != null ? (DependencyScope)this.scopeManager.getDependencyScope(parentScope).orElse(null) : null;
        DependencyScope child = this.scopeManager.getDependencyScope(childScope).orElse(null);
        if (this.systemScope != null && this.systemScope == child) {
            return this.systemScope.getId();
        }
        if (parent == null) {
            return child != null ? child.getId() : "";
        }
        if (child == null) {
            return parent.getId();
        }
        int parentWidth = this.scopeManager.getDependencyScopeWidth(parent);
        if (parentWidth < (childWidth = this.scopeManager.getDependencyScopeWidth(child))) {
            return parent.getId();
        }
        return child.getId();
    }
}

