/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.wagon;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporter;

@Named(value="wagon")
public final class WagonTransporterFactory
implements TransporterFactory {
    public static final String NAME = "wagon";
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final PathProcessor pathProcessor;
    private float priority = -1.0f;

    @Inject
    public WagonTransporterFactory(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, PathProcessor pathProcessor) {
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.pathProcessor = pathProcessor;
    }

    public float getPriority() {
        return this.priority;
    }

    public WagonTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new WagonTransporter(this.wagonProvider, this.wagonConfigurator, repository, session, this.pathProcessor);
    }
}

